/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.Device;
import software.amazon.awssdk.services.sagemaker.model.DevicesCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterDevicesRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, RegisterDevicesRequest> {
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetName").getter(RegisterDevicesRequest.getter(RegisterDevicesRequest::deviceFleetName)).setter(RegisterDevicesRequest.setter(Builder::deviceFleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()}).build();
    private static final SdkField<List<Device>> DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Devices").getter(RegisterDevicesRequest.getter(RegisterDevicesRequest::devices)).setter(RegisterDevicesRequest.setter(Builder::devices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Devices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Device::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RegisterDevicesRequest.getter(RegisterDevicesRequest::tags)).setter(RegisterDevicesRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FLEET_NAME_FIELD, DEVICES_FIELD, TAGS_FIELD));
    private final String deviceFleetName;
    private final List<Device> devices;
    private final List<Tag> tags;

    private RegisterDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.deviceFleetName = builder.deviceFleetName;
        this.devices = builder.devices;
        this.tags = builder.tags;
    }

    public final String deviceFleetName() {
        return this.deviceFleetName;
    }

    public final boolean hasDevices() {
        return this.devices != null && !(this.devices instanceof SdkAutoConstructList);
    }

    public final List<Device> devices() {
        return this.devices;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDevices() ? this.devices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterDevicesRequest)) {
            return false;
        }
        RegisterDevicesRequest other = (RegisterDevicesRequest)((Object)obj);
        return Objects.equals(this.deviceFleetName(), other.deviceFleetName()) && this.hasDevices() == other.hasDevices() && Objects.equals(this.devices(), other.devices()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterDevicesRequest").add("DeviceFleetName", (Object)this.deviceFleetName()).add("Devices", this.hasDevices() ? this.devices() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceFleetName": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetName()));
            }
            case "Devices": {
                return Optional.ofNullable(clazz.cast(this.devices()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterDevicesRequest, T> g) {
        return obj -> g.apply((RegisterDevicesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String deviceFleetName;
        private List<Device> devices = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterDevicesRequest model) {
            super(model);
            this.deviceFleetName(model.deviceFleetName);
            this.devices(model.devices);
            this.tags(model.tags);
        }

        public final String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        public final Collection<Device.Builder> getDevices() {
            if (this.devices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.devices != null ? (Collection)this.devices.stream().map(Device::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devices(Collection<Device> devices) {
            this.devices = DevicesCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Device ... devices) {
            this.devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<Device.Builder> ... devices) {
            this.devices(Stream.of(devices).map(c -> (Device)((Device.Builder)Device.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevices(Collection<Device.BuilderImpl> devices) {
            this.devices = DevicesCopier.copyFromBuilder(devices);
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterDevicesRequest build() {
            return new RegisterDevicesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterDevicesRequest> {
        public Builder deviceFleetName(String var1);

        public Builder devices(Collection<Device> var1);

        public Builder devices(Device ... var1);

        public Builder devices(Consumer<Device.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

