/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.EventDetails;
import software.amazon.awssdk.services.sesv2.model.EventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightsEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightsEvent> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(InsightsEvent.getter(InsightsEvent::timestamp)).setter(InsightsEvent.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(InsightsEvent.getter(InsightsEvent::typeAsString)).setter(InsightsEvent.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<EventDetails> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Details").getter(InsightsEvent.getter(InsightsEvent::details)).setter(InsightsEvent.setter(Builder::details)).constructor(EventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, TYPE_FIELD, DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InsightsEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final String type;
    private final EventDetails details;

    private InsightsEvent(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.type = builder.type;
        this.details = builder.details;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final EventType type() {
        return EventType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final EventDetails details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightsEvent)) {
            return false;
        }
        InsightsEvent other = (InsightsEvent)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.details(), other.details());
    }

    public final String toString() {
        return ToString.builder((String)"InsightsEvent").add("Timestamp", (Object)this.timestamp()).add("Type", (Object)this.typeAsString()).add("Details", (Object)this.details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Details", DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightsEvent, T> g) {
        return obj -> g.apply((InsightsEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private String type;
        private EventDetails details;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightsEvent model) {
            this.timestamp(model.timestamp);
            this.type(model.type);
            this.details(model.details);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EventType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final EventDetails.Builder getDetails() {
            return this.details != null ? this.details.toBuilder() : null;
        }

        public final void setDetails(EventDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(EventDetails details) {
            this.details = details;
            return this;
        }

        public InsightsEvent build() {
            return new InsightsEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightsEvent> {
        public Builder timestamp(Instant var1);

        public Builder type(String var1);

        public Builder type(EventType var1);

        public Builder details(EventDetails var1);

        default public Builder details(Consumer<EventDetails.Builder> details) {
            return this.details((EventDetails)((EventDetails.Builder)EventDetails.builder().applyMutation(details)).build());
        }
    }
}

