/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartExecutionResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, StartExecutionResponse> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionArn").getter(StartExecutionResponse.getter(StartExecutionResponse::executionArn)).setter(StartExecutionResponse.setter(Builder::executionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDate").getter(StartExecutionResponse.getter(StartExecutionResponse::startDate)).setter(StartExecutionResponse.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD, START_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartExecutionResponse.memberNameToFieldInitializer();
    private final String executionArn;
    private final Instant startDate;

    private StartExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.startDate = builder.startDate;
    }

    public final String executionArn() {
        return this.executionArn;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExecutionResponse)) {
            return false;
        }
        StartExecutionResponse other = (StartExecutionResponse)((Object)obj);
        return Objects.equals(this.executionArn(), other.executionArn()) && Objects.equals(this.startDate(), other.startDate());
    }

    public final String toString() {
        return ToString.builder((String)"StartExecutionResponse").add("ExecutionArn", (Object)this.executionArn()).add("StartDate", (Object)this.startDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionArn": {
                return Optional.ofNullable(clazz.cast(this.executionArn()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("executionArn", EXECUTION_ARN_FIELD);
        map.put("startDate", START_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartExecutionResponse, T> g) {
        return obj -> g.apply((StartExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String executionArn;
        private Instant startDate;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExecutionResponse model) {
            super(model);
            this.executionArn(model.executionArn);
            this.startDate(model.startDate);
        }

        public final String getExecutionArn() {
            return this.executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        @Override
        public StartExecutionResponse build() {
            return new StartExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartExecutionResponse> {
        public Builder executionArn(String var1);

        public Builder startDate(Instant var1);
    }
}

