/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sfn.SfnClient;
import software.amazon.awssdk.services.sfn.internal.UserAgentUtils;
import software.amazon.awssdk.services.sfn.model.ActivityListItem;
import software.amazon.awssdk.services.sfn.model.ListActivitiesRequest;
import software.amazon.awssdk.services.sfn.model.ListActivitiesResponse;

public class ListActivitiesIterable
implements SdkIterable<ListActivitiesResponse> {
    private final SfnClient client;
    private final ListActivitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListActivitiesIterable(SfnClient client, ListActivitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListActivitiesResponseFetcher();
    }

    public Iterator<ListActivitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActivityListItem> activities() {
        Function<ListActivitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.activities() != null) {
                return response.activities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListActivitiesResponseFetcher
    implements SyncPageFetcher<ListActivitiesResponse> {
        private ListActivitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListActivitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListActivitiesResponse nextPage(ListActivitiesResponse previousPage) {
            if (previousPage == null) {
                return ListActivitiesIterable.this.client.listActivities(ListActivitiesIterable.this.firstRequest);
            }
            return ListActivitiesIterable.this.client.listActivities((ListActivitiesRequest)((Object)ListActivitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

