/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sns.model.PublishBatchRequestEntry;
import software.amazon.awssdk.services.sns.model.PublishBatchRequestEntryListCopier;
import software.amazon.awssdk.services.sns.model.SnsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishBatchRequest
extends SnsRequest
implements ToCopyableBuilder<Builder, PublishBatchRequest> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(PublishBatchRequest.getter(PublishBatchRequest::topicArn)).setter(PublishBatchRequest.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<List<PublishBatchRequestEntry>> PUBLISH_BATCH_REQUEST_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PublishBatchRequestEntries").getter(PublishBatchRequest.getter(PublishBatchRequest::publishBatchRequestEntries)).setter(PublishBatchRequest.setter(Builder::publishBatchRequestEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishBatchRequestEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PublishBatchRequestEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD, PUBLISH_BATCH_REQUEST_ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PublishBatchRequest.memberNameToFieldInitializer();
    private final String topicArn;
    private final List<PublishBatchRequestEntry> publishBatchRequestEntries;

    private PublishBatchRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.publishBatchRequestEntries = builder.publishBatchRequestEntries;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public final boolean hasPublishBatchRequestEntries() {
        return this.publishBatchRequestEntries != null && !(this.publishBatchRequestEntries instanceof SdkAutoConstructList);
    }

    public final List<PublishBatchRequestEntry> publishBatchRequestEntries() {
        return this.publishBatchRequestEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublishBatchRequestEntries() ? this.publishBatchRequestEntries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishBatchRequest)) {
            return false;
        }
        PublishBatchRequest other = (PublishBatchRequest)((Object)obj);
        return Objects.equals(this.topicArn(), other.topicArn()) && this.hasPublishBatchRequestEntries() == other.hasPublishBatchRequestEntries() && Objects.equals(this.publishBatchRequestEntries(), other.publishBatchRequestEntries());
    }

    public final String toString() {
        return ToString.builder((String)"PublishBatchRequest").add("TopicArn", (Object)this.topicArn()).add("PublishBatchRequestEntries", this.hasPublishBatchRequestEntries() ? this.publishBatchRequestEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "PublishBatchRequestEntries": {
                return Optional.ofNullable(clazz.cast(this.publishBatchRequestEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TopicArn", TOPIC_ARN_FIELD);
        map.put("PublishBatchRequestEntries", PUBLISH_BATCH_REQUEST_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PublishBatchRequest, T> g) {
        return obj -> g.apply((PublishBatchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnsRequest.BuilderImpl
    implements Builder {
        private String topicArn;
        private List<PublishBatchRequestEntry> publishBatchRequestEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PublishBatchRequest model) {
            super(model);
            this.topicArn(model.topicArn);
            this.publishBatchRequestEntries(model.publishBatchRequestEntries);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final List<PublishBatchRequestEntry.Builder> getPublishBatchRequestEntries() {
            List<PublishBatchRequestEntry.Builder> result = PublishBatchRequestEntryListCopier.copyToBuilder(this.publishBatchRequestEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPublishBatchRequestEntries(Collection<PublishBatchRequestEntry.BuilderImpl> publishBatchRequestEntries) {
            this.publishBatchRequestEntries = PublishBatchRequestEntryListCopier.copyFromBuilder(publishBatchRequestEntries);
        }

        @Override
        public final Builder publishBatchRequestEntries(Collection<PublishBatchRequestEntry> publishBatchRequestEntries) {
            this.publishBatchRequestEntries = PublishBatchRequestEntryListCopier.copy(publishBatchRequestEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publishBatchRequestEntries(PublishBatchRequestEntry ... publishBatchRequestEntries) {
            this.publishBatchRequestEntries(Arrays.asList(publishBatchRequestEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publishBatchRequestEntries(Consumer<PublishBatchRequestEntry.Builder> ... publishBatchRequestEntries) {
            this.publishBatchRequestEntries(Stream.of(publishBatchRequestEntries).map(c -> (PublishBatchRequestEntry)((PublishBatchRequestEntry.Builder)PublishBatchRequestEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishBatchRequest build() {
            return new PublishBatchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SnsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishBatchRequest> {
        public Builder topicArn(String var1);

        public Builder publishBatchRequestEntries(Collection<PublishBatchRequestEntry> var1);

        public Builder publishBatchRequestEntries(PublishBatchRequestEntry ... var1);

        public Builder publishBatchRequestEntries(Consumer<PublishBatchRequestEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

