/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.InventoryDeletionSummary;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteInventoryResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DeleteInventoryResponse> {
    private static final SdkField<String> DELETION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeletionId").getter(DeleteInventoryResponse.getter(DeleteInventoryResponse::deletionId)).setter(DeleteInventoryResponse.setter(Builder::deletionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionId").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(DeleteInventoryResponse.getter(DeleteInventoryResponse::typeName)).setter(DeleteInventoryResponse.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<InventoryDeletionSummary> DELETION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeletionSummary").getter(DeleteInventoryResponse.getter(DeleteInventoryResponse::deletionSummary)).setter(DeleteInventoryResponse.setter(Builder::deletionSummary)).constructor(InventoryDeletionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETION_ID_FIELD, TYPE_NAME_FIELD, DELETION_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteInventoryResponse.memberNameToFieldInitializer();
    private final String deletionId;
    private final String typeName;
    private final InventoryDeletionSummary deletionSummary;

    private DeleteInventoryResponse(BuilderImpl builder) {
        super(builder);
        this.deletionId = builder.deletionId;
        this.typeName = builder.typeName;
        this.deletionSummary = builder.deletionSummary;
    }

    public final String deletionId() {
        return this.deletionId;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final InventoryDeletionSummary deletionSummary() {
        return this.deletionSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInventoryResponse)) {
            return false;
        }
        DeleteInventoryResponse other = (DeleteInventoryResponse)((Object)obj);
        return Objects.equals(this.deletionId(), other.deletionId()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.deletionSummary(), other.deletionSummary());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteInventoryResponse").add("DeletionId", (Object)this.deletionId()).add("TypeName", (Object)this.typeName()).add("DeletionSummary", (Object)this.deletionSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeletionId": {
                return Optional.ofNullable(clazz.cast(this.deletionId()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "DeletionSummary": {
                return Optional.ofNullable(clazz.cast(this.deletionSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeletionId", DELETION_ID_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("DeletionSummary", DELETION_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteInventoryResponse, T> g) {
        return obj -> g.apply((DeleteInventoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String deletionId;
        private String typeName;
        private InventoryDeletionSummary deletionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInventoryResponse model) {
            super(model);
            this.deletionId(model.deletionId);
            this.typeName(model.typeName);
            this.deletionSummary(model.deletionSummary);
        }

        public final String getDeletionId() {
            return this.deletionId;
        }

        public final void setDeletionId(String deletionId) {
            this.deletionId = deletionId;
        }

        @Override
        public final Builder deletionId(String deletionId) {
            this.deletionId = deletionId;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final InventoryDeletionSummary.Builder getDeletionSummary() {
            return this.deletionSummary != null ? this.deletionSummary.toBuilder() : null;
        }

        public final void setDeletionSummary(InventoryDeletionSummary.BuilderImpl deletionSummary) {
            this.deletionSummary = deletionSummary != null ? deletionSummary.build() : null;
        }

        @Override
        public final Builder deletionSummary(InventoryDeletionSummary deletionSummary) {
            this.deletionSummary = deletionSummary;
            return this;
        }

        @Override
        public DeleteInventoryResponse build() {
            return new DeleteInventoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteInventoryResponse> {
        public Builder deletionId(String var1);

        public Builder typeName(String var1);

        public Builder deletionSummary(InventoryDeletionSummary var1);

        default public Builder deletionSummary(Consumer<InventoryDeletionSummary.Builder> deletionSummary) {
            return this.deletionSummary((InventoryDeletionSummary)((InventoryDeletionSummary.Builder)InventoryDeletionSummary.builder().applyMutation(deletionSummary)).build());
        }
    }
}

