/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.CommandInvocation;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse;

public class ListCommandInvocationsPublisher
implements SdkPublisher<ListCommandInvocationsResponse> {
    private final SsmAsyncClient client;
    private final ListCommandInvocationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCommandInvocationsPublisher(SsmAsyncClient client, ListCommandInvocationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCommandInvocationsPublisher(SsmAsyncClient client, ListCommandInvocationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCommandInvocationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCommandInvocationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CommandInvocation> commandInvocations() {
        Function<ListCommandInvocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commandInvocations() != null) {
                return response.commandInvocations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCommandInvocationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCommandInvocationsResponseFetcher
    implements AsyncPageFetcher<ListCommandInvocationsResponse> {
        private ListCommandInvocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandInvocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCommandInvocationsResponse> nextPage(ListCommandInvocationsResponse previousPage) {
            if (previousPage == null) {
                return ListCommandInvocationsPublisher.this.client.listCommandInvocations(ListCommandInvocationsPublisher.this.firstRequest);
            }
            return ListCommandInvocationsPublisher.this.client.listCommandInvocations((ListCommandInvocationsRequest)((Object)ListCommandInvocationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

