/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam.internals;

import com.amazonaws.util.ClassLoaderHelper;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.VersionInfoUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserAgentUtils {
    private static final Logger log = LoggerFactory.getLogger(UserAgentUtils.class);
    private static final String USER_AGENT_SEP = "/";
    private static final String USER_AGENT_NAME = "aws-msk-iam-auth";
    private static final String VERSION_INFO_FILE = "version.properties";
    private static final String[] AGENT_COMPONENTS = new String[]{"aws-msk-iam-auth", UserAgentUtils.getLibraryVersion(), VersionInfoUtils.getUserAgent()};
    private static final String USER_AGENT_STRING = UserAgentUtils.generateUserAgentString(AGENT_COMPONENTS);

    private static final String generateUserAgentString(String[] components) {
        StringJoiner joiner = new StringJoiner(USER_AGENT_SEP);
        for (String component : components) {
            joiner.add(component);
        }
        return joiner.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLibraryVersion() {
        String version = "unknown-version";
        InputStream inputStream = ClassLoaderHelper.getResourceAsStream((String)VERSION_INFO_FILE, (boolean)true, (Class[])new Class[]{UserAgentUtils.class});
        Properties versionProperties = new Properties();
        try {
            if (inputStream == null) {
                log.info("Unable to load version information for msk iam auth plugin");
            } else {
                versionProperties.load(inputStream);
                version = versionProperties.getProperty("version");
            }
        }
        catch (Exception e) {
            log.info("Unable to load version information for the running SDK: " + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream, null);
        }
        return version;
    }

    public static String getUserAgentValue() {
        return USER_AGENT_STRING;
    }
}

