/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import software.amazon.timestream.jdbc.Error;
import software.amazon.timestream.jdbc.TimestreamConnectionProperty;
import software.amazon.timestream.jdbc.TimestreamSAMLCredentialsProvider;

class TimestreamAzureADCredentialsProvider
extends TimestreamSAMLCredentialsProvider {
    private final String appID;
    private final String clientSecret;
    private final String tenantID;

    TimestreamAzureADCredentialsProvider(CloseableHttpClient httpClient, Map<String, String> azureADFieldsMap) {
        super(httpClient, azureADFieldsMap);
        this.appID = azureADFieldsMap.get(TimestreamConnectionProperty.AAD_APP_ID.getConnectionProperty());
        this.clientSecret = azureADFieldsMap.get(TimestreamConnectionProperty.AAD_CLIENT_SECRET.getConnectionProperty());
        this.tenantID = azureADFieldsMap.get(TimestreamConnectionProperty.AAD_TENANT_ID.getConnectionProperty());
    }

    @Override
    protected String getSAMLAssertion() throws SQLException {
        String accessToken = this.getAccessToken();
        String assertion = "<samlp:Response xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"><samlp:Status><samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\"/></samlp:Status>" + new String(Base64.decodeBase64((String)accessToken), StandardCharsets.UTF_8) + "</samlp:Response>";
        return new String(Base64.encodeBase64((byte[])assertion.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getAccessToken() throws SQLException {
        String accessTokenEndpoint = "https://login.microsoftonline.com/" + this.tenantID + "/oauth2/token";
        ImmutableList requestParameters = ImmutableList.of((Object)new BasicNameValuePair("grant_type", "password"), (Object)new BasicNameValuePair("requested_token_type", "urn:ietf:params:oauth:token-type:saml2"), (Object)new BasicNameValuePair("username", this.userName), (Object)new BasicNameValuePair("password", this.password), (Object)new BasicNameValuePair("client_secret", this.clientSecret), (Object)new BasicNameValuePair("client_id", this.appID), (Object)new BasicNameValuePair("resource", this.appID));
        HttpUriRequest accessTokenRequest = RequestBuilder.post().setUri(accessTokenEndpoint).addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").setEntity((HttpEntity)new UrlEncodedFormEntity((Iterable)requestParameters, StandardCharsets.UTF_8)).build();
        try (CloseableHttpResponse response = this.httpClient.execute(accessTokenRequest);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw Error.createSQLException(LOGGER, Error.AAD_ACCESS_TOKEN_REQUEST_FAILED, new Object[0]);
            }
            HttpEntity responseEntity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
            JsonNode jsonNode = OBJECT_MAPPER.readTree(responseString).get("access_token");
            if (jsonNode == null) {
                throw Error.createSQLException(LOGGER, Error.INVALID_AAD_ACCESS_TOKEN_RESPONSE, new Object[0]);
            }
            String string = jsonNode.asText();
            return string;
        }
        catch (IOException e) {
            throw Error.createSQLException(LOGGER, e, Error.AAD_ACCESS_TOKEN_ERROR, new Object[0]);
        }
    }
}

