/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.services.timestreamquery.model.ColumnInfo;
import com.amazonaws.services.timestreamquery.model.Datum;
import com.amazonaws.services.timestreamquery.model.Row;
import com.amazonaws.services.timestreamquery.model.Type;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.timestream.jdbc.Constants;
import software.amazon.timestream.jdbc.Conversions;
import software.amazon.timestream.jdbc.Error;
import software.amazon.timestream.jdbc.JdbcType;
import software.amazon.timestream.jdbc.TimestreamArray;
import software.amazon.timestream.jdbc.TimestreamDataType;
import software.amazon.timestream.jdbc.TimestreamResultSetMetaData;
import software.amazon.timestream.jdbc.TimestreamStatement;
import software.amazon.timestream.jdbc.TimestreamStruct;

abstract class TimestreamBaseResultSet
implements ResultSet {
    static final Calendar DEFAULT_CALENDAR = Calendar.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestreamBaseResultSet.class);
    private final TimestreamStatement statement;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private boolean wasNullFlag;
    private final int fieldSize;
    private final Map<String, Class<?>> typeMap;
    protected SQLWarning warnings;
    protected Iterator<Row> rowItr;
    protected TimestreamResultSetMetaData rsMeta;
    private int fetchSize;
    private Map<String, Integer> nameIndexMap;
    private List<TimestreamDataType> tsTypes;
    private List<Datum> currentRowData;
    private int rowIndex = 0;

    TimestreamBaseResultSet(TimestreamStatement statement, int fetchSize) {
        this(statement, fetchSize, new HashMap(), 0);
    }

    TimestreamBaseResultSet(TimestreamStatement statement, int fetchSize, Map<String, Class<?>> map, int maxFieldSize) {
        this.statement = statement;
        this.fetchSize = fetchSize;
        this.typeMap = map;
        this.fieldSize = maxFieldSize;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.verifyOpen();
        if (row < 1) {
            throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.INVALID_ROW_VALUE, new Object[0]);
        }
        if (this.rowIndex > row) {
            throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.RESULT_FORWARD_ONLY, new Object[0]);
        }
        while (this.rowIndex < row && this.next()) {
        }
        return !this.isBeforeFirst() && !this.isAfterLast();
    }

    @Override
    public void afterLast() throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.RESULT_FORWARD_ONLY, new Object[0]);
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.RESULT_FORWARD_ONLY, new Object[0]);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        this.doClose();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.verifyOpen();
        Integer index = this.nameIndexMap.get(columnLabel);
        if (null == index) {
            throw Error.createSQLException(LOGGER, Error.INVALID_COLUMN_LABEL, columnLabel);
        }
        return index;
    }

    @Override
    public boolean first() throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.RESULT_FORWARD_ONLY, new Object[0]);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return this.getArray(columnIndex, new HashMap());
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (null == value) {
            return null;
        }
        return new ByteArrayInputStream(this.getString(columnIndex).getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal converted = this.getBigDecimal(columnIndex);
        if (null != converted) {
            return converted.setScale(scale, RoundingMode.HALF_UP);
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return null;
        }
        return (BigDecimal)Conversions.convert(sourceType, JdbcType.DECIMAL, currentCell, this::addWarning);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_BINARY_STREAM, new Object[0]);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_TYPE, Blob.class.toString());
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return Boolean.FALSE;
        }
        if (sourceType == TimestreamDataType.BOOLEAN) {
            return Boolean.parseBoolean(currentCell.getScalarValue());
        }
        return (Boolean)Conversions.convert(sourceType, JdbcType.BOOLEAN, currentCell, this::addWarning);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return 0;
        }
        return (Byte)Conversions.convert(sourceType, JdbcType.TINYINT, currentCell, this::addWarning);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_TYPE, byte[].class.toString());
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        return null == value ? null : new StringReader(value);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_TYPE, Clob.class.toString());
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, DEFAULT_CALENDAR);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), DEFAULT_CALENDAR);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date dbDate;
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return null;
        }
        if (sourceType == TimestreamDataType.DATE) {
            try {
                dbDate = Date.valueOf(currentCell.getScalarValue());
            }
            catch (IllegalArgumentException e) {
                throw Error.createSQLException(LOGGER, e, Error.INCORRECT_SOURCE_TYPE_AT_CELL, new Object[]{sourceType});
            }
        } else {
            dbDate = (Date)Conversions.convert(sourceType, JdbcType.DATE, currentCell, this::addWarning);
        }
        if (cal == null) {
            cal = DEFAULT_CALENDAR;
        }
        Instant zdtInstant = dbDate.toLocalDate().atStartOfDay(cal.getTimeZone().toZoneId()).toInstant();
        return new Date(zdtInstant.toEpochMilli());
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return 0.0;
        }
        if (sourceType == TimestreamDataType.DOUBLE) {
            try {
                return Double.parseDouble(currentCell.getScalarValue());
            }
            catch (NumberFormatException e) {
                throw Error.createSQLException(LOGGER, e, Error.INCORRECT_SOURCE_TYPE_AT_CELL, new Object[]{sourceType});
            }
        }
        return (Double)Conversions.convert(sourceType, JdbcType.DOUBLE, currentCell, this::addWarning);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.verifyOpen();
        return this.fetchSize;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return 0.0f;
        }
        return ((Float)Conversions.convert(sourceType, JdbcType.FLOAT, currentCell, this::addWarning)).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public int getHoldability() {
        return 2;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return 0;
        }
        if (sourceType == TimestreamDataType.INTEGER) {
            try {
                return Integer.parseInt(currentCell.getScalarValue());
            }
            catch (NumberFormatException e) {
                throw Error.createSQLException(LOGGER, e, Error.INCORRECT_SOURCE_TYPE_AT_CELL, new Object[]{sourceType});
            }
        }
        return (Integer)Conversions.convert(sourceType, JdbcType.INTEGER, currentCell, this::addWarning);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return 0L;
        }
        if (sourceType == TimestreamDataType.BIGINT) {
            try {
                return Long.parseLong(currentCell.getScalarValue());
            }
            catch (NumberFormatException e) {
                throw Error.createSQLException(LOGGER, e, Error.INCORRECT_SOURCE_TYPE_AT_CELL, new Object[]{sourceType});
            }
        }
        return (Long)Conversions.convert(sourceType, JdbcType.BIGINT, currentCell, this::addWarning);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.verifyOpen();
        return this.rsMeta;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_TYPE, NClob.class.toString());
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, this.typeMap);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), this.typeMap);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        TimestreamDataType tsType = this.tsTypes.get(columnIndex - 1);
        Class<?> targetType = map.get(tsType.getJdbcType().name());
        if (targetType != String.class) {
            if (tsType == TimestreamDataType.ARRAY) {
                return this.getArray(columnIndex, map);
            }
            if (tsType == TimestreamDataType.ROW) {
                return this.getRow(columnIndex, map);
            }
        }
        if (targetType != null) {
            return this.getObject(columnIndex, targetType);
        }
        return this.getObject(columnIndex, tsType.getJavaClass());
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.verifyOpen();
        JdbcType targetType = TimestreamDataType.convertClassNameToJdbcType(type.getName());
        switch (targetType) {
            case TIME: {
                return (T)this.getTime(columnIndex);
            }
            case TIMESTAMP: {
                return (T)this.getTimestamp(columnIndex);
            }
            case DATE: {
                return (T)this.getDate(columnIndex);
            }
        }
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return null;
        }
        return (T)Conversions.convert(sourceType, targetType, currentCell, this::addWarning);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_TYPE, Ref.class.toString());
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public int getRow() throws SQLException {
        this.verifyOpen();
        return this.rowIndex;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_TYPE, RowId.class.toString());
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_TYPE, SQLXML.class.toString());
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return 0;
        }
        return (Short)Conversions.convert(sourceType, JdbcType.SMALLINT, currentCell, this::addWarning);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public TimestreamStatement getStatement() {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        byte[] bytes;
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return null;
        }
        String result = sourceType == TimestreamDataType.VARCHAR ? currentCell.getScalarValue() : (String)Conversions.convert(sourceType, JdbcType.VARCHAR, currentCell, this::addWarning);
        if (result != null && this.fieldSize != 0 && this.fieldSize < (bytes = result.getBytes(StandardCharsets.UTF_8)).length) {
            byte[] trimmedBytes = new byte[this.fieldSize];
            System.arraycopy(bytes, 0, trimmedBytes, 0, this.fieldSize);
            return new String(trimmedBytes, StandardCharsets.UTF_8);
        }
        return result;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, DEFAULT_CALENDAR);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), DEFAULT_CALENDAR);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time dbTime;
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return null;
        }
        if (sourceType == TimestreamDataType.TIME) {
            try {
                dbTime = Time.valueOf(LocalTime.parse(currentCell.getScalarValue()));
            }
            catch (DateTimeParseException e) {
                throw Error.createSQLException(LOGGER, e, Error.INCORRECT_SOURCE_TYPE_AT_CELL, new Object[]{sourceType});
            }
        } else {
            dbTime = (Time)Conversions.convert(sourceType, JdbcType.TIME, currentCell, this::addWarning);
        }
        if (cal == null) {
            cal = DEFAULT_CALENDAR;
        }
        LocalDateTime dt = dbTime.toLocalTime().atDate(LocalDate.of(1970, 1, 1));
        return new Time(dt.atZone(cal.getTimeZone().toZoneId()).toInstant().toEpochMilli());
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, DEFAULT_CALENDAR);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), DEFAULT_CALENDAR);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp dbTimeStamp;
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return null;
        }
        if (sourceType == TimestreamDataType.TIMESTAMP) {
            try {
                dbTimeStamp = Timestamp.valueOf(LocalDateTime.parse(currentCell.getScalarValue(), Constants.DATE_TIME_FORMATTER));
            }
            catch (DateTimeParseException e) {
                throw Error.createSQLException(LOGGER, e, Error.INCORRECT_SOURCE_TYPE_AT_CELL, new Object[]{sourceType});
            }
        } else {
            dbTimeStamp = (Timestamp)Conversions.convert(sourceType, JdbcType.TIMESTAMP, currentCell, this::addWarning);
        }
        if (cal == null) {
            cal = DEFAULT_CALENDAR;
        }
        Instant zdt = dbTimeStamp.toLocalDateTime().atZone(cal.getTimeZone().toZoneId()).toInstant();
        Timestamp timestamp = new Timestamp(zdt.toEpochMilli());
        timestamp.setNanos(zdt.getNano());
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public int getType() {
        return 1003;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_TYPE, URL.class.toString());
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return new ByteArrayInputStream(this.getString(columnIndex).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.verifyOpen();
        return this.warnings;
    }

    @Override
    public void insertRow() throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.verifyOpen();
        return -1 == this.rowIndex;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.verifyOpen();
        return 0 == this.rowIndex;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return null != iface && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean last() throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.RESULT_FORWARD_ONLY, new Object[0]);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.RESULT_FORWARD_ONLY, new Object[0]);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public boolean next() throws SQLException {
        this.verifyOpen();
        if (this.rowItr == null) {
            return false;
        }
        while (!this.rowItr.hasNext()) {
            if (this.doNextPage()) continue;
            return false;
        }
        this.currentRowData = this.rowItr.next().getData();
        ++this.rowIndex;
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.RESULT_FORWARD_ONLY, new Object[0]);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_REFRESH_ROW, new Object[0]);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.verifyOpen();
        if (rows < 0) {
            throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.RESULT_FORWARD_ONLY, new Object[0]);
        }
        while (rows-- > 0) {
            if (this.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.RESULT_FORWARD_ONLY, new Object[0]);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.verifyOpen();
        if (rows < 0) {
            throw Error.createSQLException(LOGGER, Error.INVALID_FETCH_SIZE, rows);
        }
        this.fetchSize = Math.min(rows, 1000);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw Error.createSQLException(LOGGER, Error.CANNOT_UNWRAP, iface.toString());
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int i1) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int i) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateClob(String columnLabel, Reader x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateLong(int columnIndex, long l) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateLong(String columnLabel, long l) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNClob(String columnLabel, Reader x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateRow() throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.verifyOpen();
        return this.wasNullFlag;
    }

    private Array getArray(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.verifyOpen();
        this.verifyIndex(columnIndex);
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        TimestreamDataType sourceType = this.tsTypes.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return null;
        }
        List<Object> array = sourceType == TimestreamDataType.ARRAY ? currentCell.getArrayValue().stream().map(Object.class::cast).collect(Collectors.toList()) : (List<Object>)Conversions.convert(sourceType, JdbcType.ARRAY, currentCell, this::addWarning);
        Type origType = this.rsMeta.getTimestreamType(columnIndex);
        ColumnInfo columnInfo = origType.getArrayColumnInfo();
        if (columnInfo != null) {
            return new TimestreamArray(array, columnInfo.getType(), this, map);
        }
        return new TimestreamArray(array, origType, this, map);
    }

    private Struct getRow(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        Datum currentCell = this.currentRowData.get(columnIndex - 1);
        if (this.checkNull(currentCell)) {
            return null;
        }
        Row row = currentCell.getRowValue();
        Type origType = this.rsMeta.getTimestreamType(columnIndex);
        List columnInfo = origType.getRowColumnInfo();
        if (columnInfo == null) {
            throw new RuntimeException(Error.getErrorMessage(LOGGER, Error.INVALID_DATA_AT_ROW, origType));
        }
        return new TimestreamStruct(row.getData(), columnInfo, this, map);
    }

    protected abstract void doClose() throws SQLException;

    protected abstract boolean doNextPage() throws SQLException;

    protected TimestreamResultSetMetaData createColumnMetadata(List<ColumnInfo> columnInfo) {
        ArrayList<TimestreamResultSetMetaData.ColInfo> colInfo = new ArrayList<TimestreamResultSetMetaData.ColInfo>();
        this.nameIndexMap = new HashMap<String, Integer>();
        this.tsTypes = new ArrayList<TimestreamDataType>();
        for (int i = 0; i < columnInfo.size(); ++i) {
            ColumnInfo info = columnInfo.get(i);
            this.nameIndexMap.put(info.getName(), i + 1);
            colInfo.add(new TimestreamResultSetMetaData.ColInfo(info.getType(), info.getName()));
            this.tsTypes.add(TimestreamDataType.fromType(info.getType()));
        }
        return new TimestreamResultSetMetaData(colInfo);
    }

    protected void verifyOpen() throws SQLException {
        if (this.isClosed.get()) {
            throw Error.createSQLException(LOGGER, Error.RESULT_SET_CLOSED, new Object[0]);
        }
    }

    protected void verifyIndex(int column) throws SQLException {
        if (1 > column || column > this.currentRowData.size()) {
            throw Error.createSQLException(LOGGER, Error.INVALID_INDEX, column, this.currentRowData.size());
        }
    }

    private boolean checkNull(Datum datum) {
        this.wasNullFlag = Boolean.TRUE.equals(datum.getNullValue());
        return this.wasNullFlag;
    }

    protected static Datum createDatum(int value) {
        return TimestreamBaseResultSet.createDatum(String.valueOf(value));
    }

    protected static Datum createDatum(String value) {
        return new Datum().withScalarValue(value);
    }

    void addWarning(SQLWarning warning) {
        LOGGER.warn(warning.getMessage());
        if (this.warnings == null) {
            this.warnings = warning;
            return;
        }
        this.warnings.setNextWarning(warning);
    }
}

