/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.interfaceextractor;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.TemplateEngine;
import org.generama.VelocityTemplateEngine;
import org.generama.WriterMapper;
import org.generama.defaults.JavaGeneratingPlugin;

public class InterfaceExtractorPlugin
extends JavaGeneratingPlugin {
    private String ignoreMethodsRegex;
    private String extendsInterface;

    public InterfaceExtractorPlugin(VelocityTemplateEngine velocityTemplateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper) {
        super((TemplateEngine)velocityTemplateEngine, metadataProvider, writerMapper);
        this.setMultioutput(false);
    }

    public void setIgnoremethodsregex(String ignoreMethodsRegex) {
        this.ignoreMethodsRegex = ignoreMethodsRegex;
    }

    public String getExtends() {
        return this.extendsInterface;
    }

    public void setExtends(String extendsInterface) {
        this.extendsInterface = extendsInterface;
    }

    public Set getCommonMethods() {
        HashSet extractedMethods = new HashSet();
        Collection classes = this.getMetadata();
        Iterator it = classes.iterator();
        boolean firstIteration = true;
        while (it.hasNext()) {
            JavaClass clas = (JavaClass)it.next();
            JavaMethod[] methods = clas.getMethods();
            LinkedList<JavaMethod> validMethods = new LinkedList<JavaMethod>();
            for (int i = 0; i < methods.length; ++i) {
                JavaMethod method = methods[i];
                if (this.ignoreMethodsRegex != null && method.getName().matches(this.ignoreMethodsRegex)) continue;
                validMethods.add(method);
            }
            if (firstIteration) {
                extractedMethods.addAll(validMethods);
                firstIteration = false;
            }
            extractedMethods.retainAll(validMethods);
        }
        return extractedMethods;
    }
}

