/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package com.aliyun.oss.model;

public class UploadPartCopyResult extends GenericResult {

    private int partNumber;

    private String eTag;

    /**
     * Gets the part number.
     * 
     * @return The part number.
     */
    public int getPartNumber() {
        return partNumber;
    }

    /**
     * Sets the part number.
     * 
     * @param partNumber
     *            The part number.
     */
    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    /**
     * Gets the ETag generated by OSS.
     * <p>
     * OSS would send the MD5 value of the parts data received to user in the
     * ETag header. To make sure the data transferred is 100% correct, we
     * strongly encouraged user to check the server side MD5 with the local
     * computed MD5 value.
     * </p>
     * 
     * @return ETag value.
     */
    public String getETag() {
        return eTag;
    }

    /**
     * Sets the ETag value.
     * <p>
     * OSS would send the MD5 value of the parts data received to user in the
     * ETag header. To make sure the data transferred is 100% correct, we
     * strongly encouraged user to check the server side MD5 with the local
     * computed MD5 value.
     * </p>
     * 
     * @param eTag
     *            ETag value.
     */
    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    /**
     * Gets the part ETag.
     * 
     * @return Gets the part ETag.
     */
    public PartETag getPartETag() {
        return new PartETag(partNumber, eTag);
    }
}
