/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;

final class AutoValue_AsyncWriteChannelOptions
extends AsyncWriteChannelOptions {
    private final int bufferSize;
    private final int pipeBufferSize;
    private final int uploadChunkSize;
    private final int uploadCacheSize;
    private final boolean directUploadEnabled;

    private AutoValue_AsyncWriteChannelOptions(int bufferSize, int pipeBufferSize, int uploadChunkSize, int uploadCacheSize, boolean directUploadEnabled) {
        this.bufferSize = bufferSize;
        this.pipeBufferSize = pipeBufferSize;
        this.uploadChunkSize = uploadChunkSize;
        this.uploadCacheSize = uploadCacheSize;
        this.directUploadEnabled = directUploadEnabled;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public int getPipeBufferSize() {
        return this.pipeBufferSize;
    }

    @Override
    public int getUploadChunkSize() {
        return this.uploadChunkSize;
    }

    @Override
    public int getUploadCacheSize() {
        return this.uploadCacheSize;
    }

    @Override
    public boolean isDirectUploadEnabled() {
        return this.directUploadEnabled;
    }

    public String toString() {
        return "AsyncWriteChannelOptions{bufferSize=" + this.bufferSize + ", " + "pipeBufferSize=" + this.pipeBufferSize + ", " + "uploadChunkSize=" + this.uploadChunkSize + ", " + "uploadCacheSize=" + this.uploadCacheSize + ", " + "directUploadEnabled=" + this.directUploadEnabled + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AsyncWriteChannelOptions) {
            AsyncWriteChannelOptions that = (AsyncWriteChannelOptions)o;
            return this.bufferSize == that.getBufferSize() && this.pipeBufferSize == that.getPipeBufferSize() && this.uploadChunkSize == that.getUploadChunkSize() && this.uploadCacheSize == that.getUploadCacheSize() && this.directUploadEnabled == that.isDirectUploadEnabled();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.bufferSize;
        h$ *= 1000003;
        h$ ^= this.pipeBufferSize;
        h$ *= 1000003;
        h$ ^= this.uploadChunkSize;
        h$ *= 1000003;
        h$ ^= this.uploadCacheSize;
        h$ *= 1000003;
        return h$ ^= this.directUploadEnabled ? 1231 : 1237;
    }

    @Override
    public AsyncWriteChannelOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AsyncWriteChannelOptions.Builder {
        private Integer bufferSize;
        private Integer pipeBufferSize;
        private Integer uploadChunkSize;
        private Integer uploadCacheSize;
        private Boolean directUploadEnabled;

        Builder() {
        }

        private Builder(AsyncWriteChannelOptions source) {
            this.bufferSize = source.getBufferSize();
            this.pipeBufferSize = source.getPipeBufferSize();
            this.uploadChunkSize = source.getUploadChunkSize();
            this.uploadCacheSize = source.getUploadCacheSize();
            this.directUploadEnabled = source.isDirectUploadEnabled();
        }

        @Override
        public AsyncWriteChannelOptions.Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setPipeBufferSize(int pipeBufferSize) {
            this.pipeBufferSize = pipeBufferSize;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setUploadChunkSize(int uploadChunkSize) {
            this.uploadChunkSize = uploadChunkSize;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setUploadCacheSize(int uploadCacheSize) {
            this.uploadCacheSize = uploadCacheSize;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setDirectUploadEnabled(boolean directUploadEnabled) {
            this.directUploadEnabled = directUploadEnabled;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions build() {
            String missing = "";
            if (this.bufferSize == null) {
                missing = missing + " bufferSize";
            }
            if (this.pipeBufferSize == null) {
                missing = missing + " pipeBufferSize";
            }
            if (this.uploadChunkSize == null) {
                missing = missing + " uploadChunkSize";
            }
            if (this.uploadCacheSize == null) {
                missing = missing + " uploadCacheSize";
            }
            if (this.directUploadEnabled == null) {
                missing = missing + " directUploadEnabled";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AsyncWriteChannelOptions(this.bufferSize, this.pipeBufferSize, this.uploadChunkSize, this.uploadCacheSize, this.directUploadEnabled);
        }
    }
}

