/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

class PushImageStep
implements Callable<BuildResult> {
    private static final String DESCRIPTION = "Pushing manifest";
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final RegistryClient registryClient;
    private final ManifestTemplate manifestTemplate;
    private final String imageQualifier;
    private final DescriptorDigest imageDigest;
    private final DescriptorDigest imageId;

    static ImmutableList<PushImageStep> makeList(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, RegistryClient registryClient, BlobDescriptor containerConfigurationDigestAndSize, Image builtImage, boolean manifestAlreadyExists) throws IOException {
        BuildableManifestTemplate manifestTemplate = new ImageToJsonTranslator(builtImage).getManifestTemplate(buildContext.getTargetFormat(), containerConfigurationDigestAndSize);
        DescriptorDigest manifestDigest = Digests.computeJsonDigest(manifestTemplate);
        Set<String> imageQualifiers = PushImageStep.getImageQualifiers(buildContext, builtImage, manifestDigest);
        EventHandlers eventHandlers = buildContext.getEventHandlers();
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(eventHandlers, "Preparing manifest pushers");){
            ProgressEventDispatcher progressDispatcher;
            block15: {
                progressDispatcher = progressEventDispatcherFactory.create("launching manifest pushers", imageQualifiers.size());
                try {
                    if (!JibSystemProperties.skipExistingImages() || !manifestAlreadyExists) break block15;
                    eventHandlers.dispatch(LogEvent.info("Skipping pushing manifest; already exists."));
                    ImmutableList immutableList = ImmutableList.of();
                    if (progressDispatcher != null) {
                        progressDispatcher.close();
                    }
                    return immutableList;
                }
                catch (Throwable throwable) {
                    if (progressDispatcher != null) {
                        try {
                            progressDispatcher.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            ImmutableList immutableList = (ImmutableList)imageQualifiers.stream().map(qualifier -> new PushImageStep(buildContext, progressDispatcher.newChildProducer(), registryClient, manifestTemplate, (String)qualifier, manifestDigest, containerConfigurationDigestAndSize.getDigest())).collect(ImmutableList.toImmutableList());
            if (progressDispatcher != null) {
                progressDispatcher.close();
            }
            return immutableList;
        }
    }

    private static Set<String> getImageQualifiers(BuildContext buildContext, Image builtImage, DescriptorDigest manifestDigest) {
        boolean singlePlatform = buildContext.getContainerConfiguration().getPlatforms().size() == 1;
        ImmutableSet<String> tags = buildContext.getAllTargetImageTags();
        if (singlePlatform) {
            return tags;
        }
        if (buildContext.getEnablePlatformTags()) {
            String architecture = builtImage.getArchitecture();
            return tags.stream().map(tag -> tag + "-" + architecture).collect(Collectors.toSet());
        }
        return Collections.singleton(manifestDigest.toString());
    }

    static ImmutableList<PushImageStep> makeListForManifestList(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, RegistryClient registryClient, ManifestTemplate manifestList, boolean manifestListAlreadyExists) throws IOException {
        ImmutableSet<String> tags = buildContext.getAllTargetImageTags();
        EventHandlers eventHandlers = buildContext.getEventHandlers();
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(eventHandlers, "Preparing manifest list pushers");){
            ProgressEventDispatcher progressEventDispatcher;
            block19: {
                block18: {
                    progressEventDispatcher = progressEventDispatcherFactory.create("launching manifest list pushers", tags.size());
                    try {
                        boolean singlePlatform;
                        boolean bl = singlePlatform = buildContext.getContainerConfiguration().getPlatforms().size() == 1;
                        if (!singlePlatform) break block18;
                        ImmutableList immutableList = ImmutableList.of();
                        if (progressEventDispatcher != null) {
                            progressEventDispatcher.close();
                        }
                        return immutableList;
                    }
                    catch (Throwable throwable) {
                        if (progressEventDispatcher != null) {
                            try {
                                progressEventDispatcher.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                if (!JibSystemProperties.skipExistingImages() || !manifestListAlreadyExists) break block19;
                eventHandlers.dispatch(LogEvent.info("Skipping pushing manifest list; already exists."));
                ImmutableList immutableList = ImmutableList.of();
                if (progressEventDispatcher != null) {
                    progressEventDispatcher.close();
                }
                return immutableList;
            }
            DescriptorDigest manifestListDigest = Digests.computeJsonDigest(manifestList);
            ImmutableList immutableList = (ImmutableList)tags.stream().map(tag -> new PushImageStep(buildContext, progressEventDispatcher.newChildProducer(), registryClient, manifestList, (String)tag, manifestListDigest, manifestListDigest)).collect(ImmutableList.toImmutableList());
            if (progressEventDispatcher != null) {
                progressEventDispatcher.close();
            }
            return immutableList;
        }
    }

    PushImageStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, RegistryClient registryClient, ManifestTemplate manifestTemplate, String imageQualifier, DescriptorDigest imageDigest, DescriptorDigest imageId) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.registryClient = registryClient;
        this.manifestTemplate = manifestTemplate;
        this.imageQualifier = imageQualifier;
        this.imageDigest = imageDigest;
        this.imageId = imageId;
    }

    @Override
    public BuildResult call() throws IOException, RegistryException {
        EventHandlers eventHandlers = this.buildContext.getEventHandlers();
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(eventHandlers, DESCRIPTION);){
            ProgressEventDispatcher ignored2 = this.progressEventDispatcherFactory.create("pushing manifest for " + this.imageQualifier, 1L);
            try {
                eventHandlers.dispatch(LogEvent.info("Pushing manifest for " + this.imageQualifier + "..."));
                this.registryClient.pushManifest(this.manifestTemplate, this.imageQualifier);
                BuildResult buildResult = new BuildResult(this.imageDigest, this.imageId, true);
                if (ignored2 != null) {
                    ignored2.close();
                }
                return buildResult;
            }
            catch (Throwable throwable) {
                if (ignored2 != null) {
                    try {
                        ignored2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }
}

