/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common.logging;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SingleThreadedExecutor {
    private static final Logger LOGGER = Logger.getLogger(SingleThreadedExecutor.class.getName());
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public void shutDownAndAwaitTermination(Duration timeout) {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(timeout.getSeconds(), TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(timeout.getSeconds(), TimeUnit.SECONDS)) {
                    LOGGER.log(Level.SEVERE, "Could not shut down SingleThreadedExecutor");
                }
            }
        }
        catch (InterruptedException ex) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void execute(Runnable runnable) {
        this.executorService.execute(runnable);
    }
}

