/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.FailoverHttpClient;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.http.ResponseException;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryCredentialsNotSentException;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RegistryAuthenticator {
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final String realm;
    private final String service;
    @Nullable
    private final String userAgent;
    private final FailoverHttpClient httpClient;

    static Optional<RegistryAuthenticator> fromAuthenticationMethod(String authenticationMethod, RegistryEndpointRequestProperties registryEndpointRequestProperties, @Nullable String userAgent, FailoverHttpClient httpClient) throws RegistryAuthenticationFailedException {
        if (authenticationMethod.matches("^(?i)(basic).*")) {
            return Optional.empty();
        }
        String registryUrl = registryEndpointRequestProperties.getServerUrl();
        String imageName = registryEndpointRequestProperties.getImageName();
        if (!authenticationMethod.matches("^(?i)(bearer) .*")) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(registryUrl, imageName, authenticationMethod, "Bearer");
        }
        Pattern realmPattern = Pattern.compile("realm=\"(.*?)\"");
        Matcher realmMatcher = realmPattern.matcher(authenticationMethod);
        if (!realmMatcher.find()) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(registryUrl, imageName, authenticationMethod, "realm");
        }
        String realm = realmMatcher.group(1);
        Pattern servicePattern = Pattern.compile("service=\"(.*?)\"");
        Matcher serviceMatcher = servicePattern.matcher(authenticationMethod);
        String service = serviceMatcher.find() ? serviceMatcher.group(1) : registryUrl;
        return Optional.of(new RegistryAuthenticator(realm, service, registryEndpointRequestProperties, userAgent, httpClient));
    }

    private static RegistryAuthenticationFailedException newRegistryAuthenticationFailedException(String registry, String repository, String authenticationMethod, String authParam) {
        return new RegistryAuthenticationFailedException(registry, repository, "'" + authParam + "' was not found in the 'WWW-Authenticate' header, tried to parse: " + authenticationMethod);
    }

    private RegistryAuthenticator(String realm, String service, RegistryEndpointRequestProperties registryEndpointRequestProperties, @Nullable String userAgent, FailoverHttpClient httpClient) {
        this.realm = realm;
        this.service = service;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.userAgent = userAgent;
        this.httpClient = httpClient;
    }

    public Authorization authenticatePull(@Nullable Credential credential) throws RegistryAuthenticationFailedException, RegistryCredentialsNotSentException {
        return this.authenticate(credential, "pull");
    }

    public Authorization authenticatePush(@Nullable Credential credential) throws RegistryAuthenticationFailedException, RegistryCredentialsNotSentException {
        return this.authenticate(credential, "pull,push");
    }

    private String getServiceScopeRequestParameters(Map<String, String> repositoryScopes) {
        StringBuilder parameters = new StringBuilder("service=").append(this.service);
        for (Map.Entry<String, String> pair : repositoryScopes.entrySet()) {
            parameters.append("&scope=repository:").append(pair.getKey()).append(":").append(pair.getValue());
        }
        return parameters.toString();
    }

    @VisibleForTesting
    URL getAuthenticationUrl(@Nullable Credential credential, Map<String, String> repositoryScopes) throws MalformedURLException {
        return this.isOAuth2Auth(credential) ? new URL(this.realm) : new URL(this.realm + "?" + this.getServiceScopeRequestParameters(repositoryScopes));
    }

    @VisibleForTesting
    String getAuthRequestParameters(@Nullable Credential credential, Map<String, String> repositoryScopes) {
        String serviceScope = this.getServiceScopeRequestParameters(repositoryScopes);
        return this.isOAuth2Auth(credential) ? serviceScope + "&client_id=jib.da031fe481a93ac107a95a96462358f9&grant_type=refresh_token&refresh_token=" + ((Credential)Verify.verifyNotNull((Object)credential)).getPassword() : serviceScope;
    }

    @VisibleForTesting
    boolean isOAuth2Auth(@Nullable Credential credential) {
        return credential != null && credential.isOAuth2RefreshToken();
    }

    private Authorization authenticate(@Nullable Credential credential, String scope) throws RegistryAuthenticationFailedException, RegistryCredentialsNotSentException {
        String sourceImageName = this.registryEndpointRequestProperties.getSourceImageName();
        String imageName = this.registryEndpointRequestProperties.getImageName();
        if (sourceImageName != null && !sourceImageName.equals(imageName)) {
            try {
                return this.authenticate(credential, (Map<String, String>)ImmutableMap.of((Object)imageName, (Object)scope, (Object)sourceImageName, (Object)"pull"));
            }
            catch (RegistryAuthenticationFailedException registryAuthenticationFailedException) {
                // empty catch block
            }
        }
        return this.authenticate(credential, (Map<String, String>)ImmutableMap.of((Object)imageName, (Object)scope));
    }

    private Authorization authenticate(@Nullable Credential credential, Map<String, String> repositoryScopes) throws RegistryAuthenticationFailedException, RegistryCredentialsNotSentException {
        Authorization authorization;
        block14: {
            String registryUrl = this.registryEndpointRequestProperties.getServerUrl();
            String imageName = this.registryEndpointRequestProperties.getImageName();
            URL url = this.getAuthenticationUrl(credential, repositoryScopes);
            Request.Builder requestBuilder = Request.builder().setHttpTimeout(JibSystemProperties.getHttpTimeout()).setUserAgent(this.userAgent);
            if (this.isOAuth2Auth(credential)) {
                String parameters = this.getAuthRequestParameters(credential, repositoryScopes);
                requestBuilder.setBody(new BlobHttpContent(Blobs.from(parameters), MediaType.FORM_DATA.toString()));
            } else if (credential != null) {
                requestBuilder.setAuthorization(Authorization.fromBasicCredentials(credential.getUsername(), credential.getPassword()));
            }
            String httpMethod = this.isOAuth2Auth(credential) ? "POST" : "GET";
            Response response = this.httpClient.call(httpMethod, url, requestBuilder.build());
            try {
                AuthenticationResponseTemplate responseJson = JsonTemplateMapper.readJson(response.getBody(), AuthenticationResponseTemplate.class);
                if (responseJson.getToken() == null) {
                    throw new RegistryAuthenticationFailedException(registryUrl, imageName, "Did not get token in authentication response from " + this.getAuthenticationUrl(credential, repositoryScopes) + "; parameters: " + this.getAuthRequestParameters(credential, repositoryScopes));
                }
                authorization = Authorization.fromBearerToken(responseJson.getToken());
                if (response == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ResponseException ex) {
                    if (ex.getStatusCode() == 401 && ex.requestAuthorizationCleared()) {
                        throw new RegistryCredentialsNotSentException(registryUrl, imageName);
                    }
                    throw new RegistryAuthenticationFailedException(registryUrl, imageName, ex);
                }
                catch (IOException ex) {
                    throw new RegistryAuthenticationFailedException(registryUrl, imageName, ex);
                }
            }
            response.close();
        }
        return authorization;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @VisibleForTesting
    static class AuthenticationResponseTemplate
    implements JsonTemplate {
        @Nullable
        private String token;
        @Nullable
        @JsonProperty(value="access_token")
        private String accessToken;

        AuthenticationResponseTemplate() {
        }

        @Nullable
        @VisibleForTesting
        String getToken() {
            if (this.token != null) {
                return this.token;
            }
            return this.accessToken;
        }
    }
}

