/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.property.impl;

import com.solacesystems.common.property.PropertyConversionException;
import com.solacesystems.common.property.PropertyConverter;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueOfConverter
implements PropertyConverter {
    private static HashMap<String, ValueOfConverter> converterMap = new HashMap();
    private Class<?> mToClass;

    public static ValueOfConverter getConverter(Class<?> toClass) {
        ValueOfConverter converter = converterMap.get(toClass.getName());
        if (converter == null) {
            boolean found = false;
            Method[] methods = toClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("valueOf") || methods[i].getParameterTypes().length != 1) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("converter for " + toClass.getName() + " not found");
            }
            converter = new ValueOfConverter(toClass);
            converterMap.put(toClass.getName(), converter);
        }
        return converter;
    }

    private ValueOfConverter(Class<?> toClass) {
        this.mToClass = toClass;
    }

    public Class<?> getDestinationClass() {
        return this.mToClass;
    }

    @Override
    public Object convert(Object fromValue) throws PropertyConversionException {
        if (this.mToClass.isPrimitive()) {
            this.mToClass = ClassUtils.primitiveToWrapper(this.mToClass);
            if (!converterMap.containsValue(this)) {
                converterMap.put(this.mToClass.getName(), this);
            }
        }
        if (fromValue.getClass().isAssignableFrom(this.mToClass)) {
            return fromValue;
        }
        try {
            Class[] valueOfArgs = new Class[]{fromValue.getClass()};
            Method convertMethod = this.mToClass.getDeclaredMethod("valueOf", valueOfArgs);
            Object[] invokeArgs = new Object[]{fromValue};
            return convertMethod.invoke(null, invokeArgs);
        }
        catch (Exception e) {
            throw new PropertyConversionException("failed to convert value \"" + fromValue + "\"", e);
        }
    }
}

