/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.SolReserved;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.Subscription;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerNotificationDispatcherFactory;

public class ConsumerFlowProperties {
    Endpoint endpoint;
    Subscription newSubscription;
    String sqlSelector = null;
    boolean startState = false;
    boolean noLocal;
    boolean activeFlowIndication;
    String ackMode = null;
    int windowSize = 0;
    int ackTimerMs = 0;
    int ackThreshold = 0;
    ConsumerNotificationDispatcherFactory consumerNotificationDispatcherFactory = null;
    JCSMPProperties flowSessionProps = null;
    boolean segmentFlow = false;
    int windowedAckMaxSize = 255;

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public ConsumerFlowProperties setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Subscription getNewSubscription() {
        return this.newSubscription;
    }

    public ConsumerFlowProperties setNewSubscription(Subscription newSubscription) {
        this.newSubscription = newSubscription;
        return this;
    }

    public String getSelector() {
        return this.sqlSelector;
    }

    public ConsumerFlowProperties setSelector(String selector) {
        this.sqlSelector = selector;
        return this;
    }

    public boolean isStartState() {
        return this.startState;
    }

    public ConsumerFlowProperties setStartState(boolean startState) {
        this.startState = startState;
        return this;
    }

    public ConsumerFlowProperties setAckMode(String ackMode) {
        this.ackMode = ackMode;
        return this;
    }

    public String getAckMode() {
        return this.ackMode;
    }

    public int getTransportWindowSize() {
        return this.windowSize;
    }

    public ConsumerFlowProperties setTransportWindowSize(int winSz) {
        this.rangeCheckZeroIsLegal(winSz, 1, 255);
        this.windowSize = winSz;
        return this;
    }

    public int getAckTimerInMsecs() {
        return this.ackTimerMs;
    }

    public ConsumerFlowProperties setAckTimerInMsecs(int ackTimerInMsecs) {
        this.rangeCheckZeroIsLegal(ackTimerInMsecs, 20, 1500);
        this.ackTimerMs = ackTimerInMsecs;
        return this;
    }

    public int getAckThreshold() {
        return this.ackThreshold;
    }

    public ConsumerFlowProperties setAckThreshold(int ackThreshold) {
        this.rangeCheckZeroIsLegal(ackThreshold, 1, 75);
        this.ackThreshold = ackThreshold;
        return this;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public ConsumerFlowProperties setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
        return this;
    }

    private void rangeCheckZeroIsLegal(int value, int min, int max) {
        if (value != 0 && (value < min || value > max)) {
            throw new IllegalArgumentException(String.format("Value %s was outside valid range [%s; %s].", value, min, max));
        }
    }

    public boolean isActiveFlowIndication() {
        return this.activeFlowIndication;
    }

    public ConsumerFlowProperties setActiveFlowIndication(boolean activeFlowIndication) {
        this.activeFlowIndication = activeFlowIndication;
        return this;
    }

    @SolReserved
    public ConsumerNotificationDispatcherFactory getConsumerNotificationDispatcherFactory() {
        return this.consumerNotificationDispatcherFactory;
    }

    @SolReserved
    public void setConsumerNotificationDispatcherFactory(ConsumerNotificationDispatcherFactory consumerNotificationDispatcher) {
        this.consumerNotificationDispatcherFactory = consumerNotificationDispatcher;
    }

    @SolReserved
    public JCSMPProperties getFlowSessionProps() {
        return this.flowSessionProps;
    }

    @SolReserved
    public void setFlowSessionProps(JCSMPProperties flowSessionProps) {
        this.flowSessionProps = flowSessionProps;
    }

    @SolReserved
    public boolean isSegmentFlow() {
        return this.segmentFlow;
    }

    @SolReserved
    public void setSegmentFlow(boolean segmentFlow) {
        this.segmentFlow = segmentFlow;
    }

    @SolReserved
    public void setWindowedAckMaxSize(int sz) {
        this.windowedAckMaxSize = sz;
    }

    @SolReserved
    public int getWindowedAckMaxSize() {
        return this.windowedAckMaxSize;
    }
}

