/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.util.DestinationUtil;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Subscription;
import com.solacesystems.jcsmp.impl.AbstractDestination;
import com.solacesystems.jcsmp.impl.PubSubMode;
import com.solacesystems.jcsmp.impl.TargetRouterMode;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public abstract class Topic
extends AbstractDestination
implements Subscription,
Serializable {
    private static final long serialVersionUID = 8587259325564781468L;
    private boolean rxAllDeliverToOne;
    protected byte[] nameBytes;
    private boolean isTemporary;

    protected Topic(String name, boolean rxAllDeliverToOne, boolean isTemporary) {
        super(name);
        this.rxAllDeliverToOne = rxAllDeliverToOne;
        this.isTemporary = isTemporary;
    }

    public boolean isRxAllDeliverToOne() {
        return this.rxAllDeliverToOne;
    }

    protected void validateCommon() {
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validate(TargetRouterMode vm, PubSubMode pm) {
        this.validateCommon();
        switch (vm) {
            case CRB: {
                switch (pm) {
                    case PUB: {
                        if (!this.isValidatedCrbPub) {
                            DestinationUtil.isValidTopic(this.name, true);
                            this.isValidCrbPub = true;
                            this.isValidatedCrbPub = true;
                        }
                        if (this.isValidCrbPub) return;
                        throw new IllegalArgumentException(this.fmtInvalidDestinationErr(vm.name()));
                    }
                    case SUB: {
                        if (!this.isValidatedCrbSub) {
                            DestinationUtil.isValidTopic(this.name, false);
                            this.isValidCrbSub = true;
                            this.isValidatedCrbSub = true;
                        }
                        if (this.isValidCrbSub) return;
                        throw new IllegalArgumentException(this.fmtInvalidDestinationErr(vm.name()));
                    }
                }
                return;
            }
            case TRB: {
                switch (pm) {
                    case PUB: {
                        if (!this.isValidatedTrbPub) {
                            DestinationUtil.isValidTopicTrb(this.name, true);
                            this.isValidTrbPub = true;
                            this.isValidatedTrbPub = true;
                        }
                        if (this.isValidTrbPub) return;
                        throw new IllegalArgumentException(this.fmtInvalidDestinationErr(vm.name()));
                    }
                    case SUB: {
                        if (!this.isValidatedTrbSub) {
                            DestinationUtil.isValidTopicTrb(this.name, false);
                            this.isValidTrbSub = true;
                            this.isValidatedTrbSub = true;
                        }
                        if (this.isValidTrbSub) return;
                        throw new IllegalArgumentException(this.fmtInvalidDestinationErr(vm.name()));
                    }
                }
            }
        }
    }

    protected void init() {
        try {
            byte[] nameBytesTmp = this.name.getBytes("UTF-8");
            byte[] nameBytesTmp2 = new byte[nameBytesTmp.length + 1];
            System.arraycopy(nameBytesTmp, 0, nameBytesTmp2, 0, nameBytesTmp.length);
            this.nameBytes = nameBytesTmp2;
        }
        catch (UnsupportedEncodingException e) {
            this.nameBytes = new byte[0];
        }
        this.trmDestOffset = 0;
        this.trmDestLength = this.nameBytes.length - 1;
        this.isInitialized = true;
    }

    public boolean equals(Object o) {
        if (o instanceof Topic) {
            Topic t = (Topic)o;
            return t.name.equalsIgnoreCase(this.name) && t.isTemporary() == this.isTemporary();
        }
        return false;
    }

    public String toString() {
        return super.toString() + (this.isRxAllDeliverToOne() ? " [RxAllDeliverToOne]" : "");
    }

    public int hashCode() {
        return 31 * super.hashCode() + (this.isTemporary() ? 1231 : 1237);
    }

    protected void validateModeForPublish(DeliveryMode mt, TargetRouterMode vm, boolean acceptDirectQueue) {
    }
}

