/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.XMLMessageProducer;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.RequestListener;
import com.solacesystems.jcsmp.impl.flow.LiveMessageController;
import com.solacesystems.jcsmp.impl.flow.LiveResponseListener;
import com.solacesystems.jcsmp.statistics.StatType;
import java.util.Timer;
import java.util.TimerTask;

public class Request
extends TimerTask
implements LiveResponseListener {
    public static final Timer RequestTimer = new Timer("Request Timer", true);
    private static long ID = 0L;
    private JCSMPSession mSession;
    private XMLMessageProducer mProducer;
    private LiveMessageController mLiveMsgCtrlr;
    private XMLMessage mMessage;
    private Destination mDestination;
    private long mTimeout;
    private RequestListener mListener;
    private RequestStatus mStatus;
    private Object mLock;
    private long mId;
    private String mCorrelationId;

    private static synchronized long getNextID() {
        return ID++;
    }

    public Request(JCSMPSession session, XMLMessageProducer producer, LiveMessageController liveMsgCtrlr, XMLMessage message, Destination destination, long timeout, RequestListener listener) {
        this.mSession = session;
        this.mProducer = producer;
        this.mLiveMsgCtrlr = liveMsgCtrlr;
        this.mMessage = message;
        this.mDestination = destination;
        this.mTimeout = timeout;
        this.mListener = listener;
        this.mStatus = RequestStatus.Opened;
        this.mLock = new Object();
        this.mId = Request.getNextID();
        this.mCorrelationId = null;
    }

    public long getId() {
        return this.mId;
    }

    public void send() throws JCSMPException {
        try {
            this.mCorrelationId = this.mMessage.getCorrelationId();
            this.mLiveMsgCtrlr.addLiveResponseListener(this.mCorrelationId, this);
            RequestTimer.schedule((TimerTask)this, this.mTimeout);
            this.mProducer.send(this.mMessage, this.mDestination);
            this.mSession.getSessionStats().incStat(StatType.REQUESTS_SENT);
        }
        catch (JCSMPException e) {
            this.mLiveMsgCtrlr.removeLiveResponseListener(this.mCorrelationId);
            this.cancel();
            throw e;
        }
        finally {
            this.mMessage = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Request) {
            Request other = (Request)obj;
            return this.mId == other.mId;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLiveException(LiveMessageController controller, JCSMPException e) {
        boolean callback = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus == RequestStatus.Opened) {
                this.mStatus = RequestStatus.Errored;
                this.cancel();
                callback = true;
            }
        }
        if (callback) {
            this.mLiveMsgCtrlr.removeLiveResponseListener(this.mCorrelationId);
            this.mListener.onException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLiveResponse(LiveMessageController controller, JCSMPXMLMessage message) {
        boolean callback = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus == RequestStatus.Opened) {
                this.mStatus = RequestStatus.Completed;
                this.cancel();
                callback = true;
            } else {
                this.mSession.getSessionStats().incStat(StatType.REPLIES_DISCARDED);
            }
        }
        if (callback) {
            this.mListener.onResponse(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest() {
        boolean callback = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus == RequestStatus.Opened) {
                this.mStatus = RequestStatus.Cancelled;
                this.cancel();
                callback = true;
            }
        }
        if (callback) {
            this.mLiveMsgCtrlr.removeLiveResponseListener(this.mCorrelationId);
            this.mListener.onCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean callback = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus == RequestStatus.Opened) {
                this.mStatus = RequestStatus.TimedOut;
                callback = true;
                this.mSession.getSessionStats().incStat(StatType.REQUESTS_TIMED_OUT);
            }
        }
        if (callback) {
            this.mLiveMsgCtrlr.removeLiveResponseListener(this.mCorrelationId);
            this.mListener.onTimeout();
        }
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("Id=");
        bldr.append(this.mId);
        bldr.append(", correlationId=");
        bldr.append(this.mCorrelationId);
        bldr.append(", destination=");
        bldr.append(this.mDestination.getName());
        bldr.append(", timeout=");
        bldr.append(this.mTimeout);
        bldr.append(", status=");
        bldr.append((Object)this.mStatus);
        return bldr.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestStatus {
        Opened,
        Cancelled,
        Completed,
        Errored,
        TimedOut;

    }
}

