/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.compression;

import com.jcraft.jzlib.ZStream;
import com.solacesystems.jcsmp.impl.compression.SolZlibCallResult;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolZlibDeflatePipe {
    private static final Log Trace = LogFactory.getLog(SolZlibDeflatePipe.class);
    static final byte[] hello = "hello! thisisareallyloooooooooooooooooooooooooooongwordthaaaaaaaaaaaaaaaaaaaaaaaaaatdemonstratestheabilitytosetwindowsizeandbythewaywestillnothappywiththeproperlength".getBytes();
    static final byte[] abc = "abcdefghijklmnopqrstuvwxyz".getBytes();
    static final byte[] dict = "hello word aaaaaaaaaaaaaaaaaaa demonstratestheabilitytosetwindowsizeandbythewaywe".getBytes();
    static final String ERR_IOEXCEPTION = "zlib error";
    ZStream infl_stream = new ZStream();
    ZStream defl_stream = new ZStream();
    boolean infl_stream_init = false;
    boolean defl_stream_init = false;
    final int compressionLevel;

    public SolZlibDeflatePipe(int solCompressionLevel) {
        this.init();
        this.compressionLevel = solCompressionLevel;
    }

    private void init() {
    }

    public long deflateAndFlush(byte[] input, int inputStart, int inputEnd, byte[] output, int outputStart, int outputEnd) throws IOException {
        ZStream c_stream = this.defl_stream;
        int returnCode = 0;
        if (!this.defl_stream_init) {
            this.defl_stream_init = true;
            int mem_WBITS = 13;
            returnCode = c_stream.deflateInit(this.compressionLevel, mem_WBITS, true);
            if (returnCode != 0) {
                throw new IOException(ERR_IOEXCEPTION);
            }
        }
        int uncompressedSize = inputEnd - inputStart;
        int compressedAvailable = outputEnd - outputStart;
        c_stream.next_out = output;
        c_stream.next_out_index = outputStart;
        c_stream.avail_out = compressedAvailable;
        c_stream.next_in = input;
        c_stream.next_in_index = inputStart;
        c_stream.avail_in = uncompressedSize;
        int availableIn = uncompressedSize;
        int availableOut = compressedAvailable;
        long prev_total_in = c_stream.total_in;
        long prev_total_out = c_stream.total_out;
        while (c_stream.total_in - prev_total_in < (long)uncompressedSize && c_stream.total_out - prev_total_out < (long)compressedAvailable) {
            c_stream.avail_in = availableIn;
            c_stream.avail_out = availableOut;
            if (c_stream.deflate(2) != 0) {
                throw new IOException(ERR_IOEXCEPTION);
            }
            availableIn -= (int)(c_stream.total_in - prev_total_in);
            availableOut -= (int)(c_stream.total_out - prev_total_out);
        }
        if (availableOut == 0) {
            throw new IOException("Stream compression error: improperly sized compressed output buffer.");
        }
        c_stream.avail_out = availableOut;
        return c_stream.total_out - prev_total_out;
    }

    public SolZlibCallResult inflateChunks(byte[] input, int inputStart, int inputEnd, byte[] output, int outputStart, int outputEnd) {
        AtomicInteger inp_consumed;
        long output_this_chunk;
        int to_process = inputEnd - inputStart;
        int input_consumed = 0;
        int decompressed = 0;
        do {
            inp_consumed = new AtomicInteger(0);
            output_this_chunk = this.inflateChunkWithLookback(input, inputStart, inputEnd, output, outputStart, outputEnd, inp_consumed);
            inputStart += inp_consumed.get();
            outputStart = (int)((long)outputStart + output_this_chunk);
            decompressed = (int)((long)decompressed + output_this_chunk);
            input_consumed += inp_consumed.get();
        } while (output_this_chunk > 0L && (to_process -= inp_consumed.get()) > 0);
        SolZlibCallResult r = new SolZlibCallResult();
        r.bytes_consumed = input_consumed;
        r.bytes_output = decompressed;
        return r;
    }

    public long inflateChunkWithLookback(byte[] input, int inputStart, int inputEnd, byte[] output, int outputStart, int outputEnd, AtomicInteger inputConsumed) {
        long outBytesThisCallStart;
        long inBytesThisPassStart;
        block5: {
            int compressedBufferSize = inputEnd - inputStart;
            int uncompressedBufferAvailableSize = outputEnd - outputStart;
            this.infl_stream.next_in = input;
            this.infl_stream.next_in_index = inputStart;
            this.infl_stream.avail_in = compressedBufferSize;
            this.infl_stream.next_out = output;
            this.infl_stream.next_out_index = outputStart;
            this.infl_stream.avail_out = uncompressedBufferAvailableSize;
            int returnCode = 0;
            if (!this.infl_stream_init) {
                this.infl_stream_init = true;
                returnCode = this.infl_stream.inflateInit(true);
                if (returnCode != 0) {
                    return -1L;
                }
            }
            inBytesThisPassStart = this.infl_stream.total_in;
            outBytesThisCallStart = this.infl_stream.total_out;
            while (true) {
                long outBytesThisPassStart = this.infl_stream.total_out;
                returnCode = this.infl_stream.inflate(2);
                long bytesThisPass = this.infl_stream.total_out - outBytesThisPassStart;
                if (returnCode == 1 || returnCode == 0) {
                    // empty if block
                }
                if (returnCode == 1) {
                    this.infl_stream.inflateEnd();
                    this.infl_stream_init = false;
                    break block5;
                }
                if (returnCode == 0) continue;
                if (returnCode == -5) break block5;
                if (returnCode == -1 || returnCode == -2 || returnCode == -3 || returnCode == -6) break;
            }
            return -1L;
        }
        inputConsumed.set((int)this.infl_stream.total_in - (int)inBytesThisPassStart);
        return this.infl_stream.total_out - outBytesThisCallStart;
    }

    public static void main(String[] arg) {
        SolZlibDeflatePipe.testDecompressFile("c:/z/r1.bin");
    }

    public static void testDecompressFile(String filename) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(filename));
            byte[] z_in = new byte[bis.available()];
            bis.read(z_in);
            bis.close();
            byte[] z_out = new byte[10 * z_in.length];
            SolZlibDeflatePipe z = new SolZlibDeflatePipe(9);
            SolZlibCallResult res = z.inflateChunks(z_in, 0, z_in.length, z_out, 0, z_out.length);
            System.out.println(String.format("Inflated: %s, Output bytes: %s", res.bytes_consumed, res.bytes_output));
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filename + ".infl", false));
            bos.write(z_out, 0, res.bytes_output);
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testFillup() throws IOException {
        int consumed;
        SolZlibCallResult ret;
        byte[] compressedOutput = new byte[abc.length * 20];
        byte[] uncompressedOutput = new byte[10];
        SolZlibDeflatePipe pipe = new SolZlibDeflatePipe(9);
        int compressed = 0;
        int c_pass = 0;
        for (int i = 0; i < abc.length; ++i) {
            c_pass = (int)pipe.deflateAndFlush(abc, 0, i + 1, compressedOutput, compressed, compressedOutput.length);
            compressed += c_pass;
            System.out.println("compression pass: " + c_pass);
        }
        int decompressed = 0;
        System.out.println("INFL block 1");
        for (consumed = 0; consumed < compressed; consumed += ret.bytes_consumed) {
            ret = pipe.inflateChunks(compressedOutput, consumed, compressed, uncompressedOutput, decompressed, uncompressedOutput.length);
            System.out.println("INFL bytes: " + (decompressed += ret.bytes_output));
            if (decompressed != uncompressedOutput.length) continue;
            byte[] newbuf = new byte[uncompressedOutput.length * 2];
            System.arraycopy(uncompressedOutput, 0, newbuf, 0, decompressed);
            uncompressedOutput = newbuf;
        }
        System.out.println(String.format("Complete. Decompressed=%s, Consumed=%s", decompressed, consumed));
        System.out.println("Output data: " + new String(uncompressedOutput, 0, decompressed));
    }

    public static void testLookback() throws IOException {
        byte[] compressedOutput = new byte[abc.length * 20];
        byte[] uncompressedOutput = new byte[abc.length * 20];
        SolZlibDeflatePipe pipe = new SolZlibDeflatePipe(9);
        long compressed = 0L;
        long c_pass = 0L;
        for (int i = 0; i < abc.length; ++i) {
            c_pass = pipe.deflateAndFlush(abc, 0, i + 1, compressedOutput, (int)compressed, compressedOutput.length);
            compressed += c_pass;
            System.out.println("compression pass: " + c_pass);
        }
        long decompressed = 0L;
        long d_pass = 0L;
        System.out.println("INFL block 1");
        int i = 0;
        while ((long)i < compressed) {
            d_pass = pipe.inflateChunks((byte[])compressedOutput, (int)i, (int)(i + 1), (byte[])uncompressedOutput, (int)((int)decompressed), (int)uncompressedOutput.length).bytes_output;
            System.out.println("INFL bytes: " + (decompressed += d_pass));
            ++i;
        }
        System.out.println("Decompressed it, output length: " + decompressed);
        System.out.println("Output data: " + new String(uncompressedOutput, 0, (int)decompressed));
    }
}

