/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.secure;

import com.solacesystems.jcsmp.secure.AuthSSLProtocolSocketFactory;
import com.solacesystems.jcsmp.secure.JCSMPSecureProtocolSocketFactory;
import java.io.Serializable;
import java.net.URL;
import javax.net.ssl.SSLContext;

public class SecureSessionProperties
implements Serializable {
    private static final long serialVersionUID = 2L;
    private transient JCSMPSecureProtocolSocketFactory m_jcsmpSecureProtocolFactory;
    private URL m_truststoreUrl;
    private String m_truststorePassword;

    public SecureSessionProperties(URL truststoreUrl, String truststorePassword) {
        this.m_truststoreUrl = truststoreUrl;
        this.m_truststorePassword = truststorePassword;
    }

    public SecureSessionProperties(JCSMPSecureProtocolSocketFactory factory) {
        this.m_jcsmpSecureProtocolFactory = factory;
    }

    public JCSMPSecureProtocolSocketFactory getJCSMPSecureProtocolFactory() {
        if (this.m_jcsmpSecureProtocolFactory == null && this.m_truststoreUrl != null && this.m_truststorePassword != null) {
            this.m_jcsmpSecureProtocolFactory = new AuthSSLProtocolSocketFactory(null, null, this.m_truststoreUrl, this.m_truststorePassword, null, null);
        }
        return this.m_jcsmpSecureProtocolFactory;
    }

    public SSLContext getSSLContext() {
        if (this.m_jcsmpSecureProtocolFactory != null && this.m_jcsmpSecureProtocolFactory instanceof AuthSSLProtocolSocketFactory) {
            return ((AuthSSLProtocolSocketFactory)this.m_jcsmpSecureProtocolFactory).createSSLContext();
        }
        return null;
    }
}

