/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmpx.impl;

import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.Session;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.protocol.CSMPResponseParser;
import com.solacesystems.jcsmpx.impl.DestinationManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDestinationManager
implements DestinationManager {
    private static final Log Trace = LogFactory.getLog(DefaultDestinationManager.class);
    private LinkedHashSet<Destination> m_store;
    private Destination m_lastDestination = null;
    private Object m_storeMonitor = new Object();

    public DefaultDestinationManager(Session session) {
        this.m_store = new LinkedHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDestinationsNum() {
        Object object = this.m_storeMonitor;
        synchronized (object) {
            return this.m_store.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination getLastDestination() {
        Object object = this.m_storeMonitor;
        synchronized (object) {
            return this.m_lastDestination;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Destination> getStoredDestinations() {
        Object object = this.m_storeMonitor;
        synchronized (object) {
            ArrayList<Destination> l = new ArrayList<Destination>(this.m_store.size());
            Iterator iter = this.m_store.iterator();
            while (iter.hasNext()) {
                l.add((Destination)iter.next());
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDestinationAdd() {
        Object object = this.m_storeMonitor;
        synchronized (object) {
            if (this.m_store == null) {
                this.m_store = new LinkedHashSet();
            }
            this.m_lastDestination = null;
        }
    }

    @Override
    public void handlePartialDestinationsAdd(List<Destination> destinations, JCSMPErrorResponseException opEx) throws JCSMPException {
        if (destinations == null || destinations.size() == 0) {
            return;
        }
        List<Destination> l = this.getSucceededDestinations(destinations, opEx);
        if (l != null && l.size() > 0) {
            this.storeDestinations(l);
        }
    }

    @Override
    public void handlePartialDestinationsRemove(List<Destination> destinations, JCSMPErrorResponseException opEx) throws JCSMPException {
        if (destinations == null || destinations.size() == 0) {
            return;
        }
        List<Destination> l = this.getSucceededDestinations(destinations, opEx);
        if (l != null && l.size() > 0) {
            this.removeDestinations(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemoveDestination() {
        Object object = this.m_storeMonitor;
        synchronized (object) {
            this.removeAllDestinations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllDestinations() {
        Object object = this.m_storeMonitor;
        synchronized (object) {
            this.m_store.clear();
            this.m_lastDestination = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDestinations(List<Destination> destinations) throws JCSMPException {
        Object object = this.m_storeMonitor;
        synchronized (object) {
            if (destinations != null && destinations.size() > 0) {
                this.m_store.removeAll(destinations);
                if (destinations.contains(this.m_lastDestination)) {
                    Destination last2 = null;
                    for (Destination last2 : this.m_store) {
                    }
                    this.m_lastDestination = last2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDestinations(List<Destination> destinations) throws JCSMPException {
        Object object = this.m_storeMonitor;
        synchronized (object) {
            if (destinations != null && destinations.size() > 0) {
                this.m_store.addAll(destinations);
                this.m_lastDestination = destinations.get(destinations.size() - 1);
            }
        }
    }

    protected List<Destination> getSucceededDestinations(List<Destination> destinationsToBeAdded, JCSMPErrorResponseException opEx) {
        if (opEx == null || destinationsToBeAdded == null || destinationsToBeAdded.size() == 0) {
            return null;
        }
        CSMPResponseParser.SUResponseBean responseBean = CSMPResponseParser.onlyInstance().parseSUResponse(opEx);
        if (responseBean != null) {
            if (responseBean.getEntirePacketRejectionReason() != null) {
                if (Trace.isErrorEnabled()) {
                    Trace.error((Object)(JCSMPRB.BUNDLE.getStringSafely("AbstractSubscriptionsManager.entireSUUpdateRejected") + responseBean.getEntirePacketRejectionReason()));
                }
                return null;
            }
            List<CSMPResponseParser.SUPacketBean> failedList = responseBean.getSubscriptionPacketResponseList();
            if (failedList != null && failedList.size() > 0) {
                List<Destination> cloned = DefaultDestinationManager.createShallowCopy(destinationsToBeAdded);
                for (int z = failedList.size() - 1; z >= 0; --z) {
                    CSMPResponseParser.SUPacketBean failedPacket = failedList.get(z);
                    int seqNum = failedPacket.getSequenceNumber();
                    if (seqNum == -1) continue;
                    cloned.remove(seqNum - 1);
                }
                return cloned;
            }
        }
        return null;
    }

    private static final List<Destination> createShallowCopy(List<Destination> old) {
        if (old != null) {
            ArrayList<Destination> l = new ArrayList<Destination>();
            Iterator<Destination> iter = old.iterator();
            while (iter.hasNext()) {
                l.add(iter.next());
            }
            return l;
        }
        return null;
    }
}

