/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jms.SolConnection;
import com.solacesystems.jms.SolConnectionConsumer;
import com.solacesystems.jms.SolConnectionConsumerIF;
import com.solacesystems.jms.SolConnectionConsumerRA;
import com.solacesystems.jms.SolDestinationInfo;
import com.solacesystems.jms.SolTopicSession;
import com.solacesystems.jms.impl.SessionTransactionType;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.property.JMSProperties;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolTopicConnection
extends SolConnection
implements TopicConnection {
    private static final Log log = LogFactory.getLog(SolTopicConnection.class);

    public SolTopicConnection(JMSProperties properties, boolean connectionTypeXA, String username, String password) throws JMSException {
        super(properties, connectionTypeXA, username, password);
        if (log.isDebugEnabled()) {
            log.debug((Object)"SolTopicConnection created.");
        }
    }

    public SolTopicConnection(JMSProperties properties, boolean connectionTypeXA) throws JMSException {
        super(properties, connectionTypeXA);
        if (log.isDebugEnabled()) {
            log.debug((Object)"SolTopicConnection created.");
        }
    }

    public synchronized ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering createConnectionConsumer(). topic: " + (topic == null ? "null" : topic.getTopicName()) + "  messageSelector: " + messageSelector));
        }
        this.checkClosed();
        Validator.checkConsumerTopicDestination((Destination)topic, this, false);
        SolDestinationInfo destInfo = new SolDestinationInfo();
        destInfo.destination = topic;
        destInfo.subscriptionName = null;
        SolConnectionConsumerIF connCons = null;
        Boolean useLegacy = this.mBean.getUseLegacyConnectionConsumer();
        connCons = useLegacy != null && useLegacy != false ? new SolConnectionConsumer(this, destInfo, messageSelector, sessionPool, maxMessages, this.mState) : new SolConnectionConsumerRA(this, destInfo, messageSelector, sessionPool, maxMessages, this.mState);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createConnectionConsumer()");
        }
        return connCons;
    }

    public synchronized TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering createTopicSession().  Transacted: " + transacted + "  acknowledgeMode: " + acknowledgeMode));
        }
        this.checkClosed();
        Validator.checkTransactedAndAckMode(transacted ? SessionTransactionType.LocalTransaction : SessionTransactionType.NoTransaction, acknowledgeMode, this.mConnectionProps.getPropertyBean().getDirectTransport());
        Validator.checkTransactedAndLargeMessaging(transacted ? SessionTransactionType.LocalTransaction : SessionTransactionType.NoTransaction, this.mJCSMPProperties.getBooleanProperty("large_messaging"));
        this.mHasBeenAccessed = true;
        SolTopicSession newSession = new SolTopicSession(this, transacted, acknowledgeMode, this.mState);
        this.mSessions.add(newSession);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createTopicSession().");
        }
        return newSession;
    }
}

