/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionImpl;
import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolQueueSession;
import com.solacesystems.jms.impl.JCSMPXASession;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.message.SolMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TransactionInProgressException;
import javax.jms.XAQueueSession;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolXAQueueSession
extends SolQueueSession
implements XAQueueSession {
    private static final String Component = "XAQueueSession";
    private static final Log log = LogFactory.getLog(SolXAQueueSession.class);
    protected XASessionImpl mXASession;

    public SolXAQueueSession(SolConnectionIF connection, JMSState state) throws JMSException {
        super(connection, false, 1, state);
        this.mSessionProps.enableXA();
        try {
            this.mXASession = (XASessionImpl)connection.getProperties().getJCSMPSession().createXASession();
            this.mSessionProps.getUserProperties().put("XASession", new JCSMPXASession(this.mXASession));
        }
        catch (JCSMPException e) {
            throw Validator.createJMSException("soljms.operation.session.create", (Throwable)((Object)e));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SolXAQueueSession created. State: " + (Object)((Object)state)));
        }
    }

    public Session getSession() throws JMSException {
        return this;
    }

    public synchronized XAResource getXAResource() {
        try {
            return this.mXASession.getXAResource();
        }
        catch (JCSMPException e) {
            return null;
        }
    }

    public void trackMessage(Message message) throws JMSException {
        try {
            this.mXASession.trackMessage(((SolMessage)message).getMessage());
        }
        catch (JCSMPException e) {
            throw Validator.createJMSException("soljms.operation.session.create", (Throwable)((Object)e));
        }
    }

    public void setParentSession(XASessionImpl parentSession) {
        this.mXASession.setParent(parentSession);
    }

    public String getName() {
        if (this.mXASession != null) {
            return this.mXASession.getName();
        }
        return super.getName();
    }

    public QueueSession getQueueSession() throws JMSException {
        return this;
    }

    public void commit() throws JMSException {
        throw new TransactionInProgressException("Can't commit() inside an XAQueueSession");
    }

    public boolean getTransacted() throws JMSException {
        return super.getTransacted();
    }

    public void rollback() throws JMSException {
        throw new TransactionInProgressException("Can't rollback() inside an XAQueueSession");
    }
}

