/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.common.util.Base85;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdGenerator {
    private static final Log log = LogFactory.getLog(IdGenerator.class);
    private static final String UNIQUE_STUB;
    private static int instanceCount;
    private static String hostName;
    private String seed;
    private long sequence;
    private short shortSequence;
    private static final Map<String, Integer> seeds;
    private static List<InetAddress> allLocalInetAddress;
    private MessageDigest md;

    public static synchronized String getLocalIP() {
        InetAddress inetAddress;
        block19: {
            if (allLocalInetAddress == null) {
                block18: {
                    allLocalInetAddress = new ArrayList<InetAddress>();
                    try {
                        String hostname = InetAddress.getLocalHost().getHostName();
                        InetAddress[] all_IPs = InetAddress.getAllByName(hostname);
                        if (all_IPs != null && all_IPs.length > 0) {
                            for (int i = 0; i < all_IPs.length; ++i) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("localhost IP[" + (i + 1) + "]=" + all_IPs[i].getHostAddress()));
                                }
                                allLocalInetAddress.add(all_IPs[i]);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block18;
                        log.debug((Object)"Error looking up local host configuration", (Throwable)e);
                    }
                }
                try {
                    Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
                    if (ifs != null) {
                        while (ifs.hasMoreElements()) {
                            NetworkInterface nif = ifs.nextElement();
                            Enumeration<InetAddress> addresses = nif.getInetAddresses();
                            if (addresses == null) continue;
                            while (addresses.hasMoreElements()) {
                                inetAddress = addresses.nextElement();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Network Interface[" + nif.getName() + "] IP=" + inetAddress.getHostAddress()));
                                }
                                allLocalInetAddress.add(inetAddress);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block19;
                    log.warn((Object)"Error looking up network interface", (Throwable)e);
                }
            }
        }
        String localIP = null;
        String externalIP = null;
        for (int i = 0; i < allLocalInetAddress.size(); ++i) {
            inetAddress = allLocalInetAddress.get(i);
            if (inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress()) continue;
            String ip = inetAddress.getHostAddress();
            if (ip.indexOf("192.") == 0 || ip.indexOf("10.") == 0) {
                localIP = ip;
                continue;
            }
            externalIP = ip;
        }
        if (externalIP != null) {
            localIP = externalIP;
        }
        if (localIP == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Cannot find the local IP, using loopback IP");
            }
            localIP = "127.0.0.1";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using IP: " + localIP));
        }
        return localIP;
    }

    public static String getHostName() {
        return hostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdGenerator() {
        String string = UNIQUE_STUB;
        synchronized (string) {
            this.seed = UNIQUE_STUB + instanceCount++ + ":";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdGenerator(String seed) {
        Map<String, Integer> map = seeds;
        synchronized (map) {
            Integer counts = seeds.get(seed);
            counts = counts == null ? new Integer(1) : new Integer(counts + 1);
            seeds.put(seed, counts);
            this.seed = "ID:" + seed + "-" + counts + ":";
        }
    }

    public synchronized String generateId() {
        return this.seed + this.sequence++;
    }

    public synchronized String generateShortId() {
        if (this.md == null) {
            try {
                this.md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"Error getting MessageDigest Instance SHA-256, cannot generate Ids", (Throwable)e);
                throw new RuntimeException("Error getting MessageDigest Instance SHA-256, cannot generate Ids", e);
            }
        }
        byte[] hash = this.md.digest(this.generateId().getBytes());
        Base85 encoder = Base85.getInstance(Base85.Version.ADOBE_VERSION);
        return encoder.encode(hash, 0, 16);
    }

    public String getSeed() {
        return this.seed;
    }

    public synchronized long getNextSequence() {
        return this.sequence++;
    }

    public synchronized short getNextShortSequence() {
        this.shortSequence = (short)(this.shortSequence + 1);
        return this.shortSequence;
    }

    static {
        seeds = new HashMap<String, Integer>();
        String stub = "";
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        hostName = IdGenerator.getLocalIP();
        if (canAccessSystemProps) {
            try {
                ServerSocket ss = new ServerSocket(0);
                stub = hostName + Long.toHexString(ss.getLocalPort()) + Long.toHexString(System.currentTimeMillis());
                Thread.sleep(100L);
                ss.close();
            }
            catch (Exception ioe) {
                log.warn((Object)"could not generate unique stub", (Throwable)ioe);
            }
        } else {
            stub = hostName + Long.toHexString((long)(Math.random() * 10000.0)) + Long.toHexString(System.currentTimeMillis());
        }
        UNIQUE_STUB = stub;
        allLocalInetAddress = null;
    }
}

