/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.codehaus.jackson.map.ser;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import shaded.parquet.org.codehaus.jackson.annotate.JsonAutoDetect;
import shaded.parquet.org.codehaus.jackson.map.AnnotationIntrospector;
import shaded.parquet.org.codehaus.jackson.map.BeanProperty;
import shaded.parquet.org.codehaus.jackson.map.JsonMappingException;
import shaded.parquet.org.codehaus.jackson.map.JsonSerializer;
import shaded.parquet.org.codehaus.jackson.map.SerializationConfig;
import shaded.parquet.org.codehaus.jackson.map.SerializerFactory;
import shaded.parquet.org.codehaus.jackson.map.Serializers;
import shaded.parquet.org.codehaus.jackson.map.TypeSerializer;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedClass;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedField;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedMember;
import shaded.parquet.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import shaded.parquet.org.codehaus.jackson.map.introspect.BasicBeanDescription;
import shaded.parquet.org.codehaus.jackson.map.introspect.VisibilityChecker;
import shaded.parquet.org.codehaus.jackson.map.jsontype.NamedType;
import shaded.parquet.org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import shaded.parquet.org.codehaus.jackson.map.ser.AnyGetterWriter;
import shaded.parquet.org.codehaus.jackson.map.ser.BasicSerializerFactory;
import shaded.parquet.org.codehaus.jackson.map.ser.BeanPropertyWriter;
import shaded.parquet.org.codehaus.jackson.map.ser.BeanSerializerBuilder;
import shaded.parquet.org.codehaus.jackson.map.ser.BeanSerializerModifier;
import shaded.parquet.org.codehaus.jackson.map.ser.FilteredBeanPropertyWriter;
import shaded.parquet.org.codehaus.jackson.map.ser.MapSerializer;
import shaded.parquet.org.codehaus.jackson.map.ser.PropertyBuilder;
import shaded.parquet.org.codehaus.jackson.map.type.TypeBindings;
import shaded.parquet.org.codehaus.jackson.map.util.ArrayBuilders;
import shaded.parquet.org.codehaus.jackson.map.util.ClassUtil;
import shaded.parquet.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializerFactory
extends BasicSerializerFactory {
    public static final BeanSerializerFactory instance = new BeanSerializerFactory(null);
    protected final SerializerFactory.Config _factoryConfig;

    @Deprecated
    protected BeanSerializerFactory() {
        this(null);
    }

    protected BeanSerializerFactory(SerializerFactory.Config config) {
        if (config == null) {
            config = new ConfigImpl();
        }
        this._factoryConfig = config;
    }

    @Override
    public SerializerFactory.Config getConfig() {
        return this._factoryConfig;
    }

    @Override
    public SerializerFactory withConfig(SerializerFactory.Config config) {
        if (this._factoryConfig == config) {
            return this;
        }
        if (this.getClass() != BeanSerializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanSerializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalSerializers': can not instantiate subtype with " + "additional serializer definitions");
        }
        return new BeanSerializerFactory(config);
    }

    @Override
    protected Iterable<Serializers> customSerializers() {
        return this._factoryConfig.serializers();
    }

    @Override
    public JsonSerializer<Object> createSerializer(SerializationConfig config, JavaType origType, BeanProperty property) throws JsonMappingException {
        boolean staticTyping;
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspect(origType);
        JsonSerializer<Object> ser = this.findSerializerFromAnnotation(config, beanDesc.getClassInfo(), property);
        if (ser != null) {
            return ser;
        }
        JavaType type = this.modifyTypeByAnnotation(config, beanDesc.getClassInfo(), origType);
        boolean bl = staticTyping = type != origType;
        if (type != origType && type.getRawClass() != origType.getRawClass()) {
            beanDesc = (BasicBeanDescription)config.introspect(type);
        }
        if (origType.isContainerType()) {
            return this.buildContainerSerializer(config, type, beanDesc, property, staticTyping);
        }
        for (Serializers serializers : this._factoryConfig.serializers()) {
            ser = serializers.findSerializer(config, type, beanDesc, property);
            if (ser == null) continue;
            return ser;
        }
        ser = this.findSerializerByLookup(type, config, beanDesc, property, staticTyping);
        if (ser != null) {
            return ser;
        }
        ser = this.findSerializerByPrimaryType(type, config, beanDesc, property, staticTyping);
        if (ser != null) {
            return ser;
        }
        ser = this.findBeanSerializer(config, type, beanDesc, property);
        if (ser == null) {
            ser = super.findSerializerByAddonType(config, type, beanDesc, property, staticTyping);
        }
        return ser;
    }

    @Override
    public JsonSerializer<Object> createKeySerializer(SerializationConfig config, JavaType type, BeanProperty property) {
        Serializers serializers;
        if (!this._factoryConfig.hasKeySerializers()) {
            return null;
        }
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspectClassAnnotations(type.getRawClass());
        JsonSerializer<?> ser = null;
        Iterator<Serializers> i$ = this._factoryConfig.keySerializers().iterator();
        while (i$.hasNext() && (ser = (serializers = i$.next()).findSerializer(config, type, beanDesc, property)) == null) {
        }
        return ser;
    }

    public JsonSerializer<Object> findBeanSerializer(SerializationConfig config, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        if (!this.isPotentialBeanType(type.getRawClass())) {
            return null;
        }
        JsonSerializer<Object> serializer = this.constructBeanSerializer(config, beanDesc, property);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                serializer = mod.modifySerializer(config, beanDesc, serializer);
            }
        }
        return serializer;
    }

    public TypeSerializer findPropertyTypeSerializer(JavaType baseType, SerializationConfig config, AnnotatedMember accessor, BeanProperty property) throws JsonMappingException {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyTypeResolver(config, accessor, baseType);
        if (b == null) {
            return this.createTypeSerializer(config, baseType, property);
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(accessor, config, ai);
        return b.buildTypeSerializer(config, baseType, subtypes, property);
    }

    public TypeSerializer findPropertyContentTypeSerializer(JavaType containerType, SerializationConfig config, AnnotatedMember accessor, BeanProperty property) throws JsonMappingException {
        JavaType contentType = containerType.getContentType();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyContentTypeResolver(config, accessor, containerType);
        if (b == null) {
            return this.createTypeSerializer(config, contentType, property);
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(accessor, config, ai);
        return b.buildTypeSerializer(config, contentType, subtypes, property);
    }

    protected JsonSerializer<Object> constructBeanSerializer(SerializationConfig config, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        if (beanDesc.getBeanClass() == Object.class) {
            throw new IllegalArgumentException("Can not create bean serializer for Object.class");
        }
        BeanSerializerBuilder builder = this.constructBeanSerializerBuilder(beanDesc);
        List<BeanPropertyWriter> props = this.findBeanProperties(config, beanDesc);
        if (this._factoryConfig.hasSerializerModifiers()) {
            if (props == null) {
                props = new ArrayList<BeanPropertyWriter>();
            }
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                props = mod.changeProperties(config, beanDesc, props);
            }
        }
        AnnotatedMethod anyGetter = beanDesc.findAnyGetter();
        if (props == null || props.size() == 0) {
            if (anyGetter == null) {
                if (beanDesc.hasKnownClassAnnotations()) {
                    return builder.createDummy();
                }
                return null;
            }
            props = Collections.emptyList();
        } else {
            props = this.filterBeanProperties(config, beanDesc, props);
            props = this.sortBeanProperties(config, beanDesc, props);
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                props = mod.orderProperties(config, beanDesc, props);
            }
        }
        builder.setProperties(props);
        builder.setFilterId(this.findFilterId(config, beanDesc));
        if (anyGetter != null) {
            if (config.isEnabled(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                anyGetter.fixAccess();
            }
            JavaType type = anyGetter.getType(beanDesc.bindingsForBeanType());
            boolean staticTyping = config.isEnabled(SerializationConfig.Feature.USE_STATIC_TYPING);
            JavaType valueType = type.getContentType();
            TypeSerializer typeSer = this.createTypeSerializer(config, valueType, property);
            MapSerializer mapSer = MapSerializer.construct(null, type, staticTyping, typeSer, property, null, null);
            builder.setAnyGetter(new AnyGetterWriter(anyGetter, mapSer));
        }
        this.processViews(config, builder);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                builder = mod.updateBuilder(config, beanDesc, builder);
            }
        }
        return builder.build();
    }

    protected BeanPropertyWriter constructFilteredBeanWriter(BeanPropertyWriter writer, Class<?>[] inViews) {
        return FilteredBeanPropertyWriter.constructViewBased(writer, inViews);
    }

    protected PropertyBuilder constructPropertyBuilder(SerializationConfig config, BasicBeanDescription beanDesc) {
        return new PropertyBuilder(config, beanDesc);
    }

    protected BeanSerializerBuilder constructBeanSerializerBuilder(BasicBeanDescription beanDesc) {
        return new BeanSerializerBuilder(beanDesc);
    }

    protected Object findFilterId(SerializationConfig config, BasicBeanDescription beanDesc) {
        return config.getAnnotationIntrospector().findFilterId(beanDesc.getClassInfo());
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        return ClassUtil.canBeABeanType(type) == null && !ClassUtil.isProxyType(type);
    }

    protected List<BeanPropertyWriter> findBeanProperties(SerializationConfig config, BasicBeanDescription beanDesc) throws JsonMappingException {
        AnnotationIntrospector.ReferenceProperty prop;
        VisibilityChecker<?> vchecker = config.getDefaultVisibilityChecker();
        if (!config.isEnabled(SerializationConfig.Feature.AUTO_DETECT_GETTERS)) {
            vchecker = vchecker.withGetterVisibility(JsonAutoDetect.Visibility.NONE);
        }
        if (!config.isEnabled(SerializationConfig.Feature.AUTO_DETECT_IS_GETTERS)) {
            vchecker = vchecker.withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
        }
        if (!config.isEnabled(SerializationConfig.Feature.AUTO_DETECT_FIELDS)) {
            vchecker = vchecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE);
        }
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        vchecker = intr.findAutoDetectVisibility(beanDesc.getClassInfo(), vchecker);
        LinkedHashMap<String, AnnotatedMethod> methodsByProp = beanDesc.findGetters(vchecker, null);
        LinkedHashMap<String, AnnotatedField> fieldsByProp = beanDesc.findSerializableFields(vchecker, methodsByProp.keySet());
        this.removeIgnorableTypes(config, beanDesc, methodsByProp);
        this.removeIgnorableTypes(config, beanDesc, fieldsByProp);
        if (methodsByProp.isEmpty() && fieldsByProp.isEmpty()) {
            return null;
        }
        boolean staticTyping = this.usesStaticTyping(config, beanDesc, null, null);
        PropertyBuilder pb = this.constructPropertyBuilder(config, beanDesc);
        ArrayList<BeanPropertyWriter> props = new ArrayList<BeanPropertyWriter>(methodsByProp.size());
        TypeBindings typeBind = beanDesc.bindingsForBeanType();
        for (Map.Entry<String, AnnotatedField> entry : fieldsByProp.entrySet()) {
            prop = intr.findReferenceType(entry.getValue());
            if (prop != null && prop.isBackReference()) continue;
            props.add(this._constructWriter(config, typeBind, pb, staticTyping, entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, AnnotatedMember> entry : methodsByProp.entrySet()) {
            prop = intr.findReferenceType(entry.getValue());
            if (prop != null && prop.isBackReference()) continue;
            props.add(this._constructWriter(config, typeBind, pb, staticTyping, entry.getKey(), entry.getValue()));
        }
        return props;
    }

    protected List<BeanPropertyWriter> filterBeanProperties(SerializationConfig config, BasicBeanDescription beanDesc, List<BeanPropertyWriter> props) {
        AnnotatedClass ac;
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        String[] ignored = intr.findPropertiesToIgnore(ac = beanDesc.getClassInfo());
        if (ignored != null && ignored.length > 0) {
            HashSet<String> ignoredSet = ArrayBuilders.arrayToSet(ignored);
            Iterator<BeanPropertyWriter> it = props.iterator();
            while (it.hasNext()) {
                if (!ignoredSet.contains(it.next().getName())) continue;
                it.remove();
            }
        }
        return props;
    }

    protected List<BeanPropertyWriter> sortBeanProperties(SerializationConfig config, BasicBeanDescription beanDesc, List<BeanPropertyWriter> props) {
        List<String> creatorProps = beanDesc.findCreatorPropertyNames();
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        AnnotatedClass ac = beanDesc.getClassInfo();
        String[] propOrder = intr.findSerializationPropertyOrder(ac);
        Boolean alpha = intr.findSerializationSortAlphabetically(ac);
        boolean sort = alpha == null ? config.isEnabled(SerializationConfig.Feature.SORT_PROPERTIES_ALPHABETICALLY) : alpha.booleanValue();
        if (sort || !creatorProps.isEmpty() || propOrder != null) {
            props = this._sortBeanProperties(props, creatorProps, propOrder, sort);
        }
        return props;
    }

    protected void processViews(SerializationConfig config, BeanSerializerBuilder builder) {
        List<BeanPropertyWriter> props = builder.getProperties();
        boolean includeByDefault = config.isEnabled(SerializationConfig.Feature.DEFAULT_VIEW_INCLUSION);
        int propCount = props.size();
        int viewsFound = 0;
        BeanPropertyWriter[] filtered = new BeanPropertyWriter[propCount];
        for (int i = 0; i < propCount; ++i) {
            BeanPropertyWriter bpw = props.get(i);
            Class<?>[] views = bpw.getViews();
            if (views == null) {
                if (!includeByDefault) continue;
                filtered[i] = bpw;
                continue;
            }
            ++viewsFound;
            filtered[i] = this.constructFilteredBeanWriter(bpw, views);
        }
        if (includeByDefault && viewsFound == 0) {
            return;
        }
        builder.setFilteredProperties(filtered);
    }

    protected <T extends AnnotatedMember> void removeIgnorableTypes(SerializationConfig config, BasicBeanDescription beanDesc, Map<String, T> props) {
        if (props.isEmpty()) {
            return;
        }
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        Iterator<Map.Entry<String, T>> it = props.entrySet().iterator();
        HashMap ignores = new HashMap();
        while (it.hasNext()) {
            Map.Entry<String, T> entry = it.next();
            Class<?> type = ((AnnotatedMember)entry.getValue()).getRawType();
            Boolean result = (Boolean)ignores.get(type);
            if (result == null) {
                BasicBeanDescription desc = (BasicBeanDescription)config.introspectClassAnnotations(type);
                AnnotatedClass ac = desc.getClassInfo();
                result = intr.isIgnorableType(ac);
                if (result == null) {
                    result = Boolean.FALSE;
                }
                ignores.put(type, result);
            }
            if (!result.booleanValue()) continue;
            it.remove();
        }
    }

    protected BeanPropertyWriter _constructWriter(SerializationConfig config, TypeBindings typeContext, PropertyBuilder pb, boolean staticTyping, String name, AnnotatedMember accessor) throws JsonMappingException {
        if (config.isEnabled(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            accessor.fixAccess();
        }
        JavaType type = accessor.getType(typeContext);
        BeanProperty.Std property = new BeanProperty.Std(name, type, pb.getClassAnnotations(), accessor);
        JsonSerializer<Object> annotatedSerializer = this.findSerializerFromAnnotation(config, accessor, property);
        TypeSerializer contentTypeSer = null;
        if (ClassUtil.isCollectionMapOrArray(type.getRawClass())) {
            contentTypeSer = this.findPropertyContentTypeSerializer(type, config, accessor, property);
        }
        TypeSerializer typeSer = this.findPropertyTypeSerializer(type, config, accessor, property);
        BeanPropertyWriter pbw = pb.buildWriter(name, type, annotatedSerializer, typeSer, contentTypeSer, accessor, staticTyping);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        pbw.setViews(intr.findSerializationViews(accessor));
        return pbw;
    }

    protected List<BeanPropertyWriter> _sortBeanProperties(List<BeanPropertyWriter> props, List<String> creatorProps, String[] propertyOrder, boolean sort) {
        int size = props.size();
        AbstractMap all = sort ? new TreeMap() : new LinkedHashMap(size * 2);
        for (BeanPropertyWriter w : props) {
            all.put(w.getName(), w);
        }
        LinkedHashMap<String, BeanPropertyWriter> ordered = new LinkedHashMap<String, BeanPropertyWriter>(size * 2);
        if (propertyOrder != null) {
            for (String name : propertyOrder) {
                BeanPropertyWriter w = (BeanPropertyWriter)all.get(name);
                if (w == null) continue;
                ordered.put(name, w);
            }
        }
        for (String name : creatorProps) {
            BeanPropertyWriter w = (BeanPropertyWriter)all.get(name);
            if (w == null) continue;
            ordered.put(name, w);
        }
        ordered.putAll(all);
        return new ArrayList<BeanPropertyWriter>(ordered.values());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigImpl
    extends SerializerFactory.Config {
        protected static final Serializers[] NO_SERIALIZERS = new Serializers[0];
        protected static final BeanSerializerModifier[] NO_MODIFIERS = new BeanSerializerModifier[0];
        protected final Serializers[] _additionalSerializers;
        protected final Serializers[] _additionalKeySerializers;
        protected final BeanSerializerModifier[] _modifiers;

        public ConfigImpl() {
            this(null, null, null);
        }

        protected ConfigImpl(Serializers[] allAdditionalSerializers, Serializers[] allAdditionalKeySerializers, BeanSerializerModifier[] modifiers) {
            this._additionalSerializers = allAdditionalSerializers == null ? NO_SERIALIZERS : allAdditionalSerializers;
            this._additionalKeySerializers = allAdditionalKeySerializers == null ? NO_SERIALIZERS : allAdditionalKeySerializers;
            this._modifiers = modifiers == null ? NO_MODIFIERS : modifiers;
        }

        @Override
        public SerializerFactory.Config withAdditionalSerializers(Serializers additional) {
            if (additional == null) {
                throw new IllegalArgumentException("Can not pass null Serializers");
            }
            Serializers[] all = ArrayBuilders.insertInListNoDup(this._additionalSerializers, additional);
            return new ConfigImpl(all, this._additionalKeySerializers, this._modifiers);
        }

        @Override
        public SerializerFactory.Config withAdditionalKeySerializers(Serializers additional) {
            if (additional == null) {
                throw new IllegalArgumentException("Can not pass null Serializers");
            }
            Serializers[] all = ArrayBuilders.insertInListNoDup(this._additionalKeySerializers, additional);
            return new ConfigImpl(this._additionalSerializers, all, this._modifiers);
        }

        @Override
        public SerializerFactory.Config withSerializerModifier(BeanSerializerModifier modifier) {
            if (modifier == null) {
                throw new IllegalArgumentException("Can not pass null modifier");
            }
            BeanSerializerModifier[] modifiers = ArrayBuilders.insertInListNoDup(this._modifiers, modifier);
            return new ConfigImpl(this._additionalSerializers, this._additionalKeySerializers, modifiers);
        }

        @Override
        public boolean hasSerializers() {
            return this._additionalSerializers.length > 0;
        }

        @Override
        public boolean hasKeySerializers() {
            return this._additionalKeySerializers.length > 0;
        }

        @Override
        public boolean hasSerializerModifiers() {
            return this._modifiers.length > 0;
        }

        @Override
        public Iterable<Serializers> serializers() {
            return ArrayBuilders.arrayAsIterable(this._additionalSerializers);
        }

        @Override
        public Iterable<Serializers> keySerializers() {
            return ArrayBuilders.arrayAsIterable(this._additionalKeySerializers);
        }

        @Override
        public Iterable<BeanSerializerModifier> serializerModifiers() {
            return ArrayBuilders.arrayAsIterable(this._modifiers);
        }
    }
}

