/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.web.servlet.resource;

import de.codecentric.boot.admin.io.resource.InMemoryFileResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class ConcatenatingResourceResolver
extends AbstractResourceResolver {
    private final byte[] delimiter;

    public ConcatenatingResourceResolver(byte[] delimiter) {
        this.delimiter = (byte[])delimiter.clone();
    }

    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String filename = StringUtils.getFilename((String)requestPath);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating concatenated resource '" + filename + "' from " + locations));
            }
            return new InMemoryFileResource(filename, this.buildDescription(locations), this.getContent(locations), this.getLastModified(locations));
        }
        catch (IOException ex) {
            throw new ResourceAccessException("Couldn't concatenate resources [" + locations + "]", ex);
        }
    }

    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourceUrlPath, locations);
    }

    private byte[] getContent(List<? extends Resource> resources) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(2048);
        Iterator<? extends Resource> iter = resources.iterator();
        while (iter.hasNext()) {
            StreamUtils.copy((InputStream)iter.next().getInputStream(), (OutputStream)os);
            if (!iter.hasNext()) continue;
            os.write(this.delimiter);
        }
        return os.toByteArray();
    }

    private long getLastModified(List<? extends Resource> resources) throws IOException {
        long maxLastModified = 0L;
        for (Resource resource : resources) {
            maxLastModified = Math.max(maxLastModified, resource.lastModified());
        }
        return maxLastModified;
    }

    private String buildDescription(Collection<? extends Resource> resources) {
        StringBuilder sb = new StringBuilder("(");
        for (Resource resource : resources) {
            sb.append(resource.getDescription()).append(", ");
        }
        sb.replace(sb.length() - 2, sb.length(), ")");
        return sb.toString();
    }
}

