/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.ColumnMappingPreDowngradeCommand;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaColumnMappingMode;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.FeatureAutomaticallyEnabledByMetadata;
import org.apache.spark.sql.delta.LegacyReaderWriterFeature;
import org.apache.spark.sql.delta.NoMapping$;
import org.apache.spark.sql.delta.PreDowngradeTableFeatureCommand;
import org.apache.spark.sql.delta.RemovableFeature;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import scala.runtime.ModuleSerializationProxy;

public final class ColumnMappingTableFeature$
extends LegacyReaderWriterFeature
implements RemovableFeature,
FeatureAutomaticallyEnabledByMetadata {
    public static final ColumnMappingTableFeature$ MODULE$ = new ColumnMappingTableFeature$();

    static {
        RemovableFeature.$init$(MODULE$);
        FeatureAutomaticallyEnabledByMetadata.$init$(MODULE$);
    }

    @Override
    public boolean automaticallyUpdateProtocolOfExistingTables() {
        return FeatureAutomaticallyEnabledByMetadata.automaticallyUpdateProtocolOfExistingTables$(this);
    }

    @Override
    public boolean requiresHistoryProtection() {
        return RemovableFeature.requiresHistoryProtection$(this);
    }

    @Override
    public boolean historyContainsFeature(SparkSession spark, Snapshot downgradeTxnReadSnapshot) {
        return RemovableFeature.historyContainsFeature$(this, spark, downgradeTxnReadSnapshot);
    }

    @Override
    public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata, SparkSession spark) {
        DeltaColumnMappingMode deltaColumnMappingMode = metadata.columnMappingMode();
        return !NoMapping$.MODULE$.equals(deltaColumnMappingMode);
    }

    @Override
    public boolean validateRemoval(Snapshot snapshot) {
        boolean schemaHasNoColumnMappingMetadata = !DeltaColumnMapping$.MODULE$.schemaHasColumnMappingMetadata(snapshot.schema());
        DeltaColumnMappingMode deltaColumnMappingMode = snapshot.metadata().columnMappingMode();
        boolean metadataHasNoMappingMode = NoMapping$.MODULE$.equals(deltaColumnMappingMode);
        return schemaHasNoColumnMappingMetadata && metadataHasNoMappingMode;
    }

    @Override
    public boolean actionUsesFeature(Action action) {
        Action action2 = action;
        if (action2 instanceof Metadata) {
            Metadata metadata = (Metadata)action2;
            DeltaColumnMappingMode deltaColumnMappingMode = DeltaConfigs$.MODULE$.COLUMN_MAPPING_MODE().fromMetaData(metadata);
            NoMapping$ noMapping$ = NoMapping$.MODULE$;
            return deltaColumnMappingMode == null ? noMapping$ != null : !deltaColumnMappingMode.equals(noMapping$);
        }
        return false;
    }

    @Override
    public PreDowngradeTableFeatureCommand preDowngradeCommand(DeltaTableV2 table) {
        return new ColumnMappingPreDowngradeCommand(table);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ColumnMappingTableFeature$.class);
    }

    private ColumnMappingTableFeature$() {
        super("columnMapping", 2, 5);
    }
}

