/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.LastCheckpointInfo;
import org.apache.spark.sql.delta.LastCheckpointV2;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar;
import scala.runtime.ScalaRunTime$;

public final class LastCheckpointInfo$
implements Serializable {
    public static final LastCheckpointInfo$ MODULE$ = new LastCheckpointInfo$();
    private static final String STORED_CHECKSUM_KEY = "checksum";
    private static final Set<Object> isUnreservedOctet = (Set)Predef$.MODULE$.Set().empty().$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z'))).$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z'))).$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9'))).$plus$plus((IterableOnce)Predef$.MODULE$.wrapString("-._~")).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToByte((byte)LastCheckpointInfo$.$anonfun$isUnreservedOctet$1(BoxesRunTime.unboxToChar((Object)x$6))));

    public Option<LastCheckpointV2> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    public String STORED_CHECKSUM_KEY() {
        return STORED_CHECKSUM_KEY;
    }

    public boolean checksumEnabled(SparkSession spark) {
        return BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.LAST_CHECKPOINT_CHECKSUM_ENABLED()));
    }

    public String serializeToJson(LastCheckpointInfo lastCheckpointInfo, boolean addChecksum, boolean suppressOptionalFields) {
        if (suppressOptionalFields) {
            long x$1 = lastCheckpointInfo.version();
            long x$2 = lastCheckpointInfo.size();
            Option<Object> x$3 = lastCheckpointInfo.parts();
            None$ x$4 = None$.MODULE$;
            None$ x$5 = None$.MODULE$;
            None$ x$6 = None$.MODULE$;
            None$ x$7 = None$.MODULE$;
            Option<String> x$8 = this.apply$default$8();
            return JsonUtils$.MODULE$.toJson(new LastCheckpointInfo(x$1, x$2, x$3, (Option<Object>)x$4, (Option<Object>)x$5, (Option<StructType>)x$7, (Option<LastCheckpointV2>)x$6, x$8), ManifestFactory$.MODULE$.classType(LastCheckpointInfo.class));
        }
        None$ x$9 = None$.MODULE$;
        long x$10 = lastCheckpointInfo.copy$default$1();
        long x$11 = lastCheckpointInfo.copy$default$2();
        Option<Object> x$12 = lastCheckpointInfo.copy$default$3();
        Option<Object> x$13 = lastCheckpointInfo.copy$default$4();
        Option<Object> x$14 = lastCheckpointInfo.copy$default$5();
        Option<StructType> x$15 = lastCheckpointInfo.copy$default$6();
        Option<LastCheckpointV2> x$16 = lastCheckpointInfo.copy$default$7();
        String jsonStr = JsonUtils$.MODULE$.toJson(lastCheckpointInfo.copy(x$10, x$11, x$12, x$13, x$14, x$15, x$16, (Option<String>)x$9), ManifestFactory$.MODULE$.classType(LastCheckpointInfo.class));
        if (!addChecksum) {
            return jsonStr;
        }
        ObjectNode rootNode = (ObjectNode)JsonUtils$.MODULE$.mapper().readValue(jsonStr, ObjectNode.class);
        String checksum = this.treeNodeToChecksum((JsonNode)rootNode);
        return rootNode.put(this.STORED_CHECKSUM_KEY(), checksum).toString();
    }

    public boolean serializeToJson$default$3() {
        return false;
    }

    public LastCheckpointInfo deserializeFromJson(String jsonStr, boolean validate) {
        block1: {
            if (!validate) break block1;
            Tuple2<Option<String>, String> tuple2 = this.getChecksums(jsonStr);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option storedChecksumOpt = (Option)tuple2._1();
            String actualChecksum = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)storedChecksumOpt, (Object)actualChecksum);
            Option storedChecksumOpt2 = (Option)tuple22._1();
            String actualChecksum2 = (String)tuple22._2();
            storedChecksumOpt2.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LastCheckpointInfo$.$anonfun$deserializeFromJson$1(actualChecksum2, x$4))).foreach((Function1 & Serializable)storedChecksum -> {
                throw new IllegalStateException(new StringBuilder(71).append("Checksum validation failed for json: ").append(jsonStr).append(",\n").append("storedChecksum:").append((String)storedChecksum).append(", actualChecksum:").append(actualChecksum2).toString());
            });
        }
        return (LastCheckpointInfo)JsonUtils$.MODULE$.fromJson(jsonStr, ManifestFactory$.MODULE$.classType(LastCheckpointInfo.class));
    }

    public Tuple2<Option<String>, String> getChecksums(String jsonStr) {
        ObjectReader reader = JsonUtils$.MODULE$.mapper().reader().withFeatures(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY});
        JsonNode rootNode = reader.readTree(jsonStr);
        None$ storedChecksum = rootNode.has(this.STORED_CHECKSUM_KEY()) ? new Some((Object)rootNode.get(this.STORED_CHECKSUM_KEY()).asText()) : None$.MODULE$;
        String actualChecksum = this.treeNodeToChecksum(rootNode);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)storedChecksum), (Object)actualChecksum);
    }

    public String treeNodeToChecksum(JsonNode treeNode) {
        ArrayBuffer jsonEntriesBuffer = ArrayBuffer$.MODULE$.empty();
        this.traverseJsonNode$1(treeNode, ArrayBuffer$.MODULE$.empty(), jsonEntriesBuffer);
        String normalizedJsonKeyValues = ((IterableOnceOps)((SeqOps)((StrictOptimizedIterableOps)jsonEntriesBuffer.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LastCheckpointInfo$.$anonfun$treeNodeToChecksum$3(x0$1)))).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(1).append(k).append("=").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        })).sortBy((Function1 & Serializable)x$5 -> Predef$.MODULE$.wrapString(x$5).toSeq(), Ordering.Implicits$.MODULE$.seqOrdering((Ordering)Ordering.Char$.MODULE$))).mkString(",");
        return DigestUtils.md5Hex((String)normalizedJsonKeyValues);
    }

    private Set<Object> isUnreservedOctet() {
        return isUnreservedOctet;
    }

    private String encodeString(String str) {
        String result = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(str.getBytes(StandardCharsets.UTF_8)), (Function1 & Serializable)x0$1 -> LastCheckpointInfo$.$anonfun$encodeString$1(BoxesRunTime.unboxToByte((Object)x0$1)), ClassTag$.MODULE$.apply(String.class))).mkString();
        return new StringBuilder(2).append("\"").append(result).append("\"").toString();
    }

    public LastCheckpointInfo fromFiles(Seq<FileStatus> files) {
        Predef$.MODULE$.assert(files.nonEmpty(), (Function0 & Serializable)() -> "files should be non empty to construct LastCheckpointInfo");
        return new LastCheckpointInfo(FileNames$.MODULE$.checkpointVersion((FileStatus)files.head()), -1L, FileNames$.MODULE$.numCheckpointParts(((FileStatus)files.head()).getPath()), (Option<Object>)new Some(((IterableOnceOps)files.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.getLen()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (Option<Object>)None$.MODULE$, (Option<StructType>)None$.MODULE$, this.apply$default$7(), this.apply$default$8());
    }

    public LastCheckpointInfo apply(long version, long size, Option<Object> parts, Option<Object> sizeInBytes, Option<Object> numOfAddFiles, Option<StructType> checkpointSchema, Option<LastCheckpointV2> v2Checkpoint, Option<String> checksum) {
        return new LastCheckpointInfo(version, size, parts, sizeInBytes, numOfAddFiles, checkpointSchema, v2Checkpoint, checksum);
    }

    public Option<LastCheckpointV2> apply$default$7() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$8() {
        return None$.MODULE$;
    }

    public Option<Tuple8<Object, Object, Option<Object>, Option<Object>, Option<Object>, Option<StructType>, Option<LastCheckpointV2>, Option<String>>> unapply(LastCheckpointInfo x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple8((Object)BoxesRunTime.boxToLong((long)x$0.version()), (Object)BoxesRunTime.boxToLong((long)x$0.size()), x$0.parts(), x$0.sizeInBytes(), x$0.numOfAddFiles(), x$0.checkpointSchema(), x$0.v2Checkpoint(), x$0.checksum()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LastCheckpointInfo$.class);
    }

    public static final /* synthetic */ boolean $anonfun$deserializeFromJson$1(String actualChecksum$1, String x$4) {
        String string = x$4;
        String string2 = actualChecksum$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$treeNodeToChecksum$1(LastCheckpointInfo$ $this, ArrayBuffer prefix$1, ArrayBuffer jsonEntriesBuffer$1, Map.Entry entry) {
        prefix$1.append((Object)MODULE$.encodeString((String)entry.getKey()));
        $this.traverseJsonNode$1((JsonNode)entry.getValue(), prefix$1, jsonEntriesBuffer$1);
        prefix$1.trimEnd(1);
    }

    public static final /* synthetic */ void $anonfun$treeNodeToChecksum$2(LastCheckpointInfo$ $this, ArrayBuffer prefix$1, ArrayBuffer jsonEntriesBuffer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            JsonNode jsonNode = (JsonNode)tuple2._1();
            int index = tuple2._2$mcI$sp();
            prefix$1.append((Object)Integer.toString(index));
            $this.traverseJsonNode$1(jsonNode, prefix$1, jsonEntriesBuffer$1);
            prefix$1.trimEnd(1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final void traverseJsonNode$1(JsonNode currentNode, ArrayBuffer prefix, ArrayBuffer jsonEntriesBuffer$1) {
        if (currentNode.isObject()) {
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(currentNode.fields()).asScala()).foreach((Function1 & Serializable)entry -> {
                LastCheckpointInfo$.$anonfun$treeNodeToChecksum$1(this, prefix, jsonEntriesBuffer$1, entry);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (currentNode.isArray()) {
            ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)currentNode).asScala()).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                LastCheckpointInfo$.$anonfun$treeNodeToChecksum$2(this, prefix, jsonEntriesBuffer$1, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        String nodeValue = currentNode.asText();
        if (currentNode.isTextual()) {
            nodeValue = this.encodeString(nodeValue);
        }
        jsonEntriesBuffer$1.append((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)prefix.mkString("+")), (Object)nodeValue));
    }

    public static final /* synthetic */ boolean $anonfun$treeNodeToChecksum$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k;
            String string = k = (String)tuple2._1();
            String string2 = new StringBuilder(2).append("\"").append(MODULE$.STORED_CHECKSUM_KEY()).append("\"").toString();
            return string == null ? string2 != null : !string.equals(string2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ byte $anonfun$isUnreservedOctet$1(char x$6) {
        return (byte)x$6;
    }

    public static final /* synthetic */ String $anonfun$encodeString$1(byte x0$1) {
        byte by = x0$1;
        switch (by) {
            default: 
        }
        if (MODULE$.isUnreservedOctet().apply((Object)BoxesRunTime.boxToByte((byte)by))) {
            return Character.toString((char)by);
        }
        int c = by & 0xFF;
        return StringOps$.MODULE$.format$extension("%%%02X", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)}));
    }

    private LastCheckpointInfo$() {
    }
}

