/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.delta.DeltaParquetFileFormat;
import org.apache.spark.sql.delta.DeltaParquetFileFormat$;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.delta.files.TahoeLogFileIndex;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelationWithTable$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class ScanWithDeletionVectors$ {
    public static final ScanWithDeletionVectors$ MODULE$ = new ScanWithDeletionVectors$();

    public Option<LogicalPlan> unapply(LogicalRelation a) {
        BaseRelation relation;
        Option<Tuple2<BaseRelation, Option<CatalogTable>>> option;
        LogicalRelation logicalRelation = a;
        if (logicalRelation != null && !(option = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation)).isEmpty() && (relation = (BaseRelation)((Tuple2)option.get())._1()) instanceof HadoopFsRelation) {
            HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)relation;
            FileIndex index = hadoopFsRelation.location();
            FileFormat format = hadoopFsRelation.fileFormat();
            if (index instanceof TahoeFileIndex) {
                TahoeFileIndex tahoeFileIndex = (TahoeFileIndex)index;
                if (format instanceof DeltaParquetFileFormat) {
                    DeltaParquetFileFormat deltaParquetFileFormat = (DeltaParquetFileFormat)format;
                    return this.dvEnabledScanFor(logicalRelation, hadoopFsRelation, deltaParquetFileFormat, tahoeFileIndex);
                }
            }
        }
        return None$.MODULE$;
    }

    public Option<LogicalPlan> dvEnabledScanFor(LogicalRelation scan, HadoopFsRelation hadoopRelation, DeltaParquetFileFormat fileFormat, TahoeFileIndex index) {
        if (!DeletionVectorUtils$.MODULE$.deletionVectorsReadable(index.protocol(), index.metadata())) {
            return None$.MODULE$;
        }
        Predef$.MODULE$.require(!(index instanceof TahoeLogFileIndex), (Function0 & Serializable)() -> "Cannot work with a non-pinned table snapshot of the TahoeFileIndex");
        if (fileFormat.hasTablePath()) {
            return None$.MODULE$;
        }
        Seq filesWithDVs = (Seq)index.matchingFiles((Seq<Expression>)new .colon.colon((Object)Literal$.MODULE$.TrueLiteral(), (List)Nil$.MODULE$), (Seq<Expression>)new .colon.colon((Object)Literal$.MODULE$.TrueLiteral(), (List)Nil$.MODULE$)).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScanWithDeletionVectors$.$anonfun$dvEnabledScanFor$2(x$1)));
        if (filesWithDVs.isEmpty()) {
            return None$.MODULE$;
        }
        Seq planOutput = scan.output();
        SparkSession spark = (SparkSession)SparkSession$.MODULE$.getActiveSession().get();
        LogicalRelation newScan = this.createScanWithSkipRowColumn(spark, scan, fileFormat, index, hadoopRelation);
        Filter rowIndexFilter = this.createRowIndexFilterNode(newScan);
        return new Some((Object)new Project(planOutput, (LogicalPlan)rowIndexFilter));
    }

    public AttributeReference org$apache$spark$sql$delta$ScanWithDeletionVectors$$addRowIndexIfMissing(AttributeReference attribute) {
        StructType newDatatype;
        String string = attribute.name();
        String string2 = FileFormat$.MODULE$.METADATA_NAME();
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null));
        StructType dataType = (StructType)attribute.dataType();
        if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])dataType.fieldNames()), (Object)ParquetFileFormat$.MODULE$.ROW_INDEX())) {
            return attribute;
        }
        StructType x$1 = newDatatype = dataType.add(ParquetFileFormat$.MODULE$.ROW_INDEX_FIELD());
        String x$2 = attribute.copy$default$1();
        boolean x$3 = attribute.copy$default$3();
        Metadata x$4 = attribute.copy$default$4();
        ExprId x$5 = attribute.exprId();
        Seq x$6 = attribute.qualifier();
        return attribute.copy(x$2, (DataType)x$1, x$3, x$4, x$5, x$6);
    }

    private LogicalRelation createScanWithSkipRowColumn(SparkSession spark, LogicalRelation inputScan, DeltaParquetFileFormat fileFormat, TahoeFileIndex tahoeFileIndex, HadoopFsRelation hadoopFsRelation) {
        DeltaParquetFileFormat newFileFormat;
        boolean useMetadataRowIndex = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELETION_VECTORS_USE_METADATA_ROW_INDEX()));
        StructField skipRowField = DeltaParquetFileFormat$.MODULE$.IS_ROW_DELETED_STRUCT_FIELD();
        Seq scanOutputWithMetadata = useMetadataRowIndex ? (((SeqOps)inputScan.output().map((Function1 & Serializable)x$2 -> x$2.name())).contains((Object)FileFormat$.MODULE$.METADATA_NAME()) ? (Seq)inputScan.output().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends AttributeReference, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    String string = A12.name();
                    String string2 = FileFormat$.MODULE$.METADATA_NAME();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return (B1)ScanWithDeletionVectors$.MODULE$.org$apache$spark$sql$delta$ScanWithDeletionVectors$$addRowIndexIfMissing(A12);
                    }
                }
                return (B1)A1;
            }

            public final boolean isDefinedAt(AttributeReference x1) {
                AttributeReference attributeReference = x1;
                if (attributeReference != null) {
                    AttributeReference attributeReference2 = attributeReference;
                    String string = attributeReference2.name();
                    String string2 = FileFormat$.MODULE$.METADATA_NAME();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return true;
                    }
                }
                return true;
            }
        }) : (Seq)inputScan.output().$colon$plus((Object)fileFormat.createFileMetadataCol())) : inputScan.output();
        String x$1 = skipRowField.name();
        DataType x$22 = skipRowField.dataType();
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$22, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$22, x$3, x$4);
        Seq newScanOutput = (Seq)scanOutputWithMetadata.$colon$plus((Object)new AttributeReference(x$1, x$22, x$3, x$4, x$5, x$6));
        StructType newDataSchema = hadoopFsRelation.dataSchema().add(skipRowField);
        DeltaParquetFileFormat x$7 = newFileFormat = fileFormat.copyWithDVInfo(tahoeFileIndex.path().toString(), useMetadataRowIndex);
        StructType x$8 = newDataSchema;
        FileIndex x$9 = hadoopFsRelation.copy$default$1();
        StructType x$10 = hadoopFsRelation.copy$default$2();
        Option x$11 = hadoopFsRelation.copy$default$4();
        Map x$12 = hadoopFsRelation.copy$default$6();
        SparkSession x$13 = hadoopFsRelation.sparkSession();
        HadoopFsRelation newRelation = hadoopFsRelation.copy(x$9, x$10, x$8, x$11, (FileFormat)x$7, x$12, x$13);
        return inputScan.copy((BaseRelation)newRelation, newScanOutput, inputScan.copy$default$3(), inputScan.copy$default$4());
    }

    private Filter createRowIndexFilterNode(LogicalRelation newScan) {
        Seq skipRowColumnRefs = (Seq)newScan.output().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ScanWithDeletionVectors$.$anonfun$createRowIndexFilterNode$1(x$3)));
        Predef$.MODULE$.require(skipRowColumnRefs.size() == 1, (Function0 & Serializable)() -> new StringBuilder(35).append("Expected only one column with name=").append(DeltaParquetFileFormat$.MODULE$.IS_ROW_DELETED_COLUMN_NAME()).toString());
        AttributeReference skipRowColumnRef = (AttributeReference)skipRowColumnRefs.head();
        return new Filter((Expression)new EqualTo((Expression)skipRowColumnRef, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)0))), (LogicalPlan)newScan);
    }

    public static final /* synthetic */ boolean $anonfun$dvEnabledScanFor$2(AddFile x$1) {
        return x$1.deletionVector() != null;
    }

    public static final /* synthetic */ boolean $anonfun$createRowIndexFilterNode$1(AttributeReference x$3) {
        String string = x$3.name();
        String string2 = DeltaParquetFileFormat$.MODULE$.IS_ROW_DELETED_COLUMN_NAME();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private ScanWithDeletionVectors$() {
    }
}

