/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.LogSegment;
import org.apache.spark.sql.delta.UninitializedCheckpointProvider;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.threads.DeltaThreadPool;
import org.apache.spark.sql.delta.util.threads.DeltaThreadPool$;
import org.apache.spark.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

public final class SnapshotManagement$ {
    public static final SnapshotManagement$ MODULE$ = new SnapshotManagement$();
    private static DeltaThreadPool checkpointV2ThreadPool;
    private static DeltaThreadPool deltaLogAsyncUpdateThreadPool;
    private static DeltaThreadPool org$apache$spark$sql$delta$SnapshotManagement$$commitCoordinatorGetCommitsThreadPool;
    private static volatile byte bitmap$0;

    private DeltaThreadPool checkpointV2ThreadPool$lzycompute() {
        SnapshotManagement$ snapshotManagement$ = this;
        synchronized (snapshotManagement$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                int numThreads = BoxesRunTime.unboxToInt((Object)SparkSession$.MODULE$.active().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.CHECKPOINT_V2_DRIVER_THREADPOOL_PARALLELISM()));
                checkpointV2ThreadPool = DeltaThreadPool$.MODULE$.apply("checkpointV2-threadpool", numThreads);
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return checkpointV2ThreadPool;
    }

    public DeltaThreadPool checkpointV2ThreadPool() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.checkpointV2ThreadPool$lzycompute();
        }
        return checkpointV2ThreadPool;
    }

    private DeltaThreadPool deltaLogAsyncUpdateThreadPool$lzycompute() {
        SnapshotManagement$ snapshotManagement$ = this;
        synchronized (snapshotManagement$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                ThreadPoolExecutor tpe = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("delta-state-update", 8, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
                deltaLogAsyncUpdateThreadPool = new DeltaThreadPool(tpe);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return deltaLogAsyncUpdateThreadPool;
    }

    public DeltaThreadPool deltaLogAsyncUpdateThreadPool() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.deltaLogAsyncUpdateThreadPool$lzycompute();
        }
        return deltaLogAsyncUpdateThreadPool;
    }

    private DeltaThreadPool commitCoordinatorGetCommitsThreadPool$lzycompute() {
        SnapshotManagement$ snapshotManagement$ = this;
        synchronized (snapshotManagement$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                int numThreads = BoxesRunTime.unboxToInt((Object)SparkSession$.MODULE$.active().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.COORDINATED_COMMITS_GET_COMMITS_THREAD_POOL_SIZE()));
                ThreadPoolExecutor tpe = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("commit-coordinator-get-commits", numThreads, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
                org$apache$spark$sql$delta$SnapshotManagement$$commitCoordinatorGetCommitsThreadPool = new DeltaThreadPool(tpe);
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return org$apache$spark$sql$delta$SnapshotManagement$$commitCoordinatorGetCommitsThreadPool;
    }

    public DeltaThreadPool org$apache$spark$sql$delta$SnapshotManagement$$commitCoordinatorGetCommitsThreadPool() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.commitCoordinatorGetCommitsThreadPool$lzycompute();
        }
        return org$apache$spark$sql$delta$SnapshotManagement$$commitCoordinatorGetCommitsThreadPool;
    }

    public void verifyDeltaVersions(SparkSession spark, long[] versions, Option<Object> expectedStartVersion, Option<Object> expectedEndVersion) {
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.longArrayOps(versions))) {
            Vector deltaVersions = Predef$.MODULE$.wrapLongArray(versions).toVector();
            NumericRange.Inclusive inclusive = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)deltaVersions.head()))).to(deltaVersions.last());
            Vector vector = deltaVersions;
            if (inclusive == null ? vector != null : !inclusive.equals(vector)) {
                throw DeltaErrors$.MODULE$.deltaVersionsNotContiguousException(spark, (Seq<Object>)deltaVersions);
            }
        }
        expectedStartVersion.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)v -> Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.longArrayOps(versions)) && BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.longArrayOps(versions))) == v, (Function0 & Serializable)() -> new StringBuilder(62).append("Did not get the first delta ").append("file version: ").append(v).append(" to compute Snapshot").toString()));
        expectedEndVersion.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)v -> Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.longArrayOps(versions)) && BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.longArrayOps(versions))) == v, (Function0 & Serializable)() -> new StringBuilder(61).append("Did not get the last delta ").append("file version: ").append(v).append(" to compute Snapshot").toString()));
    }

    public LogSegment appendCommitToLogSegment(LogSegment oldLogSegment, FileStatus commitFileStatus, long committedVersion) {
        Predef$.MODULE$.require(oldLogSegment.version() + 1L == committedVersion);
        long x$1 = committedVersion;
        Seq x$2 = (Seq)oldLogSegment.deltas().$colon$plus((Object)commitFileStatus);
        long x$3 = commitFileStatus.getModificationTime();
        Path x$4 = oldLogSegment.copy$default$1();
        UninitializedCheckpointProvider x$5 = oldLogSegment.copy$default$4();
        return oldLogSegment.copy(x$4, x$1, (Seq<FileStatus>)x$2, x$5, x$3);
    }

    private SnapshotManagement$() {
    }
}

