/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.TypeChange;
import org.apache.spark.sql.delta.TypeWideningMetadata$;
import org.apache.spark.sql.delta.TypeWideningPreviewTableFeature$;
import org.apache.spark.sql.delta.TypeWideningShims$;
import org.apache.spark.sql.delta.TypeWideningTableFeature$;
import org.apache.spark.sql.delta.TypeWideningTableFeatureBase;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.TableFeatureProtocolUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.VarcharType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TypeWidening$ {
    public static final TypeWidening$ MODULE$ = new TypeWidening$();

    public boolean isSupported(Protocol protocol) {
        return new .colon.colon((Object)TypeWideningPreviewTableFeature$.MODULE$, (List)new .colon.colon((Object)TypeWideningTableFeature$.MODULE$, (List)Nil$.MODULE$)).exists((Function1 & Serializable)feature -> BoxesRunTime.boxToBoolean((boolean)protocol.isFeatureSupported(feature)));
    }

    public boolean isEnabled(Protocol protocol, Metadata metadata) {
        boolean isEnabled = BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ENABLE_TYPE_WIDENING().fromMetaData(metadata));
        if (isEnabled && !this.isSupported(protocol)) {
            throw new IllegalStateException(new StringBuilder(94).append("Table property '").append(DeltaConfigs$.MODULE$.ENABLE_TYPE_WIDENING().key()).append("' is ").append("set on the table but this table version doesn't support table feature ").append("'").append(TableFeatureProtocolUtils$.MODULE$.propertyKey(TypeWideningTableFeature$.MODULE$)).append("'.").toString());
        }
        return isEnabled;
    }

    public void ensureFeatureConsistentlyEnabled(Protocol protocol, Metadata metadata, Protocol otherProtocol, Metadata otherMetadata) {
        if (this.isEnabled(protocol, metadata) != this.isEnabled(otherProtocol, otherMetadata)) {
            throw DeltaErrors$.MODULE$.metadataChangedException((Option<CommitInfo>)None$.MODULE$);
        }
    }

    public boolean isTypeChangeSupported(AtomicType fromType, AtomicType toType) {
        return TypeWideningShims$.MODULE$.isTypeChangeSupported(fromType, toType);
    }

    public boolean isTypeChangeSupportedForSchemaEvolution(AtomicType fromType, AtomicType toType) {
        return TypeWideningShims$.MODULE$.isTypeChangeSupportedForSchemaEvolution(fromType, toType);
    }

    public void assertTableReadable(SQLConf conf, Protocol protocol, Metadata metadata) {
        if (BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_TYPE_WIDENING_BYPASS_UNSUPPORTED_TYPE_CHANGE_CHECK())) || !this.isSupported(protocol) || !TypeWideningMetadata$.MODULE$.containsTypeWideningMetadata(metadata.schema())) {
            return;
        }
        TypeWideningMetadata$.MODULE$.getAllTypeChanges(metadata.schema()).foreach((Function1 & Serializable)x0$1 -> {
            TypeWidening$.$anonfun$assertTableReadable$1(protocol, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private boolean stableFeatureCanReadTypeChange(AtomicType fromType, AtomicType toType) {
        Tuple2 tuple2 = new Tuple2((Object)fromType, (Object)toType);
        if (tuple2 != null) {
            AtomicType from = (AtomicType)tuple2._1();
            AtomicType to = (AtomicType)tuple2._2();
            AtomicType atomicType = from;
            AtomicType atomicType2 = to;
            if (!(atomicType != null ? !atomicType.equals(atomicType2) : atomicType2 != null)) {
                return true;
            }
        }
        if (tuple2 != null) {
            AtomicType from = (AtomicType)tuple2._1();
            AtomicType to = (AtomicType)tuple2._2();
            if (from instanceof IntegralType) {
                IntegralType integralType = (IntegralType)from;
                if (to instanceof IntegralType) {
                    IntegralType integralType2 = (IntegralType)to;
                    return integralType.defaultSize() <= integralType2.defaultSize();
                }
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType atomicType3 = (AtomicType)tuple2._2();
            if (FloatType$.MODULE$.equals(atomicType) && DoubleType$.MODULE$.equals(atomicType3)) {
                return true;
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType atomicType4 = (AtomicType)tuple2._2();
            if (DateType$.MODULE$.equals(atomicType) && TimestampNTZType$.MODULE$.equals(atomicType4)) {
                return true;
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType atomicType5 = (AtomicType)tuple2._2();
            if ((ByteType$.MODULE$.equals(atomicType) ? true : (ShortType$.MODULE$.equals(atomicType) ? true : IntegerType$.MODULE$.equals(atomicType))) && DoubleType$.MODULE$.equals(atomicType5)) {
                return true;
            }
        }
        if (tuple2 != null) {
            AtomicType from = (AtomicType)tuple2._1();
            AtomicType to = (AtomicType)tuple2._2();
            if (from instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)from;
                if (to instanceof DecimalType) {
                    DecimalType decimalType2 = (DecimalType)to;
                    return decimalType2.isWiderThan((DataType)decimalType);
                }
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType d = (AtomicType)tuple2._2();
            if ((ByteType$.MODULE$.equals(atomicType) ? true : (ShortType$.MODULE$.equals(atomicType) ? true : IntegerType$.MODULE$.equals(atomicType))) && d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                return decimalType.isWiderThan((DataType)IntegerType$.MODULE$);
            }
        }
        if (tuple2 != null) {
            AtomicType atomicType = (AtomicType)tuple2._1();
            AtomicType d = (AtomicType)tuple2._2();
            if (LongType$.MODULE$.equals(atomicType) && d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                return decimalType.isWiderThan((DataType)LongType$.MODULE$);
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$assertTableReadable$1(Protocol protocol$2, Tuple2 x0$1) {
        TypeChange typeChange;
        TypeChange typeChange2;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (typeChange2 = (TypeChange)tuple2._2()) != null) {
            DataType from = typeChange2.fromType();
            DataType to = typeChange2.toType();
            if (from instanceof AtomicType) {
                AtomicType atomicType;
                AtomicType atomicType2 = (AtomicType)from;
                if (to instanceof AtomicType && MODULE$.isTypeChangeSupported(atomicType2, atomicType = (AtomicType)to)) {
                    return;
                }
            }
        }
        if (tuple2 != null && (typeChange = (TypeChange)tuple2._2()) != null) {
            DataType dataType = typeChange.fromType();
            DataType dataType2 = typeChange.toType();
            if ((dataType instanceof StringType ? true : (dataType instanceof CharType ? true : dataType instanceof VarcharType)) && (dataType2 instanceof StringType ? true : (dataType2 instanceof CharType ? true : dataType2 instanceof VarcharType))) {
                return;
            }
        }
        if (tuple2 != null) {
            Seq fieldPath = (Seq)tuple2._1();
            TypeChange typeChange3 = (TypeChange)tuple2._2();
            if (typeChange3 != null) {
                DataType from = typeChange3.fromType();
                DataType to = typeChange3.toType();
                if (from instanceof AtomicType) {
                    AtomicType atomicType;
                    AtomicType atomicType3 = (AtomicType)from;
                    if (to instanceof AtomicType && MODULE$.stableFeatureCanReadTypeChange(atomicType3, atomicType = (AtomicType)to)) {
                        TypeWideningTableFeatureBase featureName = protocol$2.isFeatureSupported(TypeWideningPreviewTableFeature$.MODULE$) ? TypeWideningPreviewTableFeature$.MODULE$ : TypeWideningTableFeature$.MODULE$;
                        throw DeltaErrors$.MODULE$.unsupportedTypeChangeInPreview((Seq<String>)fieldPath, (DataType)atomicType3, (DataType)atomicType, featureName);
                    }
                }
            }
        }
        if (tuple2 != null) {
            Seq fieldPath = (Seq)tuple2._1();
            TypeChange invalidChange = (TypeChange)tuple2._2();
            throw DeltaErrors$.MODULE$.unsupportedTypeChangeInSchema((Seq<String>)((Seq)fieldPath.$plus$plus(invalidChange.fieldPath())), invalidChange.fromType(), invalidChange.toType());
        }
        throw new MatchError((Object)tuple2);
    }

    private TypeWidening$() {
    }
}

