/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.actions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Base64;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.paths.SparkPath$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor$;
import org.apache.spark.sql.delta.util.Codec$Base85Codec$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rud\u0001\u0002*T\u0001\u0002D\u0001B\u001e\u0001\u0003\u0016\u0004%\ta\u001e\u0005\n\u0003\u0003\u0001!\u0011#Q\u0001\naD\u0011\"a\u0001\u0001\u0005+\u0007I\u0011A<\t\u0013\u0005\u0015\u0001A!E!\u0002\u0013A\bBCA\u0004\u0001\tU\r\u0011\"\u0001\u0002\n!Q\u0011q\u0003\u0001\u0003\u0012\u0003\u0006I!a\u0003\t\u0015\u0005e\u0001A!f\u0001\n\u0003\tY\u0002\u0003\u0006\u0002\u001e\u0001\u0011\t\u0012)A\u0005\u0003#A!\"a\b\u0001\u0005+\u0007I\u0011AA\u0011\u0011)\tI\u0003\u0001B\tB\u0003%\u00111\u0005\u0005\u000b\u0003W\u0001!Q3A\u0005\u0002\u00055\u0002BCA\u0019\u0001\tE\t\u0015!\u0003\u00020!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002\"CAA\u0001!\u0015\r\u0011\"\u0001x\u0011%\t9\n\u0001EC\u0002\u0013\u0005q\u000f\u0003\u0005\u0002\u001e\u0002!\t\"VAP\u0011!\tI\u000b\u0001C\t+\u0006}\u0005\u0002CAW\u0001\u0011EQ+a(\t\u0011\u0005E\u0006\u0001\"\u0005V\u0003?C\u0001\"!.\u0001\t#)\u0016q\u0014\u0005\b\u0003s\u0003A\u0011AA^\u0011\u001d\t\t\u000e\u0001C\u0001\u0003'Dq!a6\u0001\t\u0003\tI\u000eC\u0004\u0002p\u0002!\t!!=\t\u0017\t\u0005\u0001\u0001#b\u0001\n#)\u00161\u0004\u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0011%\u0011I\u0001AA\u0001\n\u0003\u0011Y\u0001C\u0005\u0003\u001a\u0001\t\n\u0011\"\u0001\u0003\u001c!I!q\u0006\u0001\u0012\u0002\u0013\u0005!1\u0004\u0005\n\u0005c\u0001\u0011\u0013!C\u0001\u0005gA\u0011Ba\u000e\u0001#\u0003%\tA!\u000f\t\u0013\tu\u0002!%A\u0005\u0002\t}\u0002\"\u0003B\"\u0001E\u0005I\u0011\u0001B#\u0011%\u0011I\u0005AA\u0001\n\u0003\u0012Y\u0005C\u0005\u0003R\u0001\t\t\u0011\"\u0001\u0002\u001c!I!1\u000b\u0001\u0002\u0002\u0013\u0005!Q\u000b\u0005\n\u0005C\u0002\u0011\u0011!C!\u0005GB\u0011B!\u001d\u0001\u0003\u0003%\tAa\u001d\t\u0013\t]\u0004!!A\u0005B\te\u0004\"\u0003B?\u0001\u0005\u0005I\u0011\tB@\u0011%\u0011\t\tAA\u0001\n\u0003\u0012\u0019\tC\u0005\u0003\u0006\u0002\t\t\u0011\"\u0011\u0003\b\u001e9!1R*\t\u0002\t5eA\u0002*T\u0011\u0003\u0011y\tC\u0004\u000241\"\tAa'\t\u0011\tuEF1A\u0005\u0002]DqAa(-A\u0003%\u0001\u0010C\u0005\u0003\"2\u0012\r\u0011\"\u0001\u0003L!A!1\u0015\u0017!\u0002\u0013\u0011i\u0005\u0003\u0005\u0003&2\u0012\r\u0011\"\u0002x\u0011\u001d\u00119\u000b\fQ\u0001\u000eaD\u0001B!+-\u0005\u0004%)a\u001e\u0005\b\u0005Wc\u0003\u0015!\u0004y\u0011!\u0011i\u000b\fb\u0001\n\u000b9\bb\u0002BXY\u0001\u0006i\u0001\u001f\u0005\u000b\u0005cc\u0003R1A\u0005\u0006\tM\u0006B\u0003BaY!\u0015\r\u0011\"\u0003\u0003D\"9!q\u001a\u0017\u0005\u0004\tE\u0007b\u0002BnY\u0011\u0005!Q\u001c\u0005\n\u0005Wd\u0013\u0013!C\u0001\u00057A\u0011B!<-#\u0003%\tAa\r\t\u0013\t=H&%A\u0005\u0002\t\u0015\u0003b\u0002ByY\u0011\u0005!1\u001f\u0005\n\u0007\u0003a\u0013\u0013!C\u0001\u0005gA\u0011ba\u0001-#\u0003%\tA!\u0012\t\u000f\r\u0015A\u0006\"\u0001\u0004\b!91q\u0002\u0017\u0005\u0002\rE\u0001bBB\u000fY\u0011\u00051q\u0004\u0005\n\u0007Wa\u0013\u0013!C\u0001\u00057A\u0011b!\f-\u0005\u0004%\taa\f\t\u0011\rEB\u0006)A\u0005\u0003oA\u0001ba\r-\t\u0003)6Q\u0007\u0005\b\u0007waC\u0011AB\u001f\u0011\u001d\u0019\u0019\u0005\fC\u0001\u0007\u000bB\u0011ba\u0013-\u0003\u0003%\ti!\u0014\t\u0013\rmC&%A\u0005\u0002\tM\u0002\"CB/YE\u0005I\u0011\u0001B#\u0011%\u0019y\u0006LA\u0001\n\u0003\u001b\t\u0007C\u0005\u0004p1\n\n\u0011\"\u0001\u00034!I1\u0011\u000f\u0017\u0012\u0002\u0013\u0005!Q\t\u0005\n\u0007gb\u0013\u0011!C\u0005\u0007k\u0012\u0001\u0004R3mKRLwN\u001c,fGR|'\u000fR3tGJL\u0007\u000f^8s\u0015\t!V+A\u0004bGRLwN\\:\u000b\u0005Y;\u0016!\u00023fYR\f'B\u0001-Z\u0003\r\u0019\u0018\u000f\u001c\u0006\u00035n\u000bQa\u001d9be.T!\u0001X/\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0016aA8sO\u000e\u00011\u0003\u0002\u0001bO*\u0004\"AY3\u000e\u0003\rT\u0011\u0001Z\u0001\u0006g\u000e\fG.Y\u0005\u0003M\u000e\u0014a!\u00118z%\u00164\u0007C\u00012i\u0013\tI7MA\u0004Qe>$Wo\u0019;\u0011\u0005-\u001chB\u00017r\u001d\ti\u0007/D\u0001o\u0015\tyw,\u0001\u0004=e>|GOP\u0005\u0002I&\u0011!oY\u0001\ba\u0006\u001c7.Y4f\u0013\t!XO\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002sG\u0006Y1\u000f^8sC\u001e,G+\u001f9f+\u0005A\bCA=~\u001d\tQ8\u0010\u0005\u0002nG&\u0011ApY\u0001\u0007!J,G-\u001a4\n\u0005y|(AB*ue&twM\u0003\u0002}G\u0006a1\u000f^8sC\u001e,G+\u001f9fA\u0005q\u0001/\u0019;i\u001fJLe\u000e\\5oK\u00123\u0018a\u00049bi\"|%/\u00138mS:,GI\u001e\u0011\u0002\r=4gm]3u+\t\tY\u0001E\u0003c\u0003\u001b\t\t\"C\u0002\u0002\u0010\r\u0014aa\u00149uS>t\u0007c\u00012\u0002\u0014%\u0019\u0011QC2\u0003\u0007%sG/A\u0004pM\u001a\u001cX\r\u001e\u0011\u0002\u0017ML'0Z%o\u0005f$Xm]\u000b\u0003\u0003#\tAb]5{K&s')\u001f;fg\u0002\n1bY1sI&t\u0017\r\\5usV\u0011\u00111\u0005\t\u0004E\u0006\u0015\u0012bAA\u0014G\n!Aj\u001c8h\u00031\u0019\u0017M\u001d3j]\u0006d\u0017\u000e^=!\u0003-i\u0017\r\u001f*po&sG-\u001a=\u0016\u0005\u0005=\u0002#\u00022\u0002\u000e\u0005\r\u0012\u0001D7bqJ{w/\u00138eKb\u0004\u0013A\u0002\u001fj]&$h\b\u0006\b\u00028\u0005m\u0012QHA \u0003g\n)(a\u001e\u0011\u0007\u0005e\u0002!D\u0001T\u0011\u00151X\u00021\u0001y\u0011\u0019\t\u0019!\u0004a\u0001q\"I\u0011qA\u0007\u0011\u0002\u0003\u0007\u00111\u0002\u0015\t\u0003\u007f\t\u0019%a\u0018\u0002bA!\u0011QIA.\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013AC1o]>$\u0018\r^5p]*!\u0011QJA(\u0003!!\u0017\r^1cS:$'\u0002BA)\u0003'\nqA[1dWN|gN\u0003\u0003\u0002V\u0005]\u0013!\u00034bgR,'\u000f_7m\u0015\t\tI&A\u0002d_6LA!!\u0018\u0002H\ty!j]8o\t\u0016\u001cXM]5bY&TX-A\u0005d_:$XM\u001c;Bg\u000e\u0012\u00111\r\t\u0005\u0003K\ny'\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0014\u0001\u00026bm\u0006LA!!\u001d\u0002h\t9\u0011J\u001c;fO\u0016\u0014\bbBA\r\u001b\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003?i\u0001\u0019AA\u0012\u0011%\tY#\u0004I\u0001\u0002\u0004\ty\u0003\u000b\u0005\u0002x\u0005\r\u0013qLA>G\t\ti\b\u0005\u0003\u0002f\u0005}\u0014\u0002BA\u0014\u0003O\n\u0001\"\u001e8jcV,\u0017\n\u001a\u0015\u0004\u001d\u0005\u0015\u0005\u0003BAD\u0003\u0017k!!!#\u000b\t\u0005%\u0013qJ\u0005\u0005\u0003\u001b\u000bII\u0001\u0006Kg>t\u0017j\u001a8pe\u0016D3ADAI!\r\u0011\u00171S\u0005\u0004\u0003+\u001b'!\u0003;sC:\u001c\u0018.\u001a8u\u00031)h.[9vK\u001aKG.Z%eQ\ry\u0011Q\u0011\u0015\u0004\u001f\u0005E\u0015\u0001C5t\u001f:$\u0015n]6\u0016\u0005\u0005\u0005\u0006c\u00012\u0002$&\u0019\u0011QU2\u0003\u000f\t{w\u000e\\3b]\"\u001a\u0001#!\"\u0002\u0011%\u001c\u0018J\u001c7j]\u0016D3!EAC\u0003)I7OU3mCRLg/\u001a\u0015\u0004%\u0005\u0015\u0015AC5t\u0003\n\u001cx\u000e\\;uK\"\u001a1#!\"\u0002\u000f%\u001cX)\u001c9us\"\u001aA#!\"\u0002\u0019\u0005\u00147o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0015\t\u0005u\u0016Q\u001a\t\u0005\u0003\u007f\u000bI-\u0004\u0002\u0002B*!\u00111YAc\u0003\t17OC\u0002\u0002Hn\u000ba\u0001[1e_>\u0004\u0018\u0002BAf\u0003\u0003\u0014A\u0001U1uQ\"9\u0011qZ\u000bA\u0002\u0005u\u0016!\u0004;bE2,Gj\\2bi&|g.\u0001\u000bd_BLx+\u001b;i\u0003\n\u001cx\u000e\\;uKB\u000bG\u000f\u001b\u000b\u0005\u0003o\t)\u000eC\u0004\u0002PZ\u0001\r!!0\u0002/\r|\u0007/_,ji\"tUm\u001e*fY\u0006$\u0018N^3QCRDGCBA\u001c\u00037\fY\u000fC\u0004\u0002^^\u0001\r!a8\u0002\u0005%$\u0007\u0003BAq\u0003Ol!!a9\u000b\t\u0005\u0015\u00181N\u0001\u0005kRLG.\u0003\u0003\u0002j\u0006\r(\u0001B+V\u0013\u0012Ca!!<\u0018\u0001\u0004A\u0018\u0001\u0004:b]\u0012|W\u000e\u0015:fM&D\u0018AC5oY&tW\rR1uCV\u0011\u00111\u001f\t\u0006E\u0006U\u0018\u0011`\u0005\u0004\u0003o\u001c'!B!se\u0006L\bc\u00012\u0002|&\u0019\u0011Q`2\u0003\t\tKH/\u001a\u0015\u00041\u0005\u0015\u0015aF3ti&l\u0017\r^3e'\u0016\u0014\u0018.\u00197ju\u0016$7+\u001b>fQ\rI\u0012QQ\u0001\u0012g\u0016\u0014\u0018.\u00197ju\u0016$vNQ1tKZ\"D#\u0001=\u0002\t\r|\u0007/\u001f\u000b\u000f\u0003o\u0011iAa\u0004\u0003\u0012\tM!Q\u0003B\f\u0011\u001d18\u0004%AA\u0002aD\u0001\"a\u0001\u001c!\u0003\u0005\r\u0001\u001f\u0005\n\u0003\u000fY\u0002\u0013!a\u0001\u0003\u0017A\u0011\"!\u0007\u001c!\u0003\u0005\r!!\u0005\t\u0013\u0005}1\u0004%AA\u0002\u0005\r\u0002\"CA\u00167A\u0005\t\u0019AA\u0018\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\b+\u0007a\u0014yb\u000b\u0002\u0003\"A!!1\u0005B\u0016\u001b\t\u0011)C\u0003\u0003\u0003(\t%\u0012!C;oG\",7m[3e\u0015\r\tIeY\u0005\u0005\u0005[\u0011)CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tU\"\u0006BA\u0006\u0005?\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003<)\"\u0011\u0011\u0003B\u0010\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"A!\u0011+\t\u0005\r\"qD\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u00119E\u000b\u0003\u00020\t}\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003NA!\u0011Q\rB(\u0013\rq\u0018qM\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u00119F!\u0018\u0011\u0007\t\u0014I&C\u0002\u0003\\\r\u00141!\u00118z\u0011%\u0011y\u0006JA\u0001\u0002\u0004\t\t\"A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005K\u0002bAa\u001a\u0003n\t]SB\u0001B5\u0015\r\u0011YgY\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B8\u0005S\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011\u0015B;\u0011%\u0011yFJA\u0001\u0002\u0004\u00119&\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B'\u0005wB\u0011Ba\u0018(\u0003\u0003\u0005\r!!\u0005\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0005\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u0014\u0002\r\u0015\fX/\u00197t)\u0011\t\tK!#\t\u0013\t}#&!AA\u0002\t]\u0013\u0001\u0007#fY\u0016$\u0018n\u001c8WK\u000e$xN\u001d#fg\u000e\u0014\u0018\u000e\u001d;peB\u0019\u0011\u0011\b\u0017\u0014\t1\n'\u0011\u0013\t\u0005\u0005'\u0013I*\u0004\u0002\u0003\u0016*!!qSA6\u0003\tIw.C\u0002u\u0005+#\"A!$\u0002A\u0011+E*\u0012+J\u001f:{f+R\"U\u001fJ{f)\u0013'F?:\u000bU*R0Q%\u00163\u0015\nW\u0001\"\t\u0016cU\tV%P\u001d~3Vi\u0011+P%~3\u0015\nT#`\u001d\u0006kUi\u0018)S\u000b\u001aK\u0005\fI\u0001\u001f\t\u0016cU\tV%P\u001d~3Vi\u0011+P%~3\u0015\nT#`\u001d\u0006kUiX\"P%\u0016\u000bq\u0004R#M\u000bRKuJT0W\u000b\u000e#vJU0G\u00132+uLT!N\u000b~\u001buJU#!\u00039\u0001\u0016\t\u0016%`\tZ{V*\u0011*L\u000bJ\u000bq\u0002U!U\u0011~#ekX'B%.+%\u000bI\u0001\u0011\u0013:c\u0015JT#`\tZ{V*\u0011*L\u000bJ\u000b\u0011#\u0013(M\u0013:+u\f\u0012,`\u001b\u0006\u00136*\u0012*!\u00039)V+\u0013#`\tZ{V*\u0011*L\u000bJ\u000bq\"V+J\t~#ekX'B%.+%\u000bI\u0001\f'R\u0013Vk\u0011+`)f\u0003V)\u0006\u0002\u00036B!!q\u0017B_\u001b\t\u0011ILC\u0002\u0003<^\u000bQ\u0001^=qKNLAAa0\u0003:\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0011}+gnY8eKJ,\"A!2\u0011\r\t\u001d'1ZA\u001c\u001b\t\u0011IMC\u0002\u0002fVKAA!4\u0003J\naA)\u001a7uC\u0016s7m\u001c3fe\u00069QM\\2pI\u0016\u0014XC\u0001Bj!\u0019\u0011)Na6\u000285\tq+C\u0002\u0003Z^\u0013q!\u00128d_\u0012,'/\u0001\fp]\u0012K7o[,ji\"\u0014V\r\\1uSZ,\u0007+\u0019;i)9\t9Da8\u0003b\n\r(Q\u001dBt\u0005SDq!!8<\u0001\u0004\ty\u000e\u0003\u0005\u0002nn\u0002\n\u00111\u0001y\u0011\u001d\tIb\u000fa\u0001\u0003#Aq!a\b<\u0001\u0004\t\u0019\u0003C\u0005\u0002\bm\u0002\n\u00111\u0001\u0002\f!I\u00111F\u001e\u0011\u0002\u0003\u0007\u0011qF\u0001!_:$\u0015n]6XSRD'+\u001a7bi&4X\rU1uQ\u0012\"WMZ1vYR$#'\u0001\u0011p]\u0012K7o[,ji\"\u0014V\r\\1uSZ,\u0007+\u0019;iI\u0011,g-Y;mi\u0012*\u0014\u0001I8o\t&\u001c8nV5uQJ+G.\u0019;jm\u0016\u0004\u0016\r\u001e5%I\u00164\u0017-\u001e7uIY\nac\u001c8ESN\\w+\u001b;i\u0003\n\u001cx\u000e\\;uKB\u000bG\u000f\u001b\u000b\r\u0003o\u0011)P!?\u0003|\nu(q \u0005\u0007\u0005o|\u0004\u0019\u0001=\u0002\tA\fG\u000f\u001b\u0005\b\u00033y\u0004\u0019AA\t\u0011\u001d\tyb\u0010a\u0001\u0003GA\u0011\"a\u0002@!\u0003\u0005\r!a\u0003\t\u0013\u0005-r\b%AA\u0002\u0005=\u0012\u0001I8o\t&\u001c8nV5uQ\u0006\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5%I\u00164\u0017-\u001e7uIQ\n\u0001e\u001c8ESN\\w+\u001b;i\u0003\n\u001cx\u000e\\;uKB\u000bG\u000f\u001b\u0013eK\u001a\fW\u000f\u001c;%k\u0005Y\u0011N\u001c7j]\u0016Le\u000eT8h)\u0019\t9d!\u0003\u0004\u000e!911\u0002\"A\u0002\u0005M\u0018\u0001\u00023bi\u0006Dq!a\bC\u0001\u0004\t\u0019#\u0001\nv]&\fX/Z%e\u000bb\u0004(/Z:tS>tG\u0003BB\n\u00073\u0001BA!6\u0004\u0016%\u00191qC,\u0003\r\r{G.^7o\u0011\u001d\u0019Yb\u0011a\u0001\u0007'\t\u0011\u0003Z3mKRLwN\u001c,fGR|'oQ8m\u0003i\t7o]3nE2,G)\u001a7fi&|gNV3di>\u0014\b+\u0019;i)!\til!\t\u0004&\r\u001d\u0002bBB\u0012\t\u0002\u0007\u0011QX\u0001\u0011i\u0006\u0014x-\u001a;QCJ,g\u000e\u001e)bi\"Dq!!8E\u0001\u0004\ty\u000e\u0003\u0005\u0004*\u0011\u0003\n\u00111\u0001y\u0003\u0019\u0001(/\u001a4jq\u0006!\u0013m]:f[\ndW\rR3mKRLwN\u001c,fGR|'\u000fU1uQ\u0012\"WMZ1vYR$3'A\u0003F\u001bB#\u0016,\u0006\u0002\u00028\u00051Q)\u0014)U3\u0002\n!\"\u001a8d_\u0012,W+V%E)\u0015A8qGB\u001d\u0011\u001d\ti\u000e\u0013a\u0001\u0003?Da!!<I\u0001\u0004A\u0018AC3oG>$W\rR1uCR\u0019\u0001pa\u0010\t\u000f\r\u0005\u0013\n1\u0001\u0002t\u0006)!-\u001f;fg\u0006)B-Z:fe&\fG.\u001b>f\rJ|WNQ1tKZ\"D\u0003BA\u001c\u0007\u000fBaa!\u0013K\u0001\u0004A\u0018aB3oG>$W\rZ\u0001\u0006CB\u0004H.\u001f\u000b\u000f\u0003o\u0019ye!\u0015\u0004T\rU3qKB-\u0011\u001518\n1\u0001y\u0011\u0019\t\u0019a\u0013a\u0001q\"I\u0011qA&\u0011\u0002\u0003\u0007\u00111\u0002\u0005\b\u00033Y\u0005\u0019AA\t\u0011\u001d\tyb\u0013a\u0001\u0003GA\u0011\"a\u000bL!\u0003\u0005\r!a\f\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq\"\u00199qYf$C-\u001a4bk2$HEN\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019\u0019ga\u001b\u0011\u000b\t\fia!\u001a\u0011\u001b\t\u001c9\u0007\u001f=\u0002\f\u0005E\u00111EA\u0018\u0013\r\u0019Ig\u0019\u0002\u0007)V\u0004H.\u001a\u001c\t\u0013\r5d*!AA\u0002\u0005]\u0012a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAB<!\u0011\t)g!\u001f\n\t\rm\u0014q\r\u0002\u0007\u001f\nTWm\u0019;")
public class DeletionVectorDescriptor
implements Product,
Serializable {
    @JsonIgnore
    private transient String uniqueId;
    @JsonIgnore
    private transient String uniqueFileId;
    @JsonIgnore
    private int estimatedSerializedSize;
    private final String storageType;
    private final String pathOrInlineDv;
    private final Option<Object> offset;
    private final int sizeInBytes;
    private final long cardinality;
    private final Option<Object> maxRowIndex;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Object> $lessinit$greater$default$6() {
        return DeletionVectorDescriptor$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<Object> $lessinit$greater$default$3() {
        return DeletionVectorDescriptor$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple6<String, String, Option<Object>, Object, Object, Option<Object>>> unapply(DeletionVectorDescriptor x$0) {
        return DeletionVectorDescriptor$.MODULE$.unapply(x$0);
    }

    public static Option<Object> apply$default$6() {
        return DeletionVectorDescriptor$.MODULE$.apply$default$6();
    }

    public static Option<Object> apply$default$3() {
        return DeletionVectorDescriptor$.MODULE$.apply$default$3();
    }

    public static DeletionVectorDescriptor apply(String storageType, String pathOrInlineDv, Option<Object> offset, int sizeInBytes, long cardinality, Option<Object> maxRowIndex) {
        return DeletionVectorDescriptor$.MODULE$.apply(storageType, pathOrInlineDv, offset, sizeInBytes, cardinality, maxRowIndex);
    }

    public static DeletionVectorDescriptor deserializeFromBase64(String encoded) {
        return DeletionVectorDescriptor$.MODULE$.deserializeFromBase64(encoded);
    }

    public static String encodeData(byte[] bytes) {
        return DeletionVectorDescriptor$.MODULE$.encodeData(bytes);
    }

    public static DeletionVectorDescriptor EMPTY() {
        return DeletionVectorDescriptor$.MODULE$.EMPTY();
    }

    public static String assembleDeletionVectorPath$default$3() {
        return DeletionVectorDescriptor$.MODULE$.assembleDeletionVectorPath$default$3();
    }

    public static Path assembleDeletionVectorPath(Path targetParentPath, UUID id, String prefix) {
        return DeletionVectorDescriptor$.MODULE$.assembleDeletionVectorPath(targetParentPath, id, prefix);
    }

    public static Column uniqueIdExpression(Column deletionVectorCol) {
        return DeletionVectorDescriptor$.MODULE$.uniqueIdExpression(deletionVectorCol);
    }

    public static DeletionVectorDescriptor inlineInLog(byte[] data, long cardinality) {
        return DeletionVectorDescriptor$.MODULE$.inlineInLog(data, cardinality);
    }

    public static Option<Object> onDiskWithAbsolutePath$default$5() {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithAbsolutePath$default$5();
    }

    public static Option<Object> onDiskWithAbsolutePath$default$4() {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithAbsolutePath$default$4();
    }

    public static DeletionVectorDescriptor onDiskWithAbsolutePath(String path, int sizeInBytes, long cardinality, Option<Object> offset, Option<Object> maxRowIndex) {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithAbsolutePath(path, sizeInBytes, cardinality, offset, maxRowIndex);
    }

    public static Option<Object> onDiskWithRelativePath$default$6() {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithRelativePath$default$6();
    }

    public static Option<Object> onDiskWithRelativePath$default$5() {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithRelativePath$default$5();
    }

    public static String onDiskWithRelativePath$default$2() {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithRelativePath$default$2();
    }

    public static DeletionVectorDescriptor onDiskWithRelativePath(UUID id, String randomPrefix, int sizeInBytes, long cardinality, Option<Object> offset, Option<Object> maxRowIndex) {
        return DeletionVectorDescriptor$.MODULE$.onDiskWithRelativePath(id, randomPrefix, sizeInBytes, cardinality, offset, maxRowIndex);
    }

    public static Encoder<DeletionVectorDescriptor> encoder() {
        return DeletionVectorDescriptor$.MODULE$.encoder();
    }

    public static StructType STRUCT_TYPE() {
        return DeletionVectorDescriptor$.MODULE$.STRUCT_TYPE();
    }

    public static String UUID_DV_MARKER() {
        return DeletionVectorDescriptor$.MODULE$.UUID_DV_MARKER();
    }

    public static String INLINE_DV_MARKER() {
        return DeletionVectorDescriptor$.MODULE$.INLINE_DV_MARKER();
    }

    public static String PATH_DV_MARKER() {
        return DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER();
    }

    public static String DELETION_VECTOR_FILE_NAME_CORE() {
        return DeletionVectorDescriptor$.MODULE$.DELETION_VECTOR_FILE_NAME_CORE();
    }

    public static String DELETION_VECTOR_FILE_NAME_PREFIX() {
        return DeletionVectorDescriptor$.MODULE$.DELETION_VECTOR_FILE_NAME_PREFIX();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String storageType() {
        return this.storageType;
    }

    public String pathOrInlineDv() {
        return this.pathOrInlineDv;
    }

    public Option<Object> offset() {
        return this.offset;
    }

    public int sizeInBytes() {
        return this.sizeInBytes;
    }

    public long cardinality() {
        return this.cardinality;
    }

    public Option<Object> maxRowIndex() {
        return this.maxRowIndex;
    }

    private String uniqueId$lzycompute() {
        DeletionVectorDescriptor deletionVectorDescriptor = this;
        synchronized (deletionVectorDescriptor) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                String string;
                Option<Object> option = this.offset();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int offset = BoxesRunTime.unboxToInt((Object)some.value());
                    string = new StringBuilder(1).append(this.uniqueFileId()).append("@").append(offset).toString();
                } else if (None$.MODULE$.equals(option)) {
                    string = this.uniqueFileId();
                } else {
                    throw new MatchError(option);
                }
                this.uniqueId = string;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.uniqueId;
    }

    public String uniqueId() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.uniqueId$lzycompute();
        }
        return this.uniqueId;
    }

    private String uniqueFileId$lzycompute() {
        DeletionVectorDescriptor deletionVectorDescriptor = this;
        synchronized (deletionVectorDescriptor) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.uniqueFileId = new StringBuilder(0).append(this.storageType()).append(this.pathOrInlineDv()).toString();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.uniqueFileId;
    }

    public String uniqueFileId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.uniqueFileId$lzycompute();
        }
        return this.uniqueFileId;
    }

    @JsonIgnore
    public boolean isOnDisk() {
        return !this.isInline();
    }

    @JsonIgnore
    public boolean isInline() {
        String string = this.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.INLINE_DV_MARKER();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @JsonIgnore
    public boolean isRelative() {
        String string = this.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.UUID_DV_MARKER();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @JsonIgnore
    public boolean isAbsolute() {
        String string = this.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    public Path absolutePath(Path tableLocation) {
        Predef$.MODULE$.require(this.isOnDisk(), (Function0 & Serializable)() -> "Can't get a path for an inline deletion vector");
        String string = this.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.UUID_DV_MARKER();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            int randomPrefixLength = this.pathOrInlineDv().length() - Codec$Base85Codec$.MODULE$.ENCODED_UUID_LENGTH();
            Tuple2 tuple2 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(this.pathOrInlineDv()), randomPrefixLength);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String randomPrefix = (String)tuple2._1();
            String encodedUuid = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)randomPrefix, (Object)encodedUuid);
            String randomPrefix2 = (String)tuple22._1();
            String encodedUuid2 = (String)tuple22._2();
            UUID uuid = Codec$Base85Codec$.MODULE$.decodeUUID(encodedUuid2);
            return DeletionVectorDescriptor$.MODULE$.assembleDeletionVectorPath(tableLocation, uuid, randomPrefix2);
        }
        String string4 = DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            URI parsedUri = new URI(this.pathOrInlineDv());
            Predef$.MODULE$.assert(parsedUri.isAbsolute(), (Function0 & Serializable)() -> "Relative URIs are not supported for DVs");
            return new Path(parsedUri);
        }
        throw DeltaErrors$.MODULE$.cannotReconstructPathFromURI(this.pathOrInlineDv());
    }

    public DeletionVectorDescriptor copyWithAbsolutePath(Path tableLocation) {
        boolean bl;
        String string = this.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.UUID_DV_MARKER();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            Path absolutePath = this.absolutePath(tableLocation);
            return this.copy(DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER(), SparkPath$.MODULE$.fromPath(absolutePath).urlEncoded(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }
        String string4 = DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            bl = true;
        } else {
            String string6 = DeletionVectorDescriptor$.MODULE$.INLINE_DV_MARKER();
            String string7 = string;
            bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
        }
        if (bl) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }
        throw new MatchError((Object)string);
    }

    public DeletionVectorDescriptor copyWithNewRelativePath(UUID id, String randomPrefix) {
        boolean bl;
        String string = this.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.copy(DeletionVectorDescriptor$.MODULE$.UUID_DV_MARKER(), DeletionVectorDescriptor$.MODULE$.encodeUUID(id, randomPrefix), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }
        String string4 = DeletionVectorDescriptor$.MODULE$.UUID_DV_MARKER();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            bl = true;
        } else {
            String string6 = DeletionVectorDescriptor$.MODULE$.INLINE_DV_MARKER();
            String string7 = string;
            bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
        }
        if (bl) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }
        throw new MatchError((Object)string);
    }

    @JsonIgnore
    public byte[] inlineData() {
        Predef$.MODULE$.require(this.isInline(), (Function0 & Serializable)() -> "Can't get data for an on-disk DV from the log.");
        return Codec$Base85Codec$.MODULE$.decodeBytes(this.pathOrInlineDv(), this.sizeInBytes());
    }

    private int estimatedSerializedSize$lzycompute() {
        DeletionVectorDescriptor deletionVectorDescriptor = this;
        synchronized (deletionVectorDescriptor) {
            if (!this.bitmap$0) {
                this.estimatedSerializedSize = 12 + this.storageType().length() + this.pathOrInlineDv().length() + (this.offset().isDefined() ? 4 : 0);
                this.bitmap$0 = true;
            }
        }
        return this.estimatedSerializedSize;
    }

    public int estimatedSerializedSize() {
        if (!this.bitmap$0) {
            return this.estimatedSerializedSize$lzycompute();
        }
        return this.estimatedSerializedSize;
    }

    public String serializeToBase64() {
        String string;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try (DataOutputStream ds = new DataOutputStream(bs);){
            ds.writeLong(this.cardinality());
            ds.writeInt(this.sizeInBytes());
            byte[] storageTypeBytes = this.storageType().getBytes();
            Predef$.MODULE$.assert(storageTypeBytes.length == 1, (Function0 & Serializable)() -> new StringBuilder(34).append("Storage type must be 1byte value: ").append(this.storageType()).toString());
            ds.writeByte(BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(storageTypeBytes))));
            String string2 = this.storageType();
            String string3 = DeletionVectorDescriptor$.MODULE$.INLINE_DV_MARKER();
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                Predef$.MODULE$.assert(this.offset().isDefined());
                ds.writeInt(BoxesRunTime.unboxToInt((Object)this.offset().get()));
            } else {
                Predef$.MODULE$.assert(this.offset().isEmpty());
            }
            ds.writeUTF(this.pathOrInlineDv());
            string = Base64.getEncoder().encodeToString(bs.toByteArray());
        }
        return string;
    }

    public DeletionVectorDescriptor copy(String storageType, String pathOrInlineDv, Option<Object> offset, int sizeInBytes, long cardinality, Option<Object> maxRowIndex) {
        return new DeletionVectorDescriptor(storageType, pathOrInlineDv, offset, sizeInBytes, cardinality, maxRowIndex);
    }

    public String copy$default$1() {
        return this.storageType();
    }

    public String copy$default$2() {
        return this.pathOrInlineDv();
    }

    public Option<Object> copy$default$3() {
        return this.offset();
    }

    public int copy$default$4() {
        return this.sizeInBytes();
    }

    public long copy$default$5() {
        return this.cardinality();
    }

    public Option<Object> copy$default$6() {
        return this.maxRowIndex();
    }

    public String productPrefix() {
        return "DeletionVectorDescriptor";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.storageType();
            }
            case 1: {
                return this.pathOrInlineDv();
            }
            case 2: {
                return this.offset();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.sizeInBytes());
            }
            case 4: {
                return BoxesRunTime.boxToLong((long)this.cardinality());
            }
            case 5: {
                return this.maxRowIndex();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DeletionVectorDescriptor;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "storageType";
            }
            case 1: {
                return "pathOrInlineDv";
            }
            case 2: {
                return "offset";
            }
            case 3: {
                return "sizeInBytes";
            }
            case 4: {
                return "cardinality";
            }
            case 5: {
                return "maxRowIndex";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.storageType()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pathOrInlineDv()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.offset()));
        n = Statics.mix((int)n, (int)this.sizeInBytes());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.cardinality()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.maxRowIndex()));
        return Statics.finalizeHash((int)n, (int)6);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DeletionVectorDescriptor)) return false;
        boolean bl = true;
        if (!bl) return false;
        DeletionVectorDescriptor deletionVectorDescriptor = (DeletionVectorDescriptor)x$1;
        if (this.sizeInBytes() != deletionVectorDescriptor.sizeInBytes()) return false;
        if (this.cardinality() != deletionVectorDescriptor.cardinality()) return false;
        String string = this.storageType();
        String string2 = deletionVectorDescriptor.storageType();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.pathOrInlineDv();
        String string4 = deletionVectorDescriptor.pathOrInlineDv();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Option<Object> option = this.offset();
        Option<Object> option2 = deletionVectorDescriptor.offset();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.maxRowIndex();
        Option<Object> option4 = deletionVectorDescriptor.maxRowIndex();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!deletionVectorDescriptor.canEqual(this)) return false;
        return true;
    }

    public DeletionVectorDescriptor(String storageType, String pathOrInlineDv, @JsonDeserialize(contentAs=Integer.class) Option<Object> offset, int sizeInBytes, long cardinality, @JsonDeserialize(contentAs=Long.class) Option<Object> maxRowIndex) {
        this.storageType = storageType;
        this.pathOrInlineDv = pathOrInlineDv;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
        this.cardinality = cardinality;
        this.maxRowIndex = maxRowIndex;
        Product.$init$((Product)this);
    }
}

