/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafCommand;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOperations$;
import org.apache.spark.sql.delta.DomainMetadataUtils$;
import org.apache.spark.sql.delta.IdentityColumn$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.TableFeature;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.Protocol$;
import org.apache.spark.sql.delta.commands.CloneSource;
import org.apache.spark.sql.delta.commands.CloneTableBase$;
import org.apache.spark.sql.delta.commands.CloneTableBaseUtils;
import org.apache.spark.sql.delta.commands.SnapshotOverwriteOperationMetrics;
import org.apache.spark.sql.delta.coordinatedcommits.CoordinatedCommitsUtils$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t]a!B\u0010!\u0003\u0003i\u0003\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011\u001d\u0003!\u0011!Q\u0001\n!C\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\u0006C\u0002!\tA\u0019\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006[\u0002!\tA\u001c\u0005\u0006k\u0002!\tB\u001e\u0005\b\u0003G\u0002A\u0011BA3\u0011\u001d\tY\b\u0001C\u0005\u0003{Bq!a#\u0001\t\u0013\ti\tC\u0004\u0002\u0018\u0002!I!!'\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\u001e9\u0011\u0011\u0017\u0011\t\u0002\u0005MfAB\u0010!\u0011\u0003\t)\f\u0003\u0004b\u001d\u0011\u0005\u0011\u0011\u001a\u0005\n\u0003\u0017t!\u0019!C\u0001\u0003\u001bD\u0001\"!8\u000fA\u0003%\u0011q\u001a\u0005\n\u0003?t!\u0019!C\u0001\u0003\u001bD\u0001\"!9\u000fA\u0003%\u0011q\u001a\u0005\n\u0003Gt!\u0019!C\u0001\u0003\u001bD\u0001\"!:\u000fA\u0003%\u0011q\u001a\u0005\n\u0003Ot!\u0019!C\u0001\u0003\u001bD\u0001\"!;\u000fA\u0003%\u0011q\u001a\u0005\n\u0003Wt!\u0019!C\u0001\u0003\u001bD\u0001\"!<\u000fA\u0003%\u0011q\u001a\u0005\n\u0003_t!\u0019!C\u0001\u0003\u001bD\u0001\"!=\u000fA\u0003%\u0011q\u001a\u0005\n\u0003gt!\u0019!C\u0001\u0003\u001bD\u0001\"!>\u000fA\u0003%\u0011q\u001a\u0005\b\u0003otA\u0011BA}\u00059\u0019En\u001c8f)\u0006\u0014G.\u001a\"bg\u0016T!!\t\u0012\u0002\u0011\r|W.\\1oINT!a\t\u0013\u0002\u000b\u0011,G\u000e^1\u000b\u0005\u00152\u0013aA:rY*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001q\u0003hO \u0011\u0005=2T\"\u0001\u0019\u000b\u0005E\u0012\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003gQ\nQ\u0001\u001d7b]NT!!\u000e\u0013\u0002\u0011\r\fG/\u00197zgRL!a\u000e\u0019\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003_eJ!A\u000f\u0019\u0003\u00171+\u0017MZ\"p[6\fg\u000e\u001a\t\u0003yuj\u0011\u0001I\u0005\u0003}\u0001\u00121c\u00117p]\u0016$\u0016M\u00197f\u0005\u0006\u001cX-\u0016;jYN\u0004\"\u0001Q!\u000e\u0003QJ!A\u0011\u001b\u0003\u001bM\u000bFjQ8oM\"+G\u000e]3s\u0003-\u0019x.\u001e:dKR\u000b'\r\\3\u0011\u0005q*\u0015B\u0001$!\u0005-\u0019En\u001c8f'>,(oY3\u0002-Q\f'\r\\3Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN\u0004B!\u0013*V+:\u0011!\n\u0015\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b2\na\u0001\u0010:p_Rt$\"A(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Es\u0015A\u0002)sK\u0012,g-\u0003\u0002T)\n\u0019Q*\u00199\u000b\u0005Es\u0005CA%W\u0013\t9FK\u0001\u0004TiJLgnZ\u0001\u000bi\u0006\u0014x-\u001a;QCRD\u0007C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\t17O\u0003\u0002_Q\u00051\u0001.\u00193p_BL!\u0001Y.\u0003\tA\u000bG\u000f[\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\r$WM\u001a\t\u0003y\u0001AQa\u0011\u0003A\u0002\u0011CQa\u0012\u0003A\u0002!CQ\u0001\u0017\u0003A\u0002e\u000ba\u0003Z1uC\u000eC\u0017M\\4f\u0013:4\u0015\u000e\\3BGRLwN\\\u000b\u0002SB\u0011!n[\u0007\u0002\u001d&\u0011AN\u0014\u0002\b\u0005>|G.Z1o\u0003-!\u0018M\u00197f\u000bbL7\u000f^:\u0015\u0005%|\u0007\"\u00029\u0007\u0001\u0004\t\u0018\u0001C:oCB\u001c\bn\u001c;\u0011\u0005I\u001cX\"\u0001\u0012\n\u0005Q\u0014#AE*oCB\u001c\bn\u001c;EKN\u001c'/\u001b9u_J\f1\u0002[1oI2,7\t\\8oKRiq/!\u0003\u0002\u0012\u0005m\u0011QEA\u001b\u0003\u000f\u0002B\u0001_?\u0002\u00029\u0011\u0011p\u001f\b\u0003\u0017jL\u0011aT\u0005\u0003y:\u000bq\u0001]1dW\u0006<W-\u0003\u0002\u007f\u007f\n\u00191+Z9\u000b\u0005qt\u0005\u0003BA\u0002\u0003\u000bi\u0011\u0001J\u0005\u0004\u0003\u000f!#a\u0001*po\"1qe\u0002a\u0001\u0003\u0017\u0001B!a\u0001\u0002\u000e%\u0019\u0011q\u0002\u0013\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000f\u0005Mq\u00011\u0001\u0002\u0016\u0005\u0019A\u000f\u001f8\u0011\u0007I\f9\"C\u0002\u0002\u001a\t\u0012Qc\u00149uS6L7\u000f^5d)J\fgn]1di&|g\u000eC\u0004\u0002\u001e\u001d\u0001\r!a\b\u0002!\u0011,7\u000f^5oCRLwN\u001c+bE2,\u0007c\u0001:\u0002\"%\u0019\u00111\u0005\u0012\u0003\u0011\u0011+G\u000e^1M_\u001eDq!a\n\b\u0001\u0004\tI#A\u0004iIB\u001cuN\u001c4\u0011\t\u0005-\u0012\u0011G\u0007\u0003\u0003[Q1!a\f^\u0003\u0011\u0019wN\u001c4\n\t\u0005M\u0012Q\u0006\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005]r\u00011\u0001\u0002:\u0005qA-\u001a7uC>\u0003XM]1uS>t\u0007\u0003BA\u001e\u0003\u0003r1A]A\u001f\u0013\r\tyDI\u0001\u0010\t\u0016dG/Y(qKJ\fG/[8og&!\u00111IA#\u0005%y\u0005/\u001a:bi&|gNC\u0002\u0002@\tBq!!\u0013\b\u0001\u0004\tY%\u0001\bd_6l\u0017M\u001c3NKR\u0014\u0018nY:\u0011\u000b)\fi%!\u0015\n\u0007\u0005=cJ\u0001\u0004PaRLwN\u001c\t\u0006\u0013J+\u00161\u000b\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003\u0019iW\r\u001e:jG*\u0019\u0011Q\f\u0013\u0002\u0013\u0015DXmY;uS>t\u0017\u0002BA1\u0003/\u0012\u0011bU)M\u001b\u0016$(/[2\u0002+A\u0014X\r]1sKN{WO]2f\u001b\u0016$\u0018\rZ1uCR1\u0011qMA:\u0003o\u0002B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[\u0012\u0013aB1di&|gn]\u0005\u0005\u0003c\nYG\u0001\u0005NKR\fG-\u0019;b\u0011\u0019\t)\b\u0003a\u0001c\u0006qA/\u0019:hKR\u001cf.\u00199tQ>$\bBBA=\u0011\u0001\u0007Q+\u0001\u0004pa:\u000bW.Z\u0001\u0019m\u0016\u0014\u0018NZ=NKR\fG-\u0019;b\u0013:4\u0018M]5b]R\u001cHCBA@\u0003\u000b\u000b9\tE\u0002k\u0003\u0003K1!a!O\u0005\u0011)f.\u001b;\t\r\u0005U\u0014\u00021\u0001r\u0011\u001d\tI)\u0003a\u0001\u0003O\nA$\u001e9eCR,G-T3uC\u0012\fG/Y,ji\"|e/\u001a:sS\u0012,7/A\u0015eKR,'/\\5oK\u000e{wN\u001d3j]\u0006$X\rZ\"p[6LGo]\"p]\u001aLw-\u001e:bi&|gn\u001d\u000b\b\u0011\u0006=\u0015\u0011SAJ\u0011\u00199#\u00021\u0001\u0002\f!1\u0011Q\u000f\u0006A\u0002EDa!!&\u000b\u0001\u0004A\u0015A\u0005<bY&$\u0017\r^3e\u001fZ,'O]5eKN\fq\u0003Z3uKJl\u0017N\\3UCJ<W\r^'fi\u0006$\u0017\r^1\u0015\u0011\u0005\u001d\u00141TAO\u0003?CaaJ\u0006A\u0002\u0005-\u0001BBA;\u0017\u0001\u0007\u0011\u000f\u0003\u0004\u0002z-\u0001\r!V\u0001\u0018I\u0016$XM]7j]\u0016$\u0016M]4fiB\u0013x\u000e^8d_2$\u0002\"!*\u0002,\u00065\u0016q\u0016\t\u0005\u0003S\n9+\u0003\u0003\u0002*\u0006-$\u0001\u0003)s_R|7m\u001c7\t\r\u001db\u0001\u0019AA\u0006\u0011\u001d\t\u0019\u0002\u0004a\u0001\u0003+Aa!!\u001f\r\u0001\u0004)\u0016AD\"m_:,G+\u00192mK\n\u000b7/\u001a\t\u0003y9\u0019RADA\\\u0003{\u00032A[A]\u0013\r\tYL\u0014\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003T1!a1'\u0003!Ig\u000e^3s]\u0006d\u0017\u0002BAd\u0003\u0003\u0014q\u0001T8hO&tw\r\u0006\u0002\u00024\u000611kT+S\u0007\u0016+\"!a4\u0011\t\u0005E\u00171\\\u0007\u0003\u0003'TA!!6\u0002X\u0006!A.\u00198h\u0015\t\tI.\u0001\u0003kCZ\f\u0017bA,\u0002T\u000691kT+S\u0007\u0016\u0003\u0013!D*P+J\u001bUi\u0018$P%6\u000bE+\u0001\bT\u001fV\u00136)R0G\u001fJk\u0015\t\u0016\u0011\u0002\u0017M{UKU\"F?B\u000bE\u000bS\u0001\r'>+&kQ#`!\u0006#\u0006\nI\u0001\u000f'>+&kQ#`-\u0016\u00136+S(O\u0003=\u0019v*\u0016*D\u000b~3VIU*J\u001f:\u0003\u0013A\u0002+B%\u001e+E+A\u0004U\u0003J;U\t\u0016\u0011\u0002!%\u001bvLU#Q\u0019\u0006\u001bUi\u0018#F\u0019R\u000b\u0015!E%T?J+\u0005\u000bT!D\u000b~#U\t\u0014+BA\u0005a\u0001+\u0011*U\u0013RKuJT0C3\u0006i\u0001+\u0011*U\u0013RKuJT0C3\u0002\nQ\u0002^8uC2$\u0015\r^1TSj,G\u0003BA~\u0005\u0003\u00012A[A\u007f\u0013\r\tyP\u0014\u0002\u0005\u0019>tw\rC\u0004\u0003\u0004y\u0001\rA!\u0002\u0002\u0011\u0019LG.\u001a'jgR\u0004bAa\u0002\u0003\u000e\tEQB\u0001B\u0005\u0015\u0011\u0011Y!a6\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u001f\u0011IA\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0011\tIGa\u0005\n\t\tU\u00111\u000e\u0002\b\u0003\u0012$g)\u001b7f\u0001")
public abstract class CloneTableBase
extends LogicalPlan
implements LeafCommand,
CloneTableBaseUtils {
    private final CloneSource sourceTable;
    private final Map<String, String> tablePropertyOverrides;
    private final Path targetPath;
    private Seq<Enumeration.Value> nodePatterns;

    public static String PARTITION_BY() {
        return CloneTableBase$.MODULE$.PARTITION_BY();
    }

    public static String IS_REPLACE_DELTA() {
        return CloneTableBase$.MODULE$.IS_REPLACE_DELTA();
    }

    public static String TARGET() {
        return CloneTableBase$.MODULE$.TARGET();
    }

    public static String SOURCE_VERSION() {
        return CloneTableBase$.MODULE$.SOURCE_VERSION();
    }

    public static String SOURCE_PATH() {
        return CloneTableBase$.MODULE$.SOURCE_PATH();
    }

    public static String SOURCE_FORMAT() {
        return CloneTableBase$.MODULE$.SOURCE_FORMAT();
    }

    public static String SOURCE() {
        return CloneTableBase$.MODULE$.SOURCE();
    }

    @Override
    public Map<String, Object> getOperationMetricsForDeltaLog(SnapshotOverwriteOperationMetrics opMetrics) {
        return CloneTableBaseUtils.getOperationMetricsForDeltaLog$(this, opMetrics);
    }

    @Override
    public Map<String, Object> getOperationMetricsForEventRecord(SnapshotOverwriteOperationMetrics opMetrics) {
        return CloneTableBaseUtils.getOperationMetricsForEventRecord$(this, opMetrics);
    }

    @Override
    public void checkColumnMappingMode(Metadata beforeMetadata, Metadata afterMetadata) {
        CloneTableBaseUtils.checkColumnMappingMode$(this, beforeMetadata, afterMetadata);
    }

    @Override
    public Dataset<AddFile> handleNewDataFiles(String opName, Dataset<AddFile> datasetOfNewFilesToAdd, String qualifiedSourceTableBasePath, DeltaLog destTable) {
        return CloneTableBaseUtils.handleNewDataFiles$(this, opName, datasetOfNewFilesToAdd, qualifiedSourceTableBasePath, destTable);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    @Override
    public LoggingShims.LogStringContext LogStringContext(StringContext sc) {
        return LoggingShims.LogStringContext$(this, sc);
    }

    @Override
    public void logInfo(LogEntry entry) {
        LoggingShims.logInfo$(this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        LoggingShims.logInfo$(this, entry, throwable);
    }

    @Override
    public void logDebug(LogEntry entry) {
        LoggingShims.logDebug$(this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        LoggingShims.logDebug$(this, entry, throwable);
    }

    @Override
    public void logTrace(LogEntry entry) {
        LoggingShims.logTrace$(this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        LoggingShims.logTrace$(this, entry, throwable);
    }

    @Override
    public void logWarning(LogEntry entry) {
        LoggingShims.logWarning$(this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        LoggingShims.logWarning$(this, entry, throwable);
    }

    @Override
    public void logError(LogEntry entry) {
        LoggingShims.logError$(this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        LoggingShims.logError$(this, entry, throwable);
    }

    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public boolean dataChangeInFileAction() {
        return true;
    }

    public boolean tableExists(SnapshotDescriptor snapshot) {
        return snapshot.version() >= 0L;
    }

    public Seq<Row> handleClone(SparkSession spark, OptimisticTransaction txn, DeltaLog destinationTable, Configuration hdpConf, DeltaOperations.Operation deltaOperation, Option<Map<String, SQLMetric>> commandMetrics2) {
        Seq seq;
        FileSystem targetFs = this.targetPath.getFileSystem(hdpConf);
        String qualifiedTarget = targetFs.makeQualified(this.targetPath).toString();
        Path sourcePath = this.sourceTable.dataPath();
        FileSystem sourceFs = sourcePath.getFileSystem(hdpConf);
        String qualifiedSource = sourceFs.makeQualified(sourcePath).toString();
        if (txn.readVersion() < 0L) {
            destinationTable.createLogDirectoriesIfNotExists();
        }
        Metadata metadataToUpdate = this.determineTargetMetadata(spark, txn.snapshot(), deltaOperation.name());
        txn.updateMetadata(metadataToUpdate, true);
        if (txn.snapshot().allFiles().count() > 0L) {
            throw DeltaErrors$.MODULE$.cloneReplaceNonEmptyTable();
        }
        Dataset<AddFile> toAdd = this.sourceTable.allFiles();
        List addedFileList = this.handleNewDataFiles(deltaOperation.name(), toAdd, qualifiedSource, destinationTable).collectAsList();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)addedFileList.size(), CloneTableBase$.MODULE$.org$apache$spark$sql$delta$commands$CloneTableBase$$totalDataSize(addedFileList.iterator()));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        long addedFileCount = sp2._1$mcJ$sp();
        long addedFilesSize = sp2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(addedFileCount, addedFilesSize);
        long addedFileCount2 = sp3._1$mcJ$sp();
        long addedFilesSize2 = sp3._2$mcJ$sp();
        Protocol newProtocol = this.determineTargetProtocol(spark, txn, deltaOperation.name());
        Iterator addFileIter = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(addedFileList.iterator()).asScala();
        try {
            ObjectRef actions = ObjectRef.create((Object)addFileIter.map((Function1 & Serializable)fileToCopy -> {
                boolean x$1 = this.dataChangeInFileAction();
                String x$2 = fileToCopy.copy$default$1();
                Map<String, String> x$3 = fileToCopy.copy$default$2();
                long x$4 = fileToCopy.copy$default$3();
                long x$5 = fileToCopy.copy$default$4();
                String x$6 = fileToCopy.copy$default$6();
                Map<String, String> x$7 = fileToCopy.copy$default$7();
                DeletionVectorDescriptor x$8 = fileToCopy.copy$default$8();
                Option<Object> x$9 = fileToCopy.copy$default$9();
                Option<Object> x$10 = fileToCopy.copy$default$10();
                Option<String> x$11 = fileToCopy.copy$default$11();
                AddFile copiedFile = fileToCopy.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10, x$11);
                None$ x$12 = None$.MODULE$;
                None$ x$13 = None$.MODULE$;
                String x$14 = copiedFile.copy$default$1();
                Map<String, String> x$15 = copiedFile.copy$default$2();
                long x$16 = copiedFile.copy$default$3();
                long x$17 = copiedFile.copy$default$4();
                boolean x$18 = copiedFile.copy$default$5();
                String x$19 = copiedFile.copy$default$6();
                Map<String, String> x$20 = copiedFile.copy$default$7();
                DeletionVectorDescriptor x$21 = copiedFile.copy$default$8();
                Option<String> x$22 = copiedFile.copy$default$11();
                return copiedFile.copy(x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, (Option<Object>)x$12, (Option<Object>)x$13, x$22);
            }));
            this.sourceTable.snapshot().foreach((Function1 & Serializable)sourceSnapshot -> {
                CloneTableBase.$anonfun$handleClone$2(deltaOperation, actions, sourceSnapshot);
                return BoxedUnit.UNIT;
            });
            String sourceName = this.sourceTable.name();
            Map context = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            boolean isReplaceDelta = txn.readVersion() >= 0L;
            SnapshotOverwriteOperationMetrics opMetrics = new SnapshotOverwriteOperationMetrics(this.sourceTable.sizeInBytes(), this.sourceTable.numOfFiles(), addedFileCount2, addedFilesSize2);
            Map<String, Object> commitOpMetrics = this.getOperationMetricsForDeltaLog(opMetrics);
            commandMetrics2.foreach((Function1 & Serializable)commandMetrics -> {
                commitOpMetrics.foreach((Function1 & Serializable)kv -> {
                    CloneTableBase.$anonfun$handleClone$5(commandMetrics, kv);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            this.recordDeltaOperation(destinationTable, new StringBuilder(13).append("delta.").append(deltaOperation.name().toLowerCase()).append(".commit").toString(), this.recordDeltaOperation$default$3(), (Function0 & Serializable)() -> txn.commitLarge(spark, (Iterator<Action>)((Iterator)actions$1.elem), (Option<Protocol>)new Some((Object)newProtocol), deltaOperation, (Map<String, String>)context, (Map<String, String>)commitOpMetrics.mapValues((Function1 & Serializable)x$2 -> CloneTableBase.$anonfun$handleClone$7(BoxesRunTime.unboxToLong((Object)x$2))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            Map cloneLogData = (Map)((MapOps)this.getOperationMetricsForEventRecord(opMetrics).$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.SOURCE()), (Object)sourceName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.SOURCE_FORMAT()), (Object)this.sourceTable.format()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.SOURCE_PATH()), (Object)qualifiedSource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.TARGET()), (Object)qualifiedTarget), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.PARTITION_BY()), this.sourceTable.metadata().partitionColumns()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.IS_REPLACE_DELTA()), (Object)BoxesRunTime.boxToBoolean((boolean)isReplaceDelta))})))).$plus$plus((IterableOnce)this.sourceTable.snapshot().map((Function1 & Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.SOURCE_VERSION()), (Object)BoxesRunTime.boxToLong((long)s.version()))));
            DeltaLog x$23 = destinationTable;
            String x$24 = new StringBuilder(6).append("delta.").append(deltaOperation.name().toLowerCase()).toString();
            Map x$25 = cloneLogData;
            Map<TagDefinition, String> x$26 = this.recordDeltaEvent$default$3();
            Option<Path> x$27 = this.recordDeltaEvent$default$5();
            this.recordDeltaEvent(x$23, x$24, x$26, x$25, x$27);
            seq = this.getOutputSeq(commitOpMetrics);
        }
        finally {
            this.sourceTable.close();
        }
        return seq;
    }

    private Metadata prepareSourceMetadata(SnapshotDescriptor targetSnapshot, String opName) {
        Metadata qual$1 = this.sourceTable.metadata();
        String x$1 = UUID.randomUUID().toString();
        String x$2 = targetSnapshot.metadata().name();
        String x$32 = targetSnapshot.metadata().description();
        Format x$4 = qual$1.copy$default$4();
        String x$5 = qual$1.copy$default$5();
        Seq<String> x$6 = qual$1.copy$default$6();
        Map<String, String> x$7 = qual$1.copy$default$7();
        Option<Object> x$8 = qual$1.copy$default$8();
        Metadata clonedMetadata = qual$1.copy(x$1, x$2, x$32, x$4, x$5, x$6, x$7, x$8);
        if (this.tableExists(targetSnapshot)) {
            Metadata qual$2 = clonedMetadata;
            String x$9 = targetSnapshot.metadata().id();
            String x$10 = qual$2.copy$default$2();
            String x$11 = qual$2.copy$default$3();
            Format x$12 = qual$2.copy$default$4();
            String x$13 = qual$2.copy$default$5();
            Seq<String> x$14 = qual$2.copy$default$6();
            Map<String, String> x$15 = qual$2.copy$default$7();
            Option<Object> x$16 = qual$2.copy$default$8();
            clonedMetadata = qual$2.copy(x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        }
        Map filteredConfiguration = clonedMetadata.configuration().filterKeys((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CloneTableBase.$anonfun$prepareSourceMetadata$1(x$3))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        StructType clonedSchema = IdentityColumn$.MODULE$.copySchemaWithMergedHighWaterMarks(targetSnapshot.deltaLog(), clonedMetadata.schema(), targetSnapshot.metadata().schema());
        Metadata qual$3 = clonedMetadata;
        Map x$17 = filteredConfiguration;
        String x$18 = clonedSchema.json();
        String x$19 = qual$3.copy$default$1();
        String x$20 = qual$3.copy$default$2();
        String x$21 = qual$3.copy$default$3();
        Format x$22 = qual$3.copy$default$4();
        Seq<String> x$23 = qual$3.copy$default$6();
        Option<Object> x$24 = qual$3.copy$default$8();
        return qual$3.copy(x$19, x$20, x$21, x$22, x$18, x$23, (Map<String, String>)x$17, x$24);
    }

    private void verifyMetadataInvariants(SnapshotDescriptor targetSnapshot, Metadata updatedMetadataWithOverrides) {
        DeltaConfigs$.MODULE$.validateConfigurations(this.tablePropertyOverrides);
        this.checkColumnMappingMode(this.sourceTable.metadata(), updatedMetadataWithOverrides);
        if (this.tableExists(targetSnapshot)) {
            this.checkColumnMappingMode(targetSnapshot.metadata(), updatedMetadataWithOverrides);
            return;
        }
    }

    private Map<String, String> determineCoordinatedCommitsConfigurations(SparkSession spark, SnapshotDescriptor targetSnapshot, Map<String, String> validatedOverrides) {
        if (this.tableExists(targetSnapshot)) {
            Predef$.MODULE$.assert(validatedOverrides.isEmpty(), (Function0 & Serializable)() -> "Explicit overrides on Coordinated Commits configurations for existing tables are not supported, and should have been caught earlier.");
            return CoordinatedCommitsUtils$.MODULE$.getExplicitCCConfigurations(targetSnapshot.metadata().configuration());
        }
        if (validatedOverrides.nonEmpty()) {
            return validatedOverrides;
        }
        return CoordinatedCommitsUtils$.MODULE$.getDefaultCCConfigurations(spark, CoordinatedCommitsUtils$.MODULE$.getDefaultCCConfigurations$default$2());
    }

    private Metadata determineTargetMetadata(SparkSession spark, SnapshotDescriptor targetSnapshot, String opName) {
        Metadata metadata = this.prepareSourceMetadata(targetSnapshot, opName);
        Map<String, String> validatedConfigurations = DeltaConfigs$.MODULE$.validateConfigurations(this.tablePropertyOverrides);
        Map<String, String> coordinatedCommitsConfigurationOverrides = CoordinatedCommitsUtils$.MODULE$.getExplicitCCConfigurations(validatedConfigurations);
        Map validatedConfigurationsWithoutCoordinatedCommits = (Map)validatedConfigurations.$minus$minus((IterableOnce)coordinatedCommitsConfigurationOverrides.keys());
        Map<String, String> finalCoordinatedCommitsConfigurations = this.determineCoordinatedCommitsConfigurations(spark, targetSnapshot, coordinatedCommitsConfigurationOverrides);
        Metadata qual$1 = metadata;
        Map x$1 = (Map)((MapOps)metadata.configuration().$plus$plus((IterableOnce)validatedConfigurationsWithoutCoordinatedCommits)).$plus$plus(finalCoordinatedCommitsConfigurations);
        String x$2 = qual$1.copy$default$1();
        String x$3 = qual$1.copy$default$2();
        String x$4 = qual$1.copy$default$3();
        Format x$5 = qual$1.copy$default$4();
        String x$6 = qual$1.copy$default$5();
        Seq<String> x$7 = qual$1.copy$default$6();
        Option<Object> x$8 = qual$1.copy$default$8();
        metadata = qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Map<String, String>)x$1, x$8);
        this.verifyMetadataInvariants(targetSnapshot, metadata);
        return metadata;
    }

    private Protocol determineTargetProtocol(SparkSession spark, OptimisticTransaction txn, String opName) {
        boolean protocolDowngradeAllowed;
        Option<Object> x$8;
        Seq<String> x$7;
        String x$6;
        Format x$5;
        String x$4;
        String x$3;
        Protocol sourceProtocol = this.sourceTable.protocol();
        Protocol targetProtocol = txn.snapshot().protocol();
        Map<String, String> validatedConfigurations = DeltaConfigs$.MODULE$.validateConfigurations(this.tablePropertyOverrides);
        Map configWithOverrides = (Map)txn.metadata().configuration().$plus$plus(validatedConfigurations);
        Metadata qual$1 = txn.metadata();
        Map x$1 = configWithOverrides;
        String x$2 = qual$1.copy$default$1();
        Metadata metadataWithOverrides = qual$1.copy(x$2, x$3 = qual$1.copy$default$2(), x$4 = qual$1.copy$default$3(), x$5 = qual$1.copy$default$4(), x$6 = qual$1.copy$default$5(), x$7 = qual$1.copy$default$6(), (Map<String, String>)x$1, x$8 = qual$1.copy$default$8());
        Tuple3<Object, Object, Set<TableFeature>> tuple3 = Protocol$.MODULE$.minProtocolComponentsFromMetadata(spark, metadataWithOverrides);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        int minReaderVersion = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int minWriterVersion = BoxesRunTime.unboxToInt((Object)tuple3._2());
        Set enabledFeatures = (Set)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)minReaderVersion), (Object)BoxesRunTime.boxToInteger((int)minWriterVersion), (Object)enabledFeatures);
        int minReaderVersion2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int minWriterVersion2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        Set enabledFeatures2 = (Set)tuple32._3();
        boolean bl = protocolDowngradeAllowed = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(DeltaSQLConf$.MODULE$.RESTORE_TABLE_PROTOCOL_DOWNGRADE_ALLOWED())) || !this.tableExists(txn.snapshot());
        if (protocolDowngradeAllowed) {
            minReaderVersion2 = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(minReaderVersion2), sourceProtocol.minReaderVersion());
            minWriterVersion2 = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(minWriterVersion2), sourceProtocol.minWriterVersion());
            Protocol minProtocol = Protocol$.MODULE$.apply(minReaderVersion2, minWriterVersion2).withFeatures((Iterable<TableFeature>)enabledFeatures2);
            return sourceProtocol.merge((Seq<Protocol>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Protocol[]{minProtocol}));
        }
        minReaderVersion2 = BoxesRunTime.unboxToInt((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{targetProtocol.minReaderVersion(), sourceProtocol.minReaderVersion(), minReaderVersion2})).max((Ordering)Ordering.Int$.MODULE$));
        minWriterVersion2 = BoxesRunTime.unboxToInt((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{targetProtocol.minWriterVersion(), sourceProtocol.minWriterVersion(), minWriterVersion2})).max((Ordering)Ordering.Int$.MODULE$));
        Protocol minProtocol = Protocol$.MODULE$.apply(minReaderVersion2, minWriterVersion2).withFeatures((Iterable<TableFeature>)enabledFeatures2);
        return targetProtocol.merge((Seq<Protocol>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Protocol[]{sourceProtocol, minProtocol}));
    }

    public static final /* synthetic */ void $anonfun$handleClone$2(DeltaOperations.Operation deltaOperation$1, ObjectRef actions$1, Snapshot sourceSnapshot) {
        String string = deltaOperation$1.name();
        String string2 = DeltaOperations$.MODULE$.OP_CLONE();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            actions$1.elem = ((Iterator)actions$1.elem).$plus$plus((Function0 & Serializable)() -> DomainMetadataUtils$.MODULE$.handleDomainMetadataForCloneTable(sourceSnapshot.domainMetadata()));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleClone$5(Map commandMetrics$1, Tuple2 kv) {
        ((SQLMetric)commandMetrics$1.apply(kv._1())).set(kv._2$mcJ$sp());
    }

    public static final /* synthetic */ String $anonfun$handleClone$7(long x$2) {
        return Long.toString(x$2);
    }

    public static final /* synthetic */ boolean $anonfun$prepareSourceMetadata$1(String x$3) {
        return !CoordinatedCommitsUtils$.MODULE$.TABLE_PROPERTY_KEYS().contains((Object)x$3);
    }

    public CloneTableBase(CloneSource sourceTable, Map<String, String> tablePropertyOverrides, Path targetPath) {
        this.sourceTable = sourceTable;
        this.tablePropertyOverrides = tablePropertyOverrides;
        this.targetPath = targetPath;
        Command.$init$((Command)this);
        LeafLike.$init$((LeafLike)this);
        LoggingShims.$init$(this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        CloneTableBaseUtils.$init$(this);
        Statics.releaseFence();
    }
}

