/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.coordinatedcommits;

import io.delta.storage.CloseableIterator;
import io.delta.storage.LogStore;
import io.delta.storage.commit.Commit;
import io.delta.storage.commit.CommitCoordinatorClient;
import io.delta.storage.commit.CommitFailedException;
import io.delta.storage.commit.CommitResponse;
import io.delta.storage.commit.CoordinatedCommitsUtils;
import io.delta.storage.commit.TableDescriptor;
import io.delta.storage.commit.UpdatedActions;
import io.delta.storage.commit.actions.AbstractMetadata;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.util.Iterator;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.delta.TransactionExecutionObserver;
import org.apache.spark.sql.delta.TransactionExecutionObserver$;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.util.FileNames$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005eca\u0002\u0006\f!\u0003\r\t\u0001\u0007\u0005\u0006e\u0001!\ta\r\u0005\bu\u0001\u0011\rQ\"\u0001<\u0011\u0019y\u0004A\"\u0001\u000e\u0001\")A\u0005\u0001C!k\"9\u0011q\u0003\u0001\u0005\n\u0005e\u0001bBA\u0013\u0001\u0011E\u0011q\u0005\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\ty\u0004\u0001C\t\u0003\u0003B\u0001\"a\u0014\u0001\r#i\u0011\u0011\u000b\u00020\u0003\n\u001cHO]1di\n\u000bGo\u00195CC\u000e\\g-\u001b7mS:<7i\\7nSR\u001cun\u001c:eS:\fGo\u001c:DY&,g\u000e\u001e\u0006\u0003\u00195\t!cY8pe\u0012Lg.\u0019;fI\u000e|W.\\5ug*\u0011abD\u0001\u0006I\u0016dG/\u0019\u0006\u0003!E\t1a]9m\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\n\u0005\u0001e\tC\u0006\u0005\u0002\u001b?5\t1D\u0003\u0002\u001d;\u0005!A.\u00198h\u0015\u0005q\u0012\u0001\u00026bm\u0006L!\u0001I\u000e\u0003\r=\u0013'.Z2u!\t\u0011#&D\u0001$\u0015\t!S%\u0001\u0004d_6l\u0017\u000e\u001e\u0006\u0003M\u001d\nqa\u001d;pe\u0006<WM\u0003\u0002\u000fQ)\t\u0011&\u0001\u0002j_&\u00111f\t\u0002\u0018\u0007>lW.\u001b;D_>\u0014H-\u001b8bi>\u00148\t\\5f]R\u0004\"!\f\u0019\u000e\u00039R!aL\t\u0002\u0011%tG/\u001a:oC2L!!\r\u0018\u0003\u00191{wmZ5oONC\u0017.\\:\u0002\r\u0011Jg.\u001b;%)\u0005!\u0004CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$\u0001B+oSR\f\u0011BY1uG\"\u001c\u0016N_3\u0016\u0003q\u0002\"!N\u001f\n\u0005y2$\u0001\u0002'p]\u001e\f!bY8n[&$\u0018*\u001c9m)!\tEI\u0013+]Y:\u001c\bC\u0001\u0012C\u0013\t\u00195E\u0001\bD_6l\u0017\u000e\u001e*fgB|gn]3\t\u000b\u0015\u001b\u0001\u0019\u0001$\u0002\u00111|wm\u0015;pe\u0016\u0004\"a\u0012%\u000e\u0003\u0015J!!S\u0013\u0003\u00111{wm\u0015;pe\u0016DQaS\u0002A\u00021\u000b!\u0002[1e_>\u00048i\u001c8g!\ti%+D\u0001O\u0015\ty\u0005+\u0001\u0003d_:4'BA)\u0014\u0003\u0019A\u0017\rZ8pa&\u00111K\u0014\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000bU\u001b\u0001\u0019\u0001,\u0002\u000f1|w\rU1uQB\u0011qKW\u0007\u00021*\u0011\u0011\fU\u0001\u0003MNL!a\u0017-\u0003\tA\u000bG\u000f\u001b\u0005\u0006;\u000e\u0001\rAX\u0001\u001cG>|'\u000fZ5oCR,GmQ8n[&$8\u000fV1cY\u0016\u001cuN\u001c4\u0011\t}3\u0017.\u001b\b\u0003A\u0012\u0004\"!\u0019\u001c\u000e\u0003\tT!aY\f\u0002\rq\u0012xn\u001c;?\u0013\t)g'\u0001\u0004Qe\u0016$WMZ\u0005\u0003O\"\u00141!T1q\u0015\t)g\u0007\u0005\u0002`U&\u00111\u000e\u001b\u0002\u0007'R\u0014\u0018N\\4\t\u000b5\u001c\u0001\u0019\u0001\u001f\u0002\u001b\r|W.\\5u-\u0016\u00148/[8o\u0011\u0015y7\u00011\u0001q\u0003)\u0019w.\\7ji\u001aKG.\u001a\t\u0003/FL!A\u001d-\u0003\u0015\u0019KG.Z*uCR,8\u000fC\u0003u\u0007\u0001\u0007A(A\bd_6l\u0017\u000e\u001e+j[\u0016\u001cH/Y7q)!\teo\u001e=~}\u00065\u0001\"B#\u0005\u0001\u00041\u0005\"B&\u0005\u0001\u0004a\u0005\"B=\u0005\u0001\u0004Q\u0018!\u0003;bE2,G)Z:d!\t\u001130\u0003\u0002}G\tyA+\u00192mK\u0012+7o\u0019:jaR|'\u000fC\u0003n\t\u0001\u0007A\b\u0003\u0004\u0000\t\u0001\u0007\u0011\u0011A\u0001\bC\u000e$\u0018n\u001c8t!\u0015\t\u0019!!\u0003j\u001b\t\t)AC\u0002\u0002\bu\tA!\u001e;jY&!\u00111BA\u0003\u0005!IE/\u001a:bi>\u0014\bbBA\b\t\u0001\u0007\u0011\u0011C\u0001\u000fkB$\u0017\r^3e\u0003\u000e$\u0018n\u001c8t!\r\u0011\u00131C\u0005\u0004\u0003+\u0019#AD+qI\u0006$X\rZ!di&|gn]\u0001#SN\u001cun\u001c:eS:\fG/\u001a3D_6l\u0017\u000e^:U_\u001a\u001b6i\u001c8wKJ\u001c\u0018n\u001c8\u0015\r\u0005m\u0011\u0011EA\u0012!\r)\u0014QD\u0005\u0004\u0003?1$a\u0002\"p_2,\u0017M\u001c\u0005\u0006[\u0016\u0001\r\u0001\u0010\u0005\b\u0003\u001f)\u0001\u0019AA\t\u000319WM\\3sCR,W+V%E)\u0005I\u0017!\u00052bG.4\u0017\u000e\u001c7U_Z+'o]5p]RYA'!\f\u00020\u0005E\u00121GA\u001c\u0011\u0015)u\u00011\u0001G\u0011\u0015Yu\u00011\u0001M\u0011\u0015Ix\u00011\u0001{\u0011\u0019\t)d\u0002a\u0001y\u00059a/\u001a:tS>t\u0007bBA\u001d\u000f\u0001\u0007\u00111H\u0001\u001eY\u0006\u001cHo\u00138po:\u0014\u0015mY6gS2dW\r\u001a,feNLwN\\(qiB\u0019!$!\u0010\n\u0005yZ\u0012\u0001\u00032bG.4\u0017\u000e\u001c7\u0015\u0017Q\n\u0019%!\u0012\u0002H\u0005%\u00131\n\u0005\u0006\u000b\"\u0001\rA\u0012\u0005\u0006\u0017\"\u0001\r\u0001\u0014\u0005\u0006+\"\u0001\rA\u0016\u0005\u0007\u0003kA\u0001\u0019\u0001\u001f\t\r\u00055\u0003\u00021\u0001q\u0003)1\u0017\u000e\\3Ti\u0006$Xo]\u0001\u0011e\u0016<\u0017n\u001d;fe\n\u000b7m\u001b4jY2$R\u0001NA*\u0003+BQ!V\u0005A\u0002YCa!a\u0016\n\u0001\u0004a\u0014!\u00052bG.4\u0017\u000e\u001c7fIZ+'o]5p]\u0002")
public interface AbstractBatchBackfillingCommitCoordinatorClient
extends CommitCoordinatorClient,
LoggingShims {
    public long batchSize();

    public CommitResponse commitImpl(LogStore var1, Configuration var2, Path var3, Map<String, String> var4, long var5, FileStatus var7, long var8);

    public static /* synthetic */ CommitResponse commit$(AbstractBatchBackfillingCommitCoordinatorClient $this, LogStore logStore, Configuration hadoopConf, TableDescriptor tableDesc, long commitVersion, Iterator actions, UpdatedActions updatedActions) {
        return $this.commit(logStore, hadoopConf, tableDesc, commitVersion, actions, updatedActions);
    }

    default public CommitResponse commit(LogStore logStore, Configuration hadoopConf, TableDescriptor tableDesc, long commitVersion, Iterator<String> actions, UpdatedActions updatedActions) {
        Path logPath = tableDesc.getLogPath();
        TransactionExecutionObserver executionObserver = (TransactionExecutionObserver)TransactionExecutionObserver$.MODULE$.getObserver();
        Path tablePath = CoordinatedCommitsUtils.getTablePath((Path)logPath);
        if (commitVersion == 0L) {
            throw new CommitFailedException(false, false, "Commit version 0 must go via filesystem.");
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to commit version "}))).log((Seq<MDC>)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " on table "}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.VERSION(), BoxesRunTime.boxToLong((long)commitVersion))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATH(), tablePath)})))));
        FileSystem fs = logPath.getFileSystem(hadoopConf);
        if (this.batchSize() <= 1L) {
            this.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Making sure commits are backfilled until "}))).log((Seq<MDC>)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " version for"}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.VERSION(), BoxesRunTime.boxToLong((long)(commitVersion - 1L)))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" table ", ""}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATH(), tablePath.toString())})))));
            this.backfillToVersion(logStore, hadoopConf, tableDesc, commitVersion - 1L, null);
        }
        FileStatus fileStatus = CoordinatedCommitsUtils.writeUnbackfilledCommitFile((LogStore)logStore, (Configuration)hadoopConf, (String)logPath.toString(), (long)commitVersion, actions, (String)this.generateUUID());
        long commitTimestamp = updatedActions.getCommitInfo().getCommitTimestamp();
        CommitResponse commitResponse = this.commitImpl(logStore, hadoopConf, logPath, (Map<String, String>)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(tableDesc.getTableConf()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), commitVersion, fileStatus, commitTimestamp);
        boolean mcToFsConversion = this.isCoordinatedCommitsToFSConversion(commitVersion, updatedActions);
        executionObserver.beginBackfill();
        if (this.batchSize() <= 1L) {
            this.backfill(logStore, hadoopConf, logPath, commitVersion, fileStatus);
            Path targetFile = FileNames$.MODULE$.unsafeDeltaFile(logPath, commitVersion);
            FileStatus targetFileStatus = fs.getFileStatus(targetFile);
            Commit newCommit = commitResponse.getCommit().withFileStatus(targetFileStatus);
            commitResponse = new CommitResponse(newCommit);
        } else if (commitVersion % this.batchSize() == 0L || mcToFsConversion) {
            this.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Making sure commits are backfilled till "}))).log((Seq<MDC>)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.VERSION(), BoxesRunTime.boxToLong((long)commitVersion))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"version for table ", ""}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATH(), tablePath.toString())})))));
            this.backfillToVersion(logStore, hadoopConf, tableDesc, commitVersion, null);
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Commit ", " done successfully on table "}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.VERSION(), BoxesRunTime.boxToLong((long)commitVersion))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATH(), tablePath)})))));
        return commitResponse;
    }

    private boolean isCoordinatedCommitsToFSConversion(long commitVersion, UpdatedActions updatedActions) {
        boolean oldMetadataHasCoordinatedCommits = CoordinatedCommitsUtils.getCoordinatorName((AbstractMetadata)updatedActions.getOldMetadata()).isPresent();
        boolean newMetadataHasCoordinatedCommits = CoordinatedCommitsUtils.getCoordinatorName((AbstractMetadata)updatedActions.getNewMetadata()).isPresent();
        return oldMetadataHasCoordinatedCommits && !newMetadataHasCoordinatedCommits && commitVersion > 0L;
    }

    public static /* synthetic */ String generateUUID$(AbstractBatchBackfillingCommitCoordinatorClient $this) {
        return $this.generateUUID();
    }

    default public String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public static /* synthetic */ void backfillToVersion$(AbstractBatchBackfillingCommitCoordinatorClient $this, LogStore logStore, Configuration hadoopConf, TableDescriptor tableDesc, long version, Long lastKnownBackfilledVersionOpt) {
        $this.backfillToVersion(logStore, hadoopConf, tableDesc, version, lastKnownBackfilledVersionOpt);
    }

    default public void backfillToVersion(LogStore logStore, Configuration hadoopConf, TableDescriptor tableDesc, long version2, Long lastKnownBackfilledVersionOpt) {
        Path logPath = tableDesc.getLogPath();
        Option validLastKnownBackfilledVersionOpt = Option$.MODULE$.apply((Object)lastKnownBackfilledVersionOpt).filter((Function1 & Serializable)version -> BoxesRunTime.boxToBoolean((boolean)AbstractBatchBackfillingCommitCoordinatorClient.$anonfun$backfillToVersion$1(logPath, hadoopConf, version)));
        long startVersionOpt = Predef$.MODULE$.Long2long((Long)validLastKnownBackfilledVersionOpt.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)AbstractBatchBackfillingCommitCoordinatorClient.$anonfun$backfillToVersion$2(x$1))).map((Function1 & Serializable)x -> AbstractBatchBackfillingCommitCoordinatorClient.$anonfun$backfillToVersion$3(BoxesRunTime.unboxToLong((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.getCommits(tableDesc, Predef$.MODULE$.long2Long(startVersionOpt), Predef$.MODULE$.long2Long(version2)).getCommits()).asScala()).foreach((Function1 & Serializable)commit -> {
            this.backfill(logStore, hadoopConf, logPath, commit.getVersion(), commit.getFileStatus());
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void backfill$(AbstractBatchBackfillingCommitCoordinatorClient $this, LogStore logStore, Configuration hadoopConf, Path logPath, long version, FileStatus fileStatus) {
        $this.backfill(logStore, hadoopConf, logPath, version, fileStatus);
    }

    default public void backfill(LogStore logStore, Configuration hadoopConf, Path logPath, long version, FileStatus fileStatus) {
        Path targetFile = FileNames$.MODULE$.unsafeDeltaFile(logPath, version);
        this.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Backfilling commit ", " to "}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATH(), fileStatus.getPath())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATH2(), targetFile.toString())})))));
        try (CloseableIterator commitContentIterator = logStore.read(fileStatus.getPath(), hadoopConf);){
            try {
                logStore.write(targetFile, (Iterator)commitContentIterator, Predef$.MODULE$.boolean2Boolean(false), hadoopConf);
                this.registerBackfill(logPath, version);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                this.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The backfilled file ", " already exists."}))).log((Seq<MDC>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.FILE_NAME(), targetFile)}))));
            }
        }
    }

    public void registerBackfill(Path var1, long var2);

    public static /* synthetic */ boolean $anonfun$backfillToVersion$1(Path logPath$1, Configuration hadoopConf$1, Long version) {
        FileSystem fs = logPath$1.getFileSystem(hadoopConf$1);
        return fs.exists(FileNames$.MODULE$.unsafeDeltaFile(logPath$1, Predef$.MODULE$.Long2long(version)));
    }

    public static /* synthetic */ long $anonfun$backfillToVersion$2(Long x$1) {
        return Predef$.MODULE$.Long2long(x$1) + 1L;
    }

    public static /* synthetic */ Long $anonfun$backfillToVersion$3(long x) {
        return BoxesRunTime.boxToLong((long)x);
    }

    public static void $init$(AbstractBatchBackfillingCommitCoordinatorClient $this) {
    }
}

