/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.perf;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.rdd.RDD;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.perf.DeltaOptimizedWriterExec$;
import org.apache.spark.sql.delta.perf.DeltaOptimizedWriterRDD;
import org.apache.spark.sql.delta.perf.OptimizedWriterBlocks;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.BinPackingUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.ShuffledRowRDD;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.UnaryExecNode;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.execution.metric.SQLShuffleReadMetricsReporter$;
import org.apache.spark.sql.execution.metric.SQLShuffleWriteMetricsReporter$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.util.ThreadUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tUf\u0001\u0002\u0016,\u0001bB\u0001B\u0017\u0001\u0003\u0016\u0004%\ta\u0017\u0005\t9\u0002\u0011\t\u0012)A\u0005s!AQ\f\u0001BK\u0002\u0013\u0005a\f\u0003\u0005k\u0001\tE\t\u0015!\u0003`\u0011!Y\u0007A!f\u0001\n\u0003a\u0007\u0002C9\u0001\u0005#\u0005\u000b\u0011B7\t\u000bY\u0004A\u0011A<\t\u000bu\u0004A\u0011\t@\t\u0015\u0005E\u0001\u0001#b\u0001\n\u0013\t\u0019\u0002\u0003\u0006\u0002(\u0001A)\u0019!C\u0005\u0003'A!\"!\u000b\u0001\u0011\u000b\u0007I\u0011IA\n\u0011)\tY\u0003\u0001EC\u0002\u0013%\u0011Q\u0006\u0005\u000b\u0003k\u0001\u0001R1A\u0005\n\u00055\u0002bCA\u001c\u0001\u0001\u0007\t\u0019!C\u0005\u0003sA1\"!\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002D!Y\u0011q\n\u0001A\u0002\u0003\u0005\u000b\u0015BA\u001e\u0011)\t\u0019\u0006\u0001EC\u0002\u0013%\u0011Q\u000b\u0005\b\u0003C\u0002A\u0011BA\u001d\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBq!a*\u0001\t\u0013\tI\u000bC\u0004\u00026\u0002!\t%a.\t\u000f\u00055\u0007\u0001\"\u0003\u0002P\"9\u0011Q \u0001\u0005R\u0005}\b\"\u0003B\u0003\u0001\u0005\u0005I\u0011\u0001B\u0004\u0011%\u0011y\u0001AI\u0001\n\u0003\u0011\t\u0002C\u0005\u0003(\u0001\t\n\u0011\"\u0001\u0003*!I!Q\u0006\u0001\u0012\u0002\u0013\u0005!q\u0006\u0005\n\u0005g\u0001\u0011\u0011!C!\u0005kA\u0011B!\u0012\u0001\u0003\u0003%\t!!\f\t\u0013\t\u001d\u0003!!A\u0005\u0002\t%\u0003\"\u0003B'\u0001\u0005\u0005I\u0011\tB(\u0011%\u00119\u0006AA\u0001\n\u0003\u0011I\u0006C\u0005\u0003d\u0001\t\t\u0011\"\u0011\u0003f!I!\u0011\u000e\u0001\u0002\u0002\u0013\u0005#1N\u0004\n\u0005_Z\u0013\u0011!E\u0001\u0005c2\u0001BK\u0016\u0002\u0002#\u0005!1\u000f\u0005\u0007m\u0012\"\tAa#\t\u0013\t5E%!A\u0005F\t=\u0005\"\u0003BII\u0005\u0005I\u0011\u0011BJ\u0011%\u0011Y\nJA\u0001\n\u0003\u0013i\nC\u0005\u0003,\u0012\n\t\u0011\"\u0003\u0003.\nAB)\u001a7uC>\u0003H/[7ju\u0016$wK]5uKJ,\u00050Z2\u000b\u00051j\u0013\u0001\u00029fe\u001aT!AL\u0018\u0002\u000b\u0011,G\u000e^1\u000b\u0005A\n\u0014aA:rY*\u0011!gM\u0001\u0006gB\f'o\u001b\u0006\u0003iU\na!\u00199bG\",'\"\u0001\u001c\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001ItH\u0011%O!\tQT(D\u0001<\u0015\tat&A\u0005fq\u0016\u001cW\u000f^5p]&\u0011ah\u000f\u0002\n'B\f'o\u001b)mC:\u0004\"A\u000f!\n\u0005\u0005[$!D+oCJLX\t_3d\u001d>$W\r\u0005\u0002D\r6\tAI\u0003\u0002F[\u0005AQ.\u001a;fe&tw-\u0003\u0002H\t\naA)\u001a7uC2{wmZ5oOB\u0011\u0011\nT\u0007\u0002\u0015*\t1*A\u0003tG\u0006d\u0017-\u0003\u0002N\u0015\n9\u0001K]8ek\u000e$\bCA(X\u001d\t\u0001VK\u0004\u0002R)6\t!K\u0003\u0002To\u00051AH]8pizJ\u0011aS\u0005\u0003-*\u000bq\u0001]1dW\u0006<W-\u0003\u0002Y3\na1+\u001a:jC2L'0\u00192mK*\u0011aKS\u0001\u0006G\"LG\u000eZ\u000b\u0002s\u000511\r[5mI\u0002\n\u0001\u0003]1si&$\u0018n\u001c8D_2,XN\\:\u0016\u0003}\u00032a\u00141c\u0013\t\t\u0017LA\u0002TKF\u0004\"aY4\u000f\u0005\u0011,\u0007CA)K\u0013\t1'*\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u00014K\u0003E\u0001\u0018M\u001d;ji&|gnQ8mk6t7\u000fI\u0001\tI\u0016dG/\u0019'pOV\tQ\u000e\u0005\u0002o_6\tQ&\u0003\u0002q[\tAA)\u001a7uC2{w-A\u0005eK2$\u0018\rT8hA!\u0012aa\u001d\t\u0003\u0013RL!!\u001e&\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018A\u0002\u001fj]&$h\b\u0006\u0003yund\bCA=\u0001\u001b\u0005Y\u0003\"\u0002.\b\u0001\u0004I\u0004\"B/\b\u0001\u0004y\u0006\"B6\b\u0001\u0004i\u0017AB8viB,H/F\u0001\u0000!\u0011y\u0005-!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\r\tYaL\u0001\tG\u0006$\u0018\r\\=ti&!\u0011qBA\u0003\u0005%\tE\u000f\u001e:jEV$X-\u0001\u0007xe&$X-T3ue&\u001c7/\u0006\u0002\u0002\u0016A11-a\u0006c\u00037I1!!\u0007j\u0005\ri\u0015\r\u001d\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011E\u001e\u0002\r5,GO]5d\u0013\u0011\t)#a\b\u0003\u0013M\u000bF*T3ue&\u001c\u0017a\u0003:fC\u0012lU\r\u001e:jGN\fq!\\3ue&\u001c7/\u0001\ndQ&dGMT;n!\u0006\u0014H/\u001b;j_:\u001cXCAA\u0018!\rI\u0015\u0011G\u0005\u0004\u0003gQ%aA%oi\u0006ia.^7QCJ$\u0018\u000e^5p]N\f\u0001cY1dQ\u0016$7\u000b[;gM2,'\u000b\u0012#\u0016\u0005\u0005m\u0002c\u0001\u001e\u0002>%\u0019\u0011qH\u001e\u0003\u001dMCWO\u001a4mK\u0012\u0014vn\u001e*E\t\u0006!2-Y2iK\u0012\u001c\u0006.\u001e4gY\u0016\u0014F\tR0%KF$B!!\u0012\u0002LA\u0019\u0011*a\u0012\n\u0007\u0005%#J\u0001\u0003V]&$\b\"CA'\u001f\u0005\u0005\t\u0019AA\u001e\u0003\rAH%M\u0001\u0012G\u0006\u001c\u0007.\u001a3TQV4g\r\\3S\t\u0012\u0003\u0003F\u0001\tt\u0003)i\u0017\r\u001d+sC\u000e\\WM]\u000b\u0003\u0003/\u0002B!!\u0017\u0002\\5\t\u0011'C\u0002\u0002^E\u0012\u0001#T1q\u001fV$\b/\u001e;Ue\u0006\u001c7.\u001a:)\u0005E\u0019\u0018!D4fiNCWO\u001a4mKJ#E)A\u0006d_6\u0004X\u000f^3CS:\u001cHCAA4!\u0015I\u0015\u0011NA7\u0013\r\tYG\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0006\u001f\u0006=\u00141O\u0005\u0004\u0003cJ&\u0001\u0002'jgR\u0004r!SA;\u0003s\n))C\u0002\u0002x)\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BA>\u0003\u0003k!!! \u000b\u0007\u0005}\u0014'A\u0004ti>\u0014\u0018mZ3\n\t\u0005\r\u0015Q\u0010\u0002\u000f\u00052|7m['b]\u0006<WM]%e!\u0019\t9)!%\u0002\u00166\u0011\u0011\u0011\u0012\u0006\u0005\u0003\u0017\u000bi)A\u0004nkR\f'\r\\3\u000b\u0007\u0005=%*\u0001\u0006d_2dWm\u0019;j_:LA!a%\u0002\n\nY\u0011I\u001d:bs\n+hMZ3s!%I\u0015qSAN\u0003C\u000by#C\u0002\u0002\u001a*\u0013a\u0001V;qY\u0016\u001c\u0004\u0003BA>\u0003;KA!a(\u0002~\t9!\t\\8dW&#\u0007cA%\u0002$&\u0019\u0011Q\u0015&\u0003\t1{gnZ\u0001\u0010O\u0016$8\u000b[;gM2,7\u000b^1ugR\u0011\u00111\u0016\t\u0006\u0013\u0006%\u0014Q\u0016\t\b\u0013\u0006U\u0014\u0011PAX!\u0019\t\t,a-\u0002\u00166\u0011\u0011QR\u0005\u0004C\u00065\u0015!\u00033p\u000bb,7-\u001e;f)\t\tI\f\u0005\u0004\u0002<\u0006\u0005\u0017QY\u0007\u0003\u0003{S1!a02\u0003\r\u0011H\rZ\u0005\u0005\u0003\u0007\fiLA\u0002S\t\u0012\u0003B!a2\u0002J6\u0011\u0011\u0011B\u0005\u0005\u0003\u0017\fIAA\u0006J]R,'O\\1m%><\u0018aB4fi\u000e{gNZ\u000b\u0005\u0003#\f9\u000e\u0006\u0003\u0002T\u0006%\b\u0003BAk\u0003/d\u0001\u0001B\u0004\u0002ZZ\u0011\r!a7\u0003\u0003Q\u000bB!!8\u0002dB\u0019\u0011*a8\n\u0007\u0005\u0005(JA\u0004O_RD\u0017N\\4\u0011\u0007%\u000b)/C\u0002\u0002h*\u00131!\u00118z\u0011\u001d\tYO\u0006a\u0001\u0003[\fQ!\u001a8uef\u0004b!a<\u0002z\u0006MWBAAy\u0015\u0011\t\u00190!>\u0002\r\r|gNZ5h\u0015\r\t90M\u0001\tS:$XM\u001d8bY&!\u00111`Ay\u0005-\u0019uN\u001c4jO\u0016sGO]=\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\rA(\u0011\u0001\u0005\u0007\u0005\u00079\u0002\u0019A\u001d\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR9\u0001P!\u0003\u0003\f\t5\u0001b\u0002.\u0019!\u0003\u0005\r!\u000f\u0005\b;b\u0001\n\u00111\u0001`\u0011\u001dY\u0007\u0004%AA\u00025\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0014)\u001a\u0011H!\u0006,\u0005\t]\u0001\u0003\u0002B\r\u0005Gi!Aa\u0007\u000b\t\tu!qD\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\tK\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005K\u0011YBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003,)\u001aqL!\u0006\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0007\u0016\u0004[\nU\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00038A!!\u0011\bB\"\u001b\t\u0011YD\u0003\u0003\u0003>\t}\u0012\u0001\u00027b]\u001eT!A!\u0011\u0002\t)\fg/Y\u0005\u0004Q\nm\u0012\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003G\u0014Y\u0005C\u0005\u0002Ny\t\t\u00111\u0001\u00020\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003RA1\u0011\u0011\u0017B*\u0003GLAA!\u0016\u0002\u000e\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011YF!\u0019\u0011\u0007%\u0013i&C\u0002\u0003`)\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002N\u0001\n\t\u00111\u0001\u0002d\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u00119Da\u001a\t\u0013\u00055\u0013%!AA\u0002\u0005=\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003\\\t5\u0004\"CA'E\u0005\u0005\t\u0019AAr\u0003a!U\r\u001c;b\u001fB$\u0018.\\5{K\u0012<&/\u001b;fe\u0016CXm\u0019\t\u0003s\u0012\u001aR\u0001\nB;\u0005\u0003\u0003\u0002Ba\u001e\u0003~ezV\u000e_\u0007\u0003\u0005sR1Aa\u001fK\u0003\u001d\u0011XO\u001c;j[\u0016LAAa \u0003z\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\t\r%\u0011R\u0007\u0003\u0005\u000bSAAa\"\u0003@\u0005\u0011\u0011n\\\u0005\u00041\n\u0015EC\u0001B9\u0003!!xn\u0015;sS:<GC\u0001B\u001c\u0003\u0015\t\u0007\u000f\u001d7z)\u001dA(Q\u0013BL\u00053CQAW\u0014A\u0002eBQ!X\u0014A\u0002}CQa[\u0014A\u00025\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003 \n\u001d\u0006#B%\u0003\"\n\u0015\u0016b\u0001BR\u0015\n1q\n\u001d;j_:\u0004b!SALs}k\u0007\u0002\u0003BUQ\u0005\u0005\t\u0019\u0001=\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u00030B!!\u0011\bBY\u0013\u0011\u0011\u0019La\u000f\u0003\r=\u0013'.Z2u\u0001")
public class DeltaOptimizedWriterExec
extends SparkPlan
implements UnaryExecNode,
DeltaLogging {
    private Map<String, SQLMetric> writeMetrics;
    private Map<String, SQLMetric> readMetrics;
    private Map<String, SQLMetric> metrics;
    private int childNumPartitions;
    private int numPartitions;
    private transient MapOutputTracker mapTracker;
    private final SparkPlan child;
    private final scala.collection.immutable.Seq<String> partitionColumns;
    private final transient DeltaLog deltaLog;
    private transient ShuffledRowRDD cachedShuffleRDD;
    private transient scala.collection.immutable.Seq<SparkPlan> children;
    private volatile byte bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple3<SparkPlan, scala.collection.immutable.Seq<String>, DeltaLog>> unapply(DeltaOptimizedWriterExec x$0) {
        return DeltaOptimizedWriterExec$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<SparkPlan, scala.collection.immutable.Seq<String>, DeltaLog>, DeltaOptimizedWriterExec> tupled() {
        return DeltaOptimizedWriterExec$.MODULE$.tupled();
    }

    public static Function1<SparkPlan, Function1<scala.collection.immutable.Seq<String>, Function1<DeltaLog, DeltaOptimizedWriterExec>>> curried() {
        return DeltaOptimizedWriterExec$.MODULE$.curried();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    @Override
    public LoggingShims.LogStringContext LogStringContext(StringContext sc) {
        return LoggingShims.LogStringContext$(this, sc);
    }

    @Override
    public void logInfo(LogEntry entry) {
        LoggingShims.logInfo$(this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        LoggingShims.logInfo$(this, entry, throwable);
    }

    @Override
    public void logDebug(LogEntry entry) {
        LoggingShims.logDebug$(this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        LoggingShims.logDebug$(this, entry, throwable);
    }

    @Override
    public void logTrace(LogEntry entry) {
        LoggingShims.logTrace$(this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        LoggingShims.logTrace$(this, entry, throwable);
    }

    @Override
    public void logWarning(LogEntry entry) {
        LoggingShims.logWarning$(this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        LoggingShims.logWarning$(this, entry, throwable);
    }

    @Override
    public void logError(LogEntry entry) {
        LoggingShims.logError$(this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        LoggingShims.logError$(this, entry, throwable);
    }

    public String verboseStringWithOperatorId() {
        return UnaryExecNode.verboseStringWithOperatorId$((UnaryExecNode)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$((UnaryLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$((UnaryLike)this, (IndexedSeq)newChildren);
    }

    private scala.collection.immutable.Seq<SparkPlan> children$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.children = UnaryLike.children$((UnaryLike)this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.children;
    }

    public final scala.collection.immutable.Seq<SparkPlan> children() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public SparkPlan child() {
        return this.child;
    }

    public scala.collection.immutable.Seq<String> partitionColumns() {
        return this.partitionColumns;
    }

    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public scala.collection.immutable.Seq<Attribute> output() {
        return this.child().output();
    }

    private Map<String, SQLMetric> writeMetrics$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.writeMetrics = SQLShuffleWriteMetricsReporter$.MODULE$.createShuffleWriteMetrics(this.sparkContext());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.writeMetrics;
    }

    private Map<String, SQLMetric> writeMetrics() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.writeMetrics$lzycompute();
        }
        return this.writeMetrics;
    }

    private Map<String, SQLMetric> readMetrics$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.readMetrics = SQLShuffleReadMetricsReporter$.MODULE$.createShuffleReadMetrics(this.sparkContext());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.readMetrics;
    }

    private Map<String, SQLMetric> readMetrics() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.readMetrics$lzycompute();
        }
        return this.readMetrics;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.metrics = (Map)((MapOps)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataSize"), (Object)SQLMetrics$.MODULE$.createSizeMetric(this.sparkContext(), "data size", SQLMetrics$.MODULE$.createSizeMetric$default$3()))}))).$plus$plus(this.readMetrics())).$plus$plus(this.writeMetrics());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    private int childNumPartitions$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.childNumPartitions = this.child().execute().getNumPartitions();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.childNumPartitions;
    }

    private int childNumPartitions() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.childNumPartitions$lzycompute();
        }
        return this.childNumPartitions;
    }

    private int numPartitions$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                int targetShuffleBlocks = BoxesRunTime.unboxToInt((Object)this.getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_WRITE_SHUFFLE_BLOCKS()));
                this.numPartitions = scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.max(targetShuffleBlocks / this.childNumPartitions(), 1), BoxesRunTime.unboxToInt((Object)this.getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_WRITE_MAX_SHUFFLE_PARTITIONS())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.numPartitions;
    }

    private int numPartitions() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.numPartitions$lzycompute();
        }
        return this.numPartitions;
    }

    private ShuffledRowRDD cachedShuffleRDD() {
        return this.cachedShuffleRDD;
    }

    private void cachedShuffleRDD_$eq(ShuffledRowRDD x$1) {
        this.cachedShuffleRDD = x$1;
    }

    private MapOutputTracker mapTracker$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapTracker = SparkEnv$.MODULE$.get().mapOutputTracker();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapTracker;
    }

    private MapOutputTracker mapTracker() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.mapTracker$lzycompute();
        }
        return this.mapTracker;
    }

    private ShuffledRowRDD getShuffleRDD() {
        block0: {
            if (this.cachedShuffleRDD() != null) break block0;
            Function2 resolver = package$.MODULE$.caseInsensitiveResolution();
            HashPartitioning saltedPartitioning = new HashPartitioning((scala.collection.immutable.Seq)this.partitionColumns().map((Function1 & Serializable)p -> (Attribute)this.output().find((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)DeltaOptimizedWriterExec.$anonfun$getShuffleRDD$2(resolver, p, o))).getOrElse((Function0 & Serializable)() -> {
                throw DeltaErrors$.MODULE$.failedFindPartitionColumnInOutputPlan((String)p);
            })), this.numPartitions());
            ShuffledRowRDD shuffledRDD = (ShuffledRowRDD)new ShuffleExchangeExec((Partitioning)saltedPartitioning, this.child(), ShuffleExchangeExec$.MODULE$.apply$default$3(), ShuffleExchangeExec$.MODULE$.apply$default$4()).execute();
            this.cachedShuffleRDD_$eq(shuffledRDD);
        }
        return this.cachedShuffleRDD();
    }

    private List<Tuple2<BlockManagerId, ArrayBuffer<Tuple3<BlockId, Object, Object>>>>[] computeBins() {
        Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>[] shuffleStats = this.getShuffleStats();
        Map blockInfo = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])shuffleStats), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BlockManagerId bmId = (BlockManagerId)tuple2._1();
                Seq blocks = (Seq)tuple2._2();
                return (Seq)blocks.map((Function1 & Serializable)x0$2 -> {
                    Tuple3 tuple3 = x0$2;
                    if (tuple3 != null) {
                        BlockId blockId = (BlockId)tuple3._1();
                        long size = BoxesRunTime.unboxToLong((Object)tuple3._2());
                        int index = BoxesRunTime.unboxToInt((Object)tuple3._3());
                        return new Tuple2((Object)blockId, (Object)new Tuple3((Object)bmId, (Object)BoxesRunTime.boxToLong((long)size), (Object)BoxesRunTime.boxToInteger((int)index)));
                    }
                    throw new MatchError((Object)tuple3);
                });
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        long maxBinSize = ByteUnit.BYTE.convertFrom(BoxesRunTime.unboxToLong((Object)this.getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_WRITE_BIN_SIZE())), ByteUnit.MiB);
        Iterable bins = (Iterable)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])shuffleStats)).flatMap((Function1 & Serializable)x$2 -> (Seq)x$2._2())).groupBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)DeltaOptimizedWriterExec.$anonfun$computeBins$4(x$3))).flatMap((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                scala.collection.immutable.Seq blocks = (scala.collection.immutable.Seq)tuple2._2();
                return BinPackingUtils$.MODULE$.binPackBySize(blocks, (Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)DeltaOptimizedWriterExec.$anonfun$computeBins$6(x$4)), (Function1 & Serializable)x$5 -> (BlockId)x$5._1(), maxBinSize);
            }
            throw new MatchError((Object)tuple2);
        });
        return (List[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)bins.map((Function1 & Serializable)bin -> {
            LongRef binSize = LongRef.create((long)0L);
            HashMap blockLocations = new HashMap();
            bin.foreach((Function1 & Serializable)blockId -> {
                Tuple3 tuple3 = (Tuple3)blockInfo.apply(blockId);
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                BlockManagerId bmId = (BlockManagerId)tuple3._1();
                long size = BoxesRunTime.unboxToLong((Object)tuple3._2());
                int index = BoxesRunTime.unboxToInt((Object)tuple3._3());
                Tuple3 tuple32 = new Tuple3((Object)bmId, (Object)BoxesRunTime.boxToLong((long)size), (Object)BoxesRunTime.boxToInteger((int)index));
                BlockManagerId bmId2 = (BlockManagerId)tuple32._1();
                long size2 = BoxesRunTime.unboxToLong((Object)tuple32._2());
                int index2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
                binSize$1.elem += size2;
                ArrayBuffer blocksAtBM = (ArrayBuffer)blockLocations.getOrElseUpdate((Object)bmId2, (Function0 & Serializable)() -> new ArrayBuffer());
                return (ArrayBuffer)blocksAtBM.append((Object)new Tuple3(blockId, (Object)BoxesRunTime.boxToLong((long)size2), (Object)BoxesRunTime.boxToInteger((int)index2)));
            });
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)binSize.elem), (Object)blockLocations.toList());
        })).toArray(ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7._1$mcJ$sp()), scala.package$.MODULE$.Ordering().apply((Ordering)Ordering.Long$.MODULE$).reverse())), (Function1 & Serializable)x$8 -> (List)x$8._2(), ClassTag$.MODULE$.apply(List.class));
    }

    private Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>[] getShuffleStats() {
        Tuple2[] tuple2Array;
        ShuffleDependency dep = this.getShuffleRDD().dependency();
        try {
            Tuple2[] res = this.getStats$1(dep);
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])res))) {
                this.awaitShuffleMapStage$1(dep);
            }
            tuple2Array = this.getStats$1(dep);
        }
        catch (FetchFailedException e) {
            this.logWarning(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to fetch shuffle blocks for the optimized writer. Retrying"}))).log((scala.collection.immutable.Seq<MDC>)Nil$.MODULE$)), e);
            this.awaitShuffleMapStage$1(dep);
            tuple2Array = this.getStats$1(dep);
        }
        return tuple2Array;
    }

    public RDD<InternalRow> doExecute() {
        if (this.childNumPartitions() <= 1) {
            return this.child().execute();
        }
        ShuffledRowRDD shuffledRDD = this.getShuffleRDD();
        List<Tuple2<BlockManagerId, ArrayBuffer<Tuple3<BlockId, Object, Object>>>>[] partitions = this.computeBins();
        DeltaLog x$1 = this.deltaLog();
        String x$2 = "delta.optimizeWrite.planned";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"originalPartitions"), (Object)BoxesRunTime.boxToInteger((int)this.childNumPartitions())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputPartitions"), (Object)BoxesRunTime.boxToInteger((int)partitions.length)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shufflePartitions"), (Object)BoxesRunTime.boxToInteger((int)this.numPartitions())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numShuffleBlocks"), this.getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_WRITE_SHUFFLE_BLOCKS())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"binSize"), this.getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_WRITE_BIN_SIZE())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxShufflePartitions"), this.getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_WRITE_MAX_SHUFFLE_PARTITIONS()))}));
        Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
        Option<Path> x$5 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$1, "delta.optimizeWrite.planned", x$4, x$3, x$5);
        return new DeltaOptimizedWriterRDD(this.sparkContext(), shuffledRDD.dependency(), this.readMetrics(), new OptimizedWriterBlocks(partitions));
    }

    private <T> T getConf(ConfigEntry<T> entry) {
        return (T)this.conf().getConf(entry);
    }

    public DeltaOptimizedWriterExec withNewChildInternal(SparkPlan newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public DeltaOptimizedWriterExec copy(SparkPlan child, scala.collection.immutable.Seq<String> partitionColumns, DeltaLog deltaLog) {
        return new DeltaOptimizedWriterExec(child, partitionColumns, deltaLog);
    }

    public SparkPlan copy$default$1() {
        return this.child();
    }

    public scala.collection.immutable.Seq<String> copy$default$2() {
        return this.partitionColumns();
    }

    public DeltaLog copy$default$3() {
        return this.deltaLog();
    }

    public String productPrefix() {
        return "DeltaOptimizedWriterExec";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.partitionColumns();
            }
            case 2: {
                return this.deltaLog();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DeltaOptimizedWriterExec;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "partitionColumns";
            }
            case 2: {
                return "deltaLog";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DeltaOptimizedWriterExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = (DeltaOptimizedWriterExec)x$1;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = deltaOptimizedWriterExec.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!sparkPlan.equals(sparkPlan2)) return false;
        scala.collection.immutable.Seq<String> seq = this.partitionColumns();
        scala.collection.immutable.Seq<String> seq2 = deltaOptimizedWriterExec.partitionColumns();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        DeltaLog deltaLog = this.deltaLog();
        DeltaLog deltaLog2 = deltaOptimizedWriterExec.deltaLog();
        if (deltaLog == null) {
            if (deltaLog2 != null) {
                return false;
            }
        } else if (!deltaLog.equals(deltaLog2)) return false;
        if (!deltaOptimizedWriterExec.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getShuffleRDD$2(Function2 resolver$1, String p$1, Attribute o) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)p$1, (Object)o.name()));
    }

    public static final /* synthetic */ int $anonfun$computeBins$4(Tuple3 x$3) {
        return ((ShuffleBlockId)x$3._1()).reduceId();
    }

    public static final /* synthetic */ long $anonfun$computeBins$6(Tuple3 x$4) {
        return BoxesRunTime.unboxToLong((Object)x$4._2());
    }

    private final Tuple2[] getStats$1(ShuffleDependency dep$1) {
        return (Tuple2[])this.mapTracker().getMapSizesByExecutorId(dep$1.shuffleId(), 0, Integer.MAX_VALUE, 0, this.numPartitions()).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private final void awaitShuffleMapStage$1(ShuffleDependency dep$1) {
        Predef$.MODULE$.assert(dep$1 != null, (Function0 & Serializable)() -> "Shuffle dependency should not be null");
        ThreadUtils$.MODULE$.awaitResult((Awaitable)this.sparkContext().submitMapStage(dep$1), (Duration)Duration$.MODULE$.Inf());
    }

    public DeltaOptimizedWriterExec(SparkPlan child, scala.collection.immutable.Seq<String> partitionColumns, DeltaLog deltaLog) {
        this.child = child;
        this.partitionColumns = partitionColumns;
        this.deltaLog = deltaLog;
        UnaryLike.$init$((UnaryLike)this);
        UnaryExecNode.$init$((UnaryExecNode)this);
        LoggingShims.$init$(this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }
}

