/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.skipping;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.delta.skipping.MultiDimClustering;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005}3q\u0001B\u0003\u0011\u0002\u0007\u0005!\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0003#\u0001\u0019E1\u0005C\u0003<\u0001\u0011\u0005CHA\u000eTa\u0006\u001cWMR5mY&twmQ;sm\u0016\u001cE.^:uKJLgn\u001a\u0006\u0003\r\u001d\t\u0001b]6jaBLgn\u001a\u0006\u0003\u0011%\tQ\u0001Z3mi\u0006T!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u00192\u0001A\n\u001a!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fMB\u0011!dG\u0007\u0002\u000b%\u0011A$\u0002\u0002\u0013\u001bVdG/\u001b#j[\u000ecWo\u001d;fe&tw-\u0001\u0004%S:LG\u000f\n\u000b\u0002?A\u0011A\u0003I\u0005\u0003CU\u0011A!\u00168ji\u00069r-\u001a;DYV\u001cH/\u001a:j]\u001e,\u0005\u0010\u001d:fgNLwN\u001c\u000b\u0004I!2\u0004CA\u0013'\u001b\u0005I\u0011BA\u0014\n\u0005\u0019\u0019u\u000e\\;n]\")\u0011F\u0001a\u0001U\u0005!1m\u001c7t!\rY3\u0007\n\b\u0003YEr!!\f\u0019\u000e\u00039R!aL\t\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012B\u0001\u001a\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001N\u001b\u0003\u0007M+\u0017O\u0003\u00023+!)qG\u0001a\u0001q\u0005Ia.^7SC:<Wm\u001d\t\u0003)eJ!AO\u000b\u0003\u0007%sG/A\u0004dYV\u001cH/\u001a:\u0015\u000buZU\n\u0017.\u0011\u0005yBeBA H\u001d\t\u0001eI\u0004\u0002B\u000b:\u0011!\t\u0012\b\u0003[\rK\u0011\u0001E\u0005\u0003\u001d=I!\u0001D\u0007\n\u0005)Y\u0011B\u0001\u001a\n\u0013\tI%JA\u0005ECR\fgI]1nK*\u0011!'\u0003\u0005\u0006\u0019\u000e\u0001\r!P\u0001\u0003I\u001aDQAT\u0002A\u0002=\u000b\u0001bY8m\u001d\u0006lWm\u001d\t\u0004WM\u0002\u0006CA)V\u001d\t\u00116\u000b\u0005\u0002.+%\u0011A+F\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U+!)\u0011l\u0001a\u0001q\u0005\u0019\u0012\r\u001d9s_btU/\u001c)beRLG/[8og\")1l\u0001a\u00019\u0006Q\"/\u00198e_6L'0\u0019;j_:,\u0005\u0010\u001d:fgNLwN\\(qiB\u0019A#\u0018\u0013\n\u0005y+\"AB(qi&|g\u000e")
public interface SpaceFillingCurveClustering
extends MultiDimClustering {
    public Column getClusteringExpression(Seq<Column> var1, int var2);

    public static /* synthetic */ Dataset cluster$(SpaceFillingCurveClustering $this, Dataset df, Seq colNames, int approxNumPartitions, Option randomizationExpressionOpt) {
        return $this.cluster((Dataset<Row>)df, (Seq<String>)colNames, approxNumPartitions, (Option<Column>)randomizationExpressionOpt);
    }

    @Override
    default public Dataset<Row> cluster(Dataset<Row> df, Seq<String> colNames, int approxNumPartitions, Option<Column> randomizationExpressionOpt) {
        Dataset dataset;
        SQLConf conf = df.sparkSession().sessionState().conf();
        int numRanges = BoxesRunTime.unboxToInt((Object)conf.getConf(DeltaSQLConf$.MODULE$.MDC_NUM_RANGE_IDS()));
        boolean addNoise = BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.MDC_ADD_NOISE()));
        Seq cols = (Seq)colNames.map((Function1 & Serializable)x$1 -> df.apply(x$1));
        Column mdcCol = this.getClusteringExpression((Seq<Column>)cols, numRanges);
        String repartitionKeyColName = new StringBuilder(7).append(UUID.randomUUID().toString()).append("-rpKey1").toString();
        if (addNoise) {
            String randByteColName = new StringBuilder(7).append(UUID.randomUUID().toString()).append("-rpKey2").toString();
            Column randByteCol = (Column)randomizationExpressionOpt.getOrElse((Function0 & Serializable)() -> functions$.MODULE$.rand().$times((Object)BoxesRunTime.boxToInteger((int)255)).$minus((Object)BoxesRunTime.boxToInteger((int)128)).cast((DataType)ByteType$.MODULE$));
            dataset = df.withColumn(repartitionKeyColName, mdcCol).withColumn(randByteColName, randByteCol).repartitionByRange(approxNumPartitions, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(repartitionKeyColName), functions$.MODULE$.col(randByteColName)})).drop(randByteColName);
        } else {
            dataset = df.withColumn(repartitionKeyColName, mdcCol).repartitionByRange(approxNumPartitions, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(repartitionKeyColName)}));
        }
        Dataset repartitionedDf = dataset;
        return repartitionedDf.drop(repartitionKeyColName);
    }

    public static void $init$(SpaceFillingCurveClustering $this) {
    }
}

