/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.spark.sql.delta.util.FractionTimestampFormatter;
import org.apache.spark.sql.delta.util.Iso8601TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import scala.runtime.ModuleSerializationProxy;

public final class TimestampFormatter$
implements Serializable {
    public static final TimestampFormatter$ MODULE$ = new TimestampFormatter$();
    private static final String defaultPattern = "yyyy-MM-dd HH:mm:ss";
    private static final Locale defaultLocale = Locale.US;

    public String defaultPattern() {
        return defaultPattern;
    }

    public Locale defaultLocale() {
        return defaultLocale;
    }

    public TimestampFormatter apply(String format, ZoneId zoneId) {
        return new Iso8601TimestampFormatter(format, zoneId, this.defaultLocale());
    }

    public TimestampFormatter apply(String format, TimeZone timeZone, Locale locale) {
        return new Iso8601TimestampFormatter(format, timeZone.toZoneId(), locale);
    }

    public TimestampFormatter apply(String format, TimeZone timeZone) {
        return this.apply(format, timeZone, this.defaultLocale());
    }

    public TimestampFormatter apply(TimeZone timeZone) {
        return this.apply(this.defaultPattern(), timeZone, this.defaultLocale());
    }

    public TimestampFormatter getFractionFormatter(TimeZone timeZone) {
        return new FractionTimestampFormatter(timeZone);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TimestampFormatter$.class);
    }

    private TimestampFormatter$() {
    }
}

