/*
 * Decompiled with CFR 0.152.
 */
package io.druid.emitter.statsd;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.druid.emitter.statsd.StatsDMetric;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class DimensionConverter {
    private static final Logger log = new Logger(DimensionConverter.class);
    private Map<String, StatsDMetric> metricMap;

    public DimensionConverter(ObjectMapper mapper, String dimensionMapPath) {
        this.metricMap = this.readMap(mapper, dimensionMapPath);
    }

    public StatsDMetric addFilteredUserDims(String service, String metric, Map<String, Object> userDims, ImmutableList.Builder<String> builder) {
        StatsDMetric statsDMetric = null;
        if (this.metricMap.containsKey(metric)) {
            statsDMetric = this.metricMap.get(metric);
        } else if (this.metricMap.containsKey(service + "-" + metric)) {
            statsDMetric = this.metricMap.get(service + "-" + metric);
        }
        if (statsDMetric != null) {
            for (String dim : statsDMetric.dimensions) {
                if (!userDims.containsKey(dim)) continue;
                builder.add((Object)userDims.get(dim).toString());
            }
            return statsDMetric;
        }
        return null;
    }

    private Map<String, StatsDMetric> readMap(ObjectMapper mapper, String dimensionMapPath) {
        try {
            InputStream is;
            if (Strings.isNullOrEmpty((String)dimensionMapPath)) {
                log.info("Using default metric dimension and types", new Object[0]);
                is = this.getClass().getClassLoader().getResourceAsStream("defaultMetricDimensions.json");
            } else {
                log.info("Using metric dimensions at types at [%s]", new Object[]{dimensionMapPath});
                is = new FileInputStream(new File(dimensionMapPath));
            }
            return (Map)mapper.reader((TypeReference)new TypeReference<Map<String, StatsDMetric>>(){}).readValue(is);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Failed to parse metric dimensions and types", new Object[0]);
        }
    }
}

