/*
 * Decompiled with CFR 0.152.
 */
package io.druid.emitter.statsd;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.metamx.emitter.core.Emitter;
import com.metamx.emitter.core.Event;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import io.druid.emitter.statsd.DimensionConverter;
import io.druid.emitter.statsd.StatsDEmitterConfig;
import io.druid.emitter.statsd.StatsDMetric;
import io.druid.java.util.common.logger.Logger;
import java.io.IOException;
import java.util.Map;

public class StatsDEmitter
implements Emitter {
    private static final Logger log = new Logger(StatsDEmitter.class);
    private static final String DRUID_METRIC_SEPARATOR = "\\/";
    private static final String STATSD_SEPARATOR = ":|\\|";
    private final StatsDClient statsd;
    private final StatsDEmitterConfig config;
    private final DimensionConverter converter;

    public StatsDEmitter(StatsDEmitterConfig config, ObjectMapper mapper) {
        this(config, mapper, (StatsDClient)new NonBlockingStatsDClient(config.getPrefix(), config.getHostname(), config.getPort(), new StatsDClientErrorHandler(){
            private int exceptionCount = 0;

            public void handle(Exception exception) {
                if (this.exceptionCount % 1000 == 0) {
                    log.error((Throwable)exception, "Error sending metric to StatsD.", new Object[0]);
                }
                ++this.exceptionCount;
            }
        }));
    }

    public StatsDEmitter(StatsDEmitterConfig config, ObjectMapper mapper, StatsDClient client) {
        this.config = config;
        this.converter = new DimensionConverter(mapper, config.getDimensionMapPath());
        this.statsd = client;
    }

    public void start() {
    }

    public void emit(Event event) {
        if (event instanceof ServiceMetricEvent) {
            ServiceMetricEvent metricEvent = (ServiceMetricEvent)event;
            String host = metricEvent.getHost();
            String service = metricEvent.getService();
            String metric = metricEvent.getMetric();
            Map userDims = metricEvent.getUserDims();
            Number value = metricEvent.getValue();
            ImmutableList.Builder nameBuilder = new ImmutableList.Builder();
            if (this.config.getIncludeHost().booleanValue()) {
                nameBuilder.add((Object)host);
            }
            nameBuilder.add((Object)service);
            nameBuilder.add((Object)metric);
            StatsDMetric statsDMetric = this.converter.addFilteredUserDims(service, metric, userDims, (ImmutableList.Builder<String>)nameBuilder);
            if (statsDMetric != null) {
                String fullName = Joiner.on((String)this.config.getSeparator()).join((Iterable)nameBuilder.build()).replaceAll(DRUID_METRIC_SEPARATOR, this.config.getSeparator()).replaceAll(STATSD_SEPARATOR, this.config.getSeparator());
                long val = statsDMetric.convertRange ? Math.round(value.doubleValue() * 100.0) : value.longValue();
                switch (statsDMetric.type) {
                    case count: {
                        this.statsd.count(fullName, val);
                        break;
                    }
                    case timer: {
                        this.statsd.time(fullName, val);
                        break;
                    }
                    case gauge: {
                        this.statsd.gauge(fullName, val);
                    }
                }
            } else {
                log.debug("Metric=[%s] has no StatsD type mapping", new Object[]{statsDMetric});
            }
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.statsd.stop();
    }
}

