/*
 * Decompiled with CFR 0.152.
 */
package io.druid.emitter.statsd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

public class StatsDEmitterConfig {
    @JsonProperty
    private final String hostname;
    @JsonProperty
    private final Integer port;
    @JsonProperty
    private final String prefix;
    @JsonProperty
    private final String separator;
    @JsonProperty
    private final Boolean includeHost;
    @JsonProperty
    private final String dimensionMapPath;

    @JsonCreator
    public StatsDEmitterConfig(@JsonProperty(value="hostname") String hostname, @JsonProperty(value="port") Integer port, @JsonProperty(value="prefix") String prefix, @JsonProperty(value="separator") String separator, @JsonProperty(value="includeHost") Boolean includeHost, @JsonProperty(value="dimensionMapPath") String dimensionMapPath) {
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"StatsD hostname cannot be null.");
        this.port = (Integer)Preconditions.checkNotNull((Object)port, (Object)"StatsD port cannot be null.");
        this.prefix = prefix != null ? prefix : "";
        this.separator = separator != null ? separator : ".";
        this.includeHost = includeHost != null ? includeHost : false;
        this.dimensionMapPath = dimensionMapPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatsDEmitterConfig that = (StatsDEmitterConfig)o;
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) {
            return false;
        }
        if (this.separator != null ? !this.separator.equals(that.separator) : that.separator != null) {
            return false;
        }
        if (this.includeHost != null ? !this.includeHost.equals(that.includeHost) : that.includeHost != null) {
            return false;
        }
        return this.dimensionMapPath != null ? this.dimensionMapPath.equals(that.dimensionMapPath) : that.dimensionMapPath == null;
    }

    public int hashCode() {
        int result = this.hostname != null ? this.hostname.hashCode() : 0;
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
        result = 31 * result + (this.separator != null ? this.separator.hashCode() : 0);
        result = 31 * result + (this.includeHost != null ? this.includeHost.hashCode() : 0);
        result = 31 * result + (this.dimensionMapPath != null ? this.dimensionMapPath.hashCode() : 0);
        return result;
    }

    @JsonProperty
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public String getPrefix() {
        return this.prefix;
    }

    @JsonProperty
    public String getSeparator() {
        return this.separator;
    }

    @JsonProperty
    public Boolean getIncludeHost() {
        return this.includeHost;
    }

    @JsonProperty
    public String getDimensionMapPath() {
        return this.dimensionMapPath;
    }
}

