/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5.extension;

import com.google.inject.Key;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.injectors.EnvironmentDependencyInjector;
import net.serenitybdd.junit5.counter.TestCounter;
import net.serenitybdd.junit5.guice.JUnitInjectors;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.Listeners;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepListener;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SerenityExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback {
    public void beforeAll(ExtensionContext extensionContext) {
        StepEventBus.getEventBus().clear();
        this.registerListenersOnEventBus(new StepListener[]{this.createBaseStepListener(), Listeners.getLoggingListener(), this.testCountListener()});
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.injectEnvironmentVariablesInto(extensionContext.getRequiredTestInstance());
    }

    public void afterAll(ExtensionContext extensionContext) {
        StepEventBus.getEventBus().dropAllListeners();
    }

    private BaseStepListener createBaseStepListener() {
        return Listeners.getBaseStepListener().withOutputDirectory(ConfiguredEnvironment.getConfiguration().getOutputDirectory());
    }

    private void registerListenersOnEventBus(StepListener ... stepListeners) {
        for (StepListener currentStepListener : stepListeners) {
            StepEventBus.getEventBus().registerListener(currentStepListener);
        }
    }

    private StepListener testCountListener() {
        return (StepListener)JUnitInjectors.getInjector().getInstance(Key.get(StepListener.class, TestCounter.class));
    }

    private void injectEnvironmentVariablesInto(Object testCase) {
        new EnvironmentDependencyInjector().injectDependenciesInto(testCase);
    }
}

