/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5.extension;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.stream.Collectors;
import net.thucydides.core.annotations.Manual;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.TestSourceType;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.LifecycleMethodExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestWatcher;
import org.opentest4j.TestAbortedException;

public class SerenityJUnitLifecycleAdapterExtension
implements BeforeEachCallback,
AfterAllCallback,
TestWatcher,
LifecycleMethodExecutionExceptionHandler {
    public void beforeEach(ExtensionContext extensionContext) {
        this.notifyTestStarted(extensionContext, extensionContext.getDisplayName().replace("()", ""));
        Method testMethod = extensionContext.getRequiredTestMethod();
        if (testMethod.isAnnotationPresent(Pending.class) && !testMethod.isAnnotationPresent(Manual.class)) {
            throw new PendingException();
        }
    }

    public void afterAll(ExtensionContext extensionContext) {
        StepEventBus.getEventBus().testSuiteFinished();
    }

    public void testSuccessful(ExtensionContext extensionContext) {
        this.notifyTestFinished();
    }

    public void testDisabled(ExtensionContext extensionContext, Optional<String> reason) {
        this.beforeEach(extensionContext);
        StepEventBus.getEventBus().testIgnored();
        this.notifyTestFinished();
    }

    public void testAborted(ExtensionContext extensionContext, Throwable cause) {
        if (!(cause instanceof ManualTestAbortedException)) {
            if (cause instanceof PendingException) {
                StepEventBus.getEventBus().testPending();
            } else {
                StepEventBus.getEventBus().assumptionViolated(cause.getMessage());
            }
        }
        this.notifyTestFinished();
    }

    public void testFailed(ExtensionContext extensionContext, Throwable cause) {
        StepEventBus.getEventBus().testFailed(cause);
        this.notifyTestFinished();
    }

    public void handleBeforeAllMethodExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        this.handleTestClassLevelLifecycleFailure(extensionContext, throwable, "Initialization");
    }

    public void handleAfterAllMethodExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        this.handleTestClassLevelLifecycleFailure(extensionContext, throwable, "Tear down");
    }

    private void notifyTestStarted(ExtensionContext extensionContext, String name) {
        this.startTestSuiteForFirstTest(extensionContext);
        StepEventBus.getEventBus().clear();
        StepEventBus.getEventBus().setTestSource(TestSourceType.TEST_SOURCE_JUNIT.getValue());
        StepEventBus.getEventBus().testStarted(name, extensionContext.getRequiredTestClass());
        StepEventBus.getEventBus().addTagsToCurrentTest(extensionContext.getTags().stream().map(TestTag::withValue).collect(Collectors.toList()));
    }

    private void startTestSuiteForFirstTest(ExtensionContext extensionContext) {
        if (!StepEventBus.getEventBus().testSuiteHasStarted()) {
            StepEventBus.getEventBus().testSuiteStarted(extensionContext.getRequiredTestClass());
        }
    }

    private void handleTestClassLevelLifecycleFailure(ExtensionContext extensionContext, Throwable throwable, String scenario) throws Throwable {
        this.notifyTestStarted(extensionContext, scenario);
        this.testFailed(extensionContext, throwable);
        throw throwable;
    }

    private void notifyTestFinished() {
        StepEventBus.getEventBus().testFinished();
    }

    static class ManualTestAbortedException
    extends TestAbortedException {
        private final TestResult annotatedResult;

        public ManualTestAbortedException(TestResult annotatedResult) {
            this.annotatedResult = annotatedResult;
        }

        public String toString() {
            return "SerenityJUnitLifecycleAdapterExtension.ManualTestAbortedException(annotatedResult=" + this.annotatedResult + ")";
        }
    }

    private static class PendingException
    extends TestAbortedException {
        private PendingException() {
        }
    }
}

