/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.metadata.RateLimit;
import org.springframework.ai.model.ModelOptions;
import org.springframework.ai.openai.OpenAiAudioSpeechOptions;
import org.springframework.ai.openai.api.OpenAiAudioApi;
import org.springframework.ai.openai.api.common.OpenAiApiException;
import org.springframework.ai.openai.audio.speech.Speech;
import org.springframework.ai.openai.audio.speech.SpeechClient;
import org.springframework.ai.openai.audio.speech.SpeechPrompt;
import org.springframework.ai.openai.audio.speech.SpeechResponse;
import org.springframework.ai.openai.audio.speech.StreamingSpeechClient;
import org.springframework.ai.openai.metadata.audio.OpenAiAudioSpeechResponseMetadata;
import org.springframework.ai.openai.metadata.support.OpenAiResponseHeaderExtractor;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class OpenAiAudioSpeechClient
implements SpeechClient,
StreamingSpeechClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final OpenAiAudioSpeechOptions defaultOptions;
    private static final Float SPEED = Float.valueOf(1.0f);
    public final RetryTemplate retryTemplate = RetryTemplate.builder().maxAttempts(10).retryOn(OpenAiApiException.class).exponentialBackoff(Duration.ofMillis(2000L), 5.0, Duration.ofMillis(180000L)).build();
    private final OpenAiAudioApi audioApi;

    public OpenAiAudioSpeechClient(OpenAiAudioApi audioApi) {
        this(audioApi, OpenAiAudioSpeechOptions.builder().withModel(OpenAiAudioApi.TtsModel.TTS_1.getValue()).withResponseFormat(OpenAiAudioApi.SpeechRequest.AudioResponseFormat.MP3).withVoice(OpenAiAudioApi.SpeechRequest.Voice.ALLOY).withSpeed(SPEED).build());
    }

    public OpenAiAudioSpeechClient(OpenAiAudioApi audioApi, OpenAiAudioSpeechOptions options) {
        Assert.notNull((Object)audioApi, (String)"OpenAiAudioApi must not be null");
        Assert.notNull((Object)options, (String)"OpenAiSpeechOptions must not be null");
        this.audioApi = audioApi;
        this.defaultOptions = options;
    }

    @Override
    public byte[] call(String text) {
        SpeechPrompt speechRequest = new SpeechPrompt(text);
        return this.call(speechRequest).getResult().getOutput();
    }

    @Override
    public SpeechResponse call(SpeechPrompt speechPrompt) {
        return (SpeechResponse)this.retryTemplate.execute(ctx -> {
            OpenAiAudioApi.SpeechRequest speechRequest = this.createRequestBody(speechPrompt);
            ResponseEntity<byte[]> speechEntity = this.audioApi.createSpeech(speechRequest);
            byte[] speech = (byte[])speechEntity.getBody();
            if (speech == null) {
                this.logger.warn("No speech response returned for speechRequest: {}", (Object)speechRequest);
                return new SpeechResponse(new Speech(new byte[0]));
            }
            RateLimit rateLimits = OpenAiResponseHeaderExtractor.extractAiResponseHeaders(speechEntity);
            return new SpeechResponse(new Speech(speech), new OpenAiAudioSpeechResponseMetadata(rateLimits));
        });
    }

    @Override
    public Flux<SpeechResponse> stream(SpeechPrompt prompt) {
        return this.audioApi.stream(this.createRequestBody(prompt)).map(entity -> new SpeechResponse(new Speech((byte[])entity.getBody()), new OpenAiAudioSpeechResponseMetadata(OpenAiResponseHeaderExtractor.extractAiResponseHeaders(entity))));
    }

    private OpenAiAudioApi.SpeechRequest createRequestBody(SpeechPrompt request) {
        OpenAiAudioSpeechOptions options = this.defaultOptions;
        if (request.getOptions() != null) {
            ModelOptions modelOptions = request.getOptions();
            if (modelOptions instanceof OpenAiAudioSpeechOptions) {
                OpenAiAudioSpeechOptions runtimeOptions = (OpenAiAudioSpeechOptions)modelOptions;
                options = this.merge(options, runtimeOptions);
            } else {
                throw new IllegalArgumentException("Prompt options are not of type SpeechOptions: " + request.getOptions().getClass().getSimpleName());
            }
        }
        String input = StringUtils.isNotBlank((CharSequence)options.getInput()) ? options.getInput() : request.getInstructions().getText();
        OpenAiAudioApi.SpeechRequest.Builder requestBuilder = OpenAiAudioApi.SpeechRequest.builder().withModel(options.getModel()).withInput(input).withVoice(options.getVoice()).withResponseFormat(options.getResponseFormat()).withSpeed(options.getSpeed());
        return requestBuilder.build();
    }

    private OpenAiAudioSpeechOptions merge(OpenAiAudioSpeechOptions source, OpenAiAudioSpeechOptions target) {
        OpenAiAudioSpeechOptions.Builder mergedBuilder = OpenAiAudioSpeechOptions.builder();
        mergedBuilder.withModel(source.getModel() != null ? source.getModel() : target.getModel());
        mergedBuilder.withInput(source.getInput() != null ? source.getInput() : target.getInput());
        mergedBuilder.withVoice(source.getVoice() != null ? source.getVoice() : target.getVoice());
        mergedBuilder.withResponseFormat(source.getResponseFormat() != null ? source.getResponseFormat() : target.getResponseFormat());
        mergedBuilder.withSpeed(source.getSpeed() != null ? source.getSpeed() : target.getSpeed());
        return mergedBuilder.build();
    }
}

