/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.AbstractEmbeddingClient;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.openai.OpenAiEmbeddingOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class OpenAiEmbeddingClient
extends AbstractEmbeddingClient {
    private static final Logger logger = LoggerFactory.getLogger(OpenAiEmbeddingClient.class);
    private final OpenAiEmbeddingOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final OpenAiApi openAiApi;
    private final MetadataMode metadataMode;

    public OpenAiEmbeddingClient(OpenAiApi openAiApi) {
        this(openAiApi, MetadataMode.EMBED);
    }

    public OpenAiEmbeddingClient(OpenAiApi openAiApi, MetadataMode metadataMode) {
        this(openAiApi, metadataMode, OpenAiEmbeddingOptions.builder().withModel(OpenAiApi.DEFAULT_EMBEDDING_MODEL).build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public OpenAiEmbeddingClient(OpenAiApi openAiApi, MetadataMode metadataMode, OpenAiEmbeddingOptions openAiEmbeddingOptions) {
        this(openAiApi, metadataMode, openAiEmbeddingOptions, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public OpenAiEmbeddingClient(OpenAiApi openAiApi, MetadataMode metadataMode, OpenAiEmbeddingOptions options, RetryTemplate retryTemplate) {
        Assert.notNull((Object)openAiApi, (String)"OpenAiService must not be null");
        Assert.notNull((Object)metadataMode, (String)"metadataMode must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        this.openAiApi = openAiApi;
        this.metadataMode = metadataMode;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
    }

    public List<Double> embed(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        return this.embed(document.getFormattedContent(this.metadataMode));
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        return (EmbeddingResponse)this.retryTemplate.execute(ctx -> {
            OpenAiApi.EmbeddingList apiEmbeddingResponse;
            OpenAiApi.EmbeddingRequest<Object> apiRequest;
            OpenAiApi.EmbeddingRequest<Object> embeddingRequest = apiRequest = this.defaultOptions != null ? new OpenAiApi.EmbeddingRequest(request.getInstructions(), this.defaultOptions.getModel(), this.defaultOptions.getEncodingFormat(), this.defaultOptions.getDimensions(), this.defaultOptions.getUser()) : new OpenAiApi.EmbeddingRequest<List>(request.getInstructions(), OpenAiApi.DEFAULT_EMBEDDING_MODEL);
            if (request.getOptions() != null && !EmbeddingOptions.EMPTY.equals((Object)request.getOptions())) {
                apiRequest = (OpenAiApi.EmbeddingRequest<Object>)ModelOptionsUtils.merge((Object)request.getOptions(), apiRequest, OpenAiApi.EmbeddingRequest.class);
            }
            if ((apiEmbeddingResponse = (OpenAiApi.EmbeddingList)this.openAiApi.embeddings(apiRequest).getBody()) == null) {
                logger.warn("No embeddings returned for request: {}", (Object)request);
                return new EmbeddingResponse(List.of());
            }
            EmbeddingResponseMetadata metadata = this.generateResponseMetadata(apiEmbeddingResponse.model(), apiEmbeddingResponse.usage());
            List<Embedding> embeddings = apiEmbeddingResponse.data().stream().map(e -> new Embedding(e.embedding(), e.index())).toList();
            return new EmbeddingResponse(embeddings, metadata);
        });
    }

    private EmbeddingResponseMetadata generateResponseMetadata(String model, OpenAiApi.Usage usage) {
        EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata();
        metadata.put((Object)"model", (Object)model);
        metadata.put((Object)"prompt-tokens", (Object)usage.promptTokens());
        metadata.put((Object)"completion-tokens", (Object)usage.completionTokens());
        metadata.put((Object)"total-tokens", (Object)usage.totalTokens());
        return metadata;
    }
}

