/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.metadata;

import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.util.Assert;

public class OpenAiUsage
implements Usage {
    private final OpenAiApi.Usage usage;

    public static OpenAiUsage from(OpenAiApi.Usage usage) {
        return new OpenAiUsage(usage);
    }

    protected OpenAiUsage(OpenAiApi.Usage usage) {
        Assert.notNull((Object)usage, (String)"OpenAI Usage must not be null");
        this.usage = usage;
    }

    protected OpenAiApi.Usage getUsage() {
        return this.usage;
    }

    public Long getPromptTokens() {
        return this.getUsage().promptTokens().longValue();
    }

    public Long getGenerationTokens() {
        return this.getUsage().completionTokens().longValue();
    }

    public Long getTotalTokens() {
        return this.getUsage().totalTokens().longValue();
    }

    public String toString() {
        return this.getUsage().toString();
    }
}

