/*
 * Copyright 2023 - 2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.ai.autoconfigure.qwen;

import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.qwen.QWenAiEmbeddingOptions;
import org.springframework.ai.qwen.api.QWenAiApi;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * @author Ricken Bazolo
 * @since 0.8.1
 */
@ConfigurationProperties(QWenAiEmbeddingProperties.CONFIG_PREFIX)
public class QWenAiEmbeddingProperties extends QWenAiParentProperties {

	public static final String CONFIG_PREFIX = "spring.ai.qwen.embedding";

	public static final String DEFAULT_EMBEDDING_MODEL = QWenAiApi.EmbeddingModel.V2.getValue();

	public static final String DEFAULT_ENCODING_FORMAT = "float";

	/**
	 * Enable QWenAI embedding client.
	 */
	private boolean enabled = true;

	public MetadataMode metadataMode = MetadataMode.EMBED;

	@NestedConfigurationProperty
	private QWenAiEmbeddingOptions options = QWenAiEmbeddingOptions.builder()
		.withModel(DEFAULT_EMBEDDING_MODEL)
		.withEncodingFormat(DEFAULT_ENCODING_FORMAT)
		.build();

	public QWenAiEmbeddingProperties() {
		super.setBaseUrl(QWenAiCommonProperties.DEFAULT_BASE_URL);
	}

	public QWenAiEmbeddingOptions getOptions() {
		return this.options;
	}

	public void setOptions(QWenAiEmbeddingOptions options) {
		this.options = options;
	}

	public MetadataMode getMetadataMode() {
		return this.metadataMode;
	}

	public void setMetadataMode(MetadataMode metadataMode) {
		this.metadataMode = metadataMode;
	}

	public boolean isEnabled() {
		return this.enabled;
	}

	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}

}
