/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.bedrock.anthropic3;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionConfiguration;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionProperties;
import org.springframework.ai.autoconfigure.bedrock.anthropic3.BedrockAnthropic3ChatProperties;
import org.springframework.ai.bedrock.anthropic3.BedrockAnthropic3ChatClient;
import org.springframework.ai.bedrock.anthropic3.api.Anthropic3ChatBedrockApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@AutoConfiguration
@ConditionalOnClass(value={Anthropic3ChatBedrockApi.class})
@EnableConfigurationProperties(value={BedrockAnthropic3ChatProperties.class, BedrockAwsConnectionProperties.class})
@ConditionalOnProperty(prefix="spring.ai.bedrock.anthropic3.chat", name={"enabled"}, havingValue="true")
@Import(value={BedrockAwsConnectionConfiguration.class})
public class BedrockAnthropic3ChatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Anthropic3ChatBedrockApi anthropicApi(AwsCredentialsProvider credentialsProvider, BedrockAnthropic3ChatProperties properties, BedrockAwsConnectionProperties awsProperties) {
        return new Anthropic3ChatBedrockApi(properties.getModel(), credentialsProvider, awsProperties.getRegion(), new ObjectMapper(), awsProperties.getTimeout());
    }

    @Bean
    public BedrockAnthropic3ChatClient anthropicChatClient(Anthropic3ChatBedrockApi anthropicApi, BedrockAnthropic3ChatProperties properties) {
        return new BedrockAnthropic3ChatClient(anthropicApi, properties.getOptions());
    }
}

