/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.bedrock.cohere;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionConfiguration;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionProperties;
import org.springframework.ai.autoconfigure.bedrock.cohere.BedrockCohereEmbeddingProperties;
import org.springframework.ai.bedrock.cohere.BedrockCohereEmbeddingClient;
import org.springframework.ai.bedrock.cohere.api.CohereEmbeddingBedrockApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@AutoConfiguration
@ConditionalOnClass(value={CohereEmbeddingBedrockApi.class})
@EnableConfigurationProperties(value={BedrockCohereEmbeddingProperties.class, BedrockAwsConnectionProperties.class})
@ConditionalOnProperty(prefix="spring.ai.bedrock.cohere.embedding", name={"enabled"}, havingValue="true")
@Import(value={BedrockAwsConnectionConfiguration.class})
public class BedrockCohereEmbeddingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CohereEmbeddingBedrockApi cohereEmbeddingApi(AwsCredentialsProvider credentialsProvider, BedrockCohereEmbeddingProperties properties, BedrockAwsConnectionProperties awsProperties) {
        return new CohereEmbeddingBedrockApi(properties.getModel(), credentialsProvider, awsProperties.getRegion(), new ObjectMapper(), awsProperties.getTimeout());
    }

    @Bean
    @ConditionalOnMissingBean
    public BedrockCohereEmbeddingClient cohereEmbeddingClient(CohereEmbeddingBedrockApi cohereEmbeddingApi, BedrockCohereEmbeddingProperties properties) {
        return new BedrockCohereEmbeddingClient(cohereEmbeddingApi, properties.getOptions());
    }
}

